/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader.decorator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.AjaxElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import ru.yandex.qatools.htmlelements.annotations.Timeout;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementClassAnnotationsHandler;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementFieldAnnotationsHandler;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;

public class HtmlElementLocatorFactory
implements CustomElementLocatorFactory {
    private final SearchContext searchContext;

    public HtmlElementLocatorFactory(SearchContext searchContext) {
        this.searchContext = searchContext;
    }

    public ElementLocator createLocator(Field field) {
        return new AjaxElementLocator(this.searchContext, this.getTimeOut(field), (AbstractAnnotations)new HtmlElementFieldAnnotationsHandler(field));
    }

    @Override
    public ElementLocator createLocator(Class clazz) {
        return new AjaxElementLocator(this.searchContext, this.getTimeOut(clazz), new HtmlElementClassAnnotationsHandler(clazz));
    }

    public int getTimeOut(Field field) {
        if (field.isAnnotationPresent(Timeout.class)) {
            return field.getAnnotation(Timeout.class).value();
        }
        if (field.getGenericType() instanceof Class) {
            return this.getTimeOut((Class)field.getGenericType());
        }
        return this.getTimeOut((Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0]);
    }

    public int getTimeOut(Class clazz) {
        try {
            Method method = Timeout.class.getMethod("value", new Class[0]);
            do {
                if (!clazz.isAnnotationPresent(Timeout.class)) continue;
                return (Integer)method.invoke((Object)clazz.getAnnotation(Timeout.class), new Object[0]);
            } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return Integer.getInteger("webdriver.timeouts.implicitlywait", 5);
    }
}

