/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.utils;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.RemoteWebElement;
import ru.yandex.qatools.htmlelements.annotations.Name;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;

public final class HtmlElementUtils {
    private HtmlElementUtils() {
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
            Class<?> outerClass = clazz.getDeclaringClass();
            Object outerObject = outerClass.newInstance();
            return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])Lists.asList(outerObject, (Object[])args).toArray());
        }
        return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])args);
    }

    public static boolean isHtmlElement(Field field) {
        return HtmlElementUtils.isHtmlElement(field.getType());
    }

    public static boolean isHtmlElement(Class<?> clazz) {
        return HtmlElement.class.isAssignableFrom(clazz);
    }

    public static <T> boolean isHtmlElement(T instance) {
        return HtmlElement.class.isInstance(instance);
    }

    public static boolean isTypifiedElement(Field field) {
        return HtmlElementUtils.isTypifiedElement(field.getType());
    }

    public static boolean isTypifiedElement(Class<?> clazz) {
        return TypifiedElement.class.isAssignableFrom(clazz);
    }

    public static boolean isWebElement(Field field) {
        return HtmlElementUtils.isWebElement(field.getType());
    }

    public static boolean isWebElement(Class<?> clazz) {
        return WebElement.class.isAssignableFrom(clazz);
    }

    public static boolean isHtmlElementList(Field field) {
        if (!HtmlElementUtils.isParametrizedList(field)) {
            return false;
        }
        Class listParameterClass = HtmlElementUtils.getGenericParameterClass(field);
        return HtmlElementUtils.isHtmlElement(listParameterClass);
    }

    public static boolean isTypifiedElementList(Field field) {
        if (!HtmlElementUtils.isParametrizedList(field)) {
            return false;
        }
        Class listParameterClass = HtmlElementUtils.getGenericParameterClass(field);
        return HtmlElementUtils.isTypifiedElement(listParameterClass);
    }

    public static boolean isWebElementList(Field field) {
        if (!HtmlElementUtils.isParametrizedList(field)) {
            return false;
        }
        Class listParameterClass = HtmlElementUtils.getGenericParameterClass(field);
        return HtmlElementUtils.isWebElement(listParameterClass);
    }

    public static Class getGenericParameterClass(Field field) {
        Type genericType = field.getGenericType();
        return (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
    }

    private static boolean isParametrizedList(Field field) {
        return HtmlElementUtils.isList(field) && HtmlElementUtils.hasGenericParameter(field);
    }

    private static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    private static boolean hasGenericParameter(Field field) {
        return field.getGenericType() instanceof ParameterizedType;
    }

    public static String getElementName(Field field) {
        if (field.isAnnotationPresent(Name.class)) {
            return field.getAnnotation(Name.class).value();
        }
        if (field.getType().isAnnotationPresent(Name.class)) {
            return field.getType().getAnnotation(Name.class).value();
        }
        return HtmlElementUtils.splitCamelCase(field.getName());
    }

    public static <T> String getElementName(Class<T> clazz) {
        if (clazz.isAnnotationPresent(Name.class)) {
            return clazz.getAnnotation(Name.class).value();
        }
        return HtmlElementUtils.splitCamelCase(clazz.getSimpleName());
    }

    private static String splitCamelCase(String camel) {
        return WordUtils.capitalizeFully((String)camel.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " "));
    }

    public static boolean isRemoteWebElement(WebElement element) {
        return element.getClass().equals(RemoteWebElement.class);
    }

    public static boolean isOnRemoteWebDriver(WebElement element) {
        if (!HtmlElementUtils.isRemoteWebElement(element)) {
            return false;
        }
        RemoteWebElement remoteWebElement = (RemoteWebElement)element;
        try {
            Field elementParentFiled = RemoteWebElement.class.getDeclaredField("parent");
            elementParentFiled.setAccessible(true);
            WebDriver elementParent = (WebDriver)elementParentFiled.get(remoteWebElement);
            return elementParent.getClass().equals(RemoteWebDriver.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new HtmlElementsException("Unable to find out if WebElement is on remote driver", e);
        }
    }

    public static boolean existsInClasspath(String fileName) {
        return HtmlElementUtils.getResourceFromClasspath(fileName) != null;
    }

    public static URL getResourceFromClasspath(String fileName) {
        return Thread.currentThread().getContextClassLoader().getResource(fileName);
    }
}

