/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.audiodemo;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import ru.sbtqa.monte.media.AudioFormatKeys;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.avi.AVIOutputStream;
import ru.sbtqa.monte.media.avi.AVIWriter;
import ru.sbtqa.monte.media.math.Rational;

public class AudioRecorder
implements Runnable {
    private volatile Thread worker;
    private File file;

    public AudioRecorder(File file) {
        this.file = file;
    }

    public void start() throws LineUnavailableException {
        this.stop();
        this.worker = new Thread(this);
        this.worker.start();
    }

    public void stop() {
        if (this.worker != null) {
            Thread stopMe = this.worker;
            this.worker = null;
            try {
                stopMe.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DataLine.Info lineInfo = new DataLine.Info(TargetDataLine.class, new AudioFormat(44100.0f, 16, 2, true, true));
        AVIOutputStream writer = null;
        TargetDataLine line = null;
        try {
            line = (TargetDataLine)AudioSystem.getLine(lineInfo);
            AudioFormat lineFormat = line.getFormat();
            Buffer buf = new Buffer();
            buf.format = AudioFormatKeys.fromAudioFormat(lineFormat);
            buf.sampleDuration = new Rational(1L, (long)lineFormat.getSampleRate());
            buf.data = new byte[(int)((float)lineFormat.getFrameSize() * lineFormat.getSampleRate())];
            writer = new AVIWriter(this.file);
            ((AVIWriter)writer).addTrack(buf.format);
            line.open();
            line.start();
            while (this.worker == Thread.currentThread()) {
                buf.length = line.read((byte[])buf.data, 0, ((byte[])buf.data).length);
                buf.sampleCount = buf.length / lineFormat.getFrameSize();
                ((AVIWriter)writer).write(0, buf);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
        }
        finally {
            if (line != null) {
                line.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) throws IOException, LineUnavailableException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
        File file = new File(System.getProperty("user.home"), "Movies/AudioRecording " + dateFormat.format(new Date()) + ".avi");
        if (!file.getParentFile().isDirectory()) {
            file.getParentFile().mkdirs();
        }
        System.out.println("Press ENTER to start audio recording.");
        while (System.in.read() != 10) {
        }
        AudioRecorder r = new AudioRecorder(file);
        r.start();
        System.out.println("Press ENTER to stop audio recording.");
        while (System.in.read() != 10) {
        }
        r.stop();
        System.out.println("You can find the recorded audio in file");
        System.out.println(file);
    }
}

