/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.avidemo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.avi.AVIReader;
import ru.sbtqa.monte.media.avi.AVIWriter;
import ru.sbtqa.monte.media.math.Rational;

public class Main {
    public static void main(String[] args) {
        System.out.println("AVIDemo " + Main.class.getPackage().getImplementationVersion());
        System.out.println("This is a demo of the Monte Media library.");
        System.out.println("Copyright \u00a9 Werner Randelshofer. All Rights Reserved.");
        System.out.println("License: Creative Commons Attribution 3.0.");
        System.out.println();
        try {
            Main.test(new File("avidemo-jpg.avi"), new Format(VideoFormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(1.0f)));
            Main.test(new File("avidemo-jpg-q0.5.avi"), new Format(VideoFormatKeys.EncodingKey, "MJPG", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.QualityKey, Float.valueOf(0.5f)));
            Main.test(new File("avidemo-png.avi"), new Format(VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("avidemo-raw24.avi"), new Format(VideoFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0000", VideoFormatKeys.DepthKey, 24));
            Main.test(new File("avidemo-raw8.avi"), new Format(VideoFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0000", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-rle8.avi"), new Format(VideoFormatKeys.EncodingKey, "\u0002\u0000\u0000\u0000", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-tscc8.avi"), new Format(VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 8));
            Main.test(new File("avidemo-raw8gray.avi"), new Format(new Object[]{VideoFormatKeys.EncodingKey, "\u0000\u0000\u0000\u0000", VideoFormatKeys.DepthKey, 8, VideoFormatKeys.PixelFormatKey, VideoFormatKeys.PixelFormat.GRAY}));
            Main.test(new File("avidemo-rle8gray.avi"), new Format(new Object[]{VideoFormatKeys.EncodingKey, "\u0002\u0000\u0000\u0000", VideoFormatKeys.DepthKey, 8, VideoFormatKeys.PixelFormatKey, VideoFormatKeys.PixelFormat.GRAY}));
            Main.test(new File("avidemo-tscc8gray.avi"), new Format(new Object[]{VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 8, VideoFormatKeys.PixelFormatKey, VideoFormatKeys.PixelFormat.GRAY}));
            Main.test(new File("avidemo-tscc24.avi"), new Format(VideoFormatKeys.EncodingKey, "tscc", VideoFormatKeys.DepthKey, 24));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private static void test(File file, Format format) throws IOException {
        Main.testWriting(file, format);
        try {
            Main.testReading(file);
        }
        catch (UnsupportedOperationException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testWriting(File file, Format format) throws IOException {
        System.out.println("Writing " + file);
        format = format.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.FrameRateKey, new Rational(30L, 1L), VideoFormatKeys.WidthKey, 400, VideoFormatKeys.HeightKey, 400});
        BufferedImage img = Main.createImage(format);
        Graphics2D g = img.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        AVIWriter out = null;
        try {
            out = new AVIWriter(file);
            out.addTrack(format);
            out.setPalette(0, img.getColorModel());
            g.setBackground(Color.WHITE);
            g.setColor(Color.BLACK);
            int rhour = Math.min(img.getWidth(), img.getHeight()) / 2 - 50;
            int rminute = Math.min(img.getWidth(), img.getHeight()) / 2 - 30;
            int cx = img.getWidth() / 2;
            int cy = img.getHeight() / 2;
            BasicStroke sfine = new BasicStroke(1.0f);
            BasicStroke shour = new BasicStroke(7.0f);
            BasicStroke sminute = new BasicStroke(5.0f);
            int n = 200;
            for (int i = 0; i < n; ++i) {
                double tminute = (double)i / (double)(n - 1);
                double thour = tminute / 60.0;
                g.clearRect(0, 0, img.getWidth(), img.getHeight());
                Line2D.Double lhour = new Line2D.Double(cx, cy, (double)cx + Math.sin(thour * Math.PI * 2.0) * (double)rhour, (double)cy - Math.cos(thour * Math.PI * 2.0) * (double)rhour);
                g.setColor(Color.BLACK);
                g.setStroke(shour);
                g.draw(lhour);
                Line2D.Double lminute = new Line2D.Double(cx, cy, (double)cx + Math.sin(tminute * Math.PI * 2.0) * (double)rminute, (double)cy - Math.cos(tminute * Math.PI * 2.0) * (double)rminute);
                g.setStroke(sminute);
                g.draw(lminute);
                out.write(0, img, 1L);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
            g.dispose();
        }
    }

    private static void testReading(File file) throws IOException {
        System.out.println("Reading " + file);
        try (AVIReader in = null;){
            int track;
            in = new AVIReader(file);
            for (track = 0; track < in.getTrackCount() && in.getFormat(track).get(VideoFormatKeys.MediaTypeKey) != FormatKeys.MediaType.VIDEO; ++track) {
            }
            BufferedImage img = null;
            while ((img = in.read(track, img)) != null) {
            }
        }
    }

    private static BufferedImage createImage(Format format) {
        BufferedImage img;
        int depth = format.get(VideoFormatKeys.DepthKey);
        int width = format.get(VideoFormatKeys.WidthKey);
        int height = format.get(VideoFormatKeys.HeightKey);
        VideoFormatKeys.PixelFormat pixelFormat = format.get(VideoFormatKeys.PixelFormatKey);
        Random rnd = new Random(0L);
        switch (depth) {
            default: {
                img = new BufferedImage(width, height, 1);
                break;
            }
            case 8: {
                if (pixelFormat == VideoFormatKeys.PixelFormat.GRAY) {
                    img = new BufferedImage(width, height, 10);
                    break;
                }
                byte[] red = new byte[256];
                byte[] green = new byte[256];
                byte[] blue = new byte[256];
                for (int i = 0; i < 255; ++i) {
                    red[i] = (byte)rnd.nextInt(256);
                    green[i] = (byte)rnd.nextInt(256);
                    blue[i] = (byte)rnd.nextInt(256);
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(8, 256, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
            case 4: {
                if (pixelFormat == VideoFormatKeys.PixelFormat.GRAY) {
                    img = new BufferedImage(width, height, 10);
                    break;
                }
                byte[] red = new byte[16];
                byte[] green = new byte[16];
                byte[] blue = new byte[16];
                for (int i = 0; i < 15; ++i) {
                    red[i] = (byte)rnd.nextInt(16);
                    green[i] = (byte)rnd.nextInt(16);
                    blue[i] = (byte)rnd.nextInt(16);
                }
                rnd.setSeed(0L);
                IndexColorModel palette = new IndexColorModel(4, 16, red, green, blue);
                img = new BufferedImage(width, height, 13, palette);
                break;
            }
        }
        return img;
    }
}

