/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.ilbmdemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.sbtqa.monte.media.gui.Worker;
import ru.sbtqa.monte.media.ilbm.ColorCyclingMemoryImageSource;
import ru.sbtqa.monte.media.ilbm.ILBMDecoder;
import ru.sbtqa.monte.media.io.ByteArrayImageInputStream;

public class ILBMViewer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Handler handler = new Handler();
    private JLabel label;

    public ILBMViewer() {
        this.initComponents();
        new DropTarget(this, this.handler);
        new DropTarget(this.label, this.handler);
    }

    protected BufferedImage getAmigaPicture(File f) throws IOException {
        return ImageIO.read(f);
    }

    protected BufferedImage getAmigaPictureViaByteArray(File f) throws IOException {
        return this.getAmigaPicture(this.getData(f));
    }

    /*
     * Exception decompiling
     */
    protected byte[] getData(File f) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected BufferedImage getAmigaPicture(byte[] data) throws IOException {
        return ImageIO.read(new ByteArrayImageInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getAmigaPictureWithColorCycling(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            ColorCyclingMemoryImageSource ccmis = new ILBMDecoder(in).produce().get(0);
            if (ccmis.isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(ccmis);
            return image;
        }
    }

    public void showILBMImages(final List<File> files) {
        this.label.setEnabled(false);
        if (this.label.getIcon() instanceof ImageIcon) {
            ImageIcon icon = (ImageIcon)this.label.getIcon();
            this.label.setIcon(null);
            this.label.setDisabledIcon(null);
            icon.getImage().flush();
        }
        new Worker<Image>(){

            @Override
            protected Image construct() throws Exception {
                Iterator iterator = files.iterator();
                if (iterator.hasNext()) {
                    File f = (File)iterator.next();
                    return ILBMViewer.this.getAmigaPictureWithColorCycling(f);
                }
                return null;
            }

            @Override
            protected void done(Image value) {
                if (value == null) {
                    this.failed(new IOException("Could not load image."));
                    return;
                }
                ILBMViewer.this.label.setText(null);
                ImageIcon icon = new ImageIcon(value);
                ILBMViewer.this.label.setIcon(icon);
                ILBMViewer.this.label.setDisabledIcon(icon);
                SwingUtilities.getWindowAncestor(ILBMViewer.this).pack();
            }

            @Override
            protected void failed(Throwable error) {
                ILBMViewer.this.label.setText("<html><b>Error</b><br>" + error.getMessage());
                SwingUtilities.getWindowAncestor(ILBMViewer.this).pack();
            }

            @Override
            protected void finished() {
                ILBMViewer.this.label.setEnabled(true);
            }
        }.start();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.label.setHorizontalAlignment(0);
        this.label.setText("Drop ILBM file here.");
        this.add((Component)this.label, "Center");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("ILBM Image Viewer");
                f.setDefaultCloseOperation(3);
                f.add(new ILBMViewer());
                f.setSize(200, 200);
                f.setVisible(true);
            }
        });
    }

    private class Handler
    implements DropTargetListener {
        private Handler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                try {
                    List files = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    ILBMViewer.this.showILBMImages(files);
                }
                catch (IOException e) {
                    JOptionPane.showConfirmDialog(ILBMViewer.this, "Could not access the dropped data.", "ILBMViewer: Drop Failed", -1, 1);
                }
                catch (UnsupportedFlavorException e) {
                    JOptionPane.showConfirmDialog(ILBMViewer.this, "Unsupported data flavor.", "ILBMViewer: Drop Failed", -1, 1);
                }
            } else {
                event.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

