/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.iodemo;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Codec;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.MovieReader;
import ru.sbtqa.monte.media.Registry;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.image.Images;

public class ReadAVIDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        final ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        final File f = new File("/Users/Shared/Developer/Java/MonteMedia/current/trunk/MonteMedia/avidemo-tscc8.avi");
        try (MovieReader in = Registry.getInstance().getReader(f);){
            Format format = new Format(VideoFormatKeys.EncodingKey, "image");
            int track = in.findTrack(0, new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO}));
            if (track == -1) {
                throw new IOException("Movie has no video track.");
            }
            Codec codec = Registry.getInstance().getCodec(in.getFormat(track), format);
            if (codec == null) {
                throw new IOException("Can not decode video track.");
            }
            Buffer inBuf = new Buffer();
            Buffer codecBuf = new Buffer();
            do {
                in.read(track, inBuf);
                if (codec.process(inBuf, codecBuf) == 1) {
                    System.out.println("Can not decode buffer " + inBuf);
                }
                if (codecBuf.isFlag(BufferFlag.DISCARD)) continue;
                frames.add(Images.cloneImage((BufferedImage)codecBuf.data));
            } while (!inBuf.isFlag(BufferFlag.END_OF_MEDIA));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame fr = new JFrame(f.getName());
                fr.setDefaultCloseOperation(3);
                final JLabel label = new JLabel(new ImageIcon((Image)frames.get(0)));
                final JSlider slider = new JSlider(0, 0, frames.size() - 1, 0);
                slider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        label.setIcon(new ImageIcon((Image)frames.get(slider.getValue())));
                    }
                });
                fr.add("Center", label);
                fr.add("South", slider);
                fr.pack();
                fr.setVisible(true);
            }
        });
    }
}

