/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media;

import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import ru.sbtqa.monte.media.Animator;
import ru.sbtqa.monte.media.Interpolator;

public class DefaultAnimator
implements Animator {
    protected EventListenerList listenerList = new EventListenerList();
    private final ArrayList<Interpolator> activeInterpolators;
    private final ArrayList<Interpolator> newInterpolators;
    private Thread animationThread;
    private boolean isAnimating;
    private Object lock = new Object();
    protected ChangeEvent changeEvent;
    private int sleep = 33;

    public DefaultAnimator() {
        this.activeInterpolators = new ArrayList();
        this.newInterpolators = new ArrayList();
    }

    @Override
    public void setLock(Object lock) {
        this.lock = lock;
    }

    @Override
    public boolean isActive() {
        return this.animationThread != null;
    }

    @Override
    public void start() {
        this.stop();
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    @Override
    public void stop() {
        if (this.animationThread != null) {
            Thread t = this.animationThread;
            this.animationThread = null;
            t.interrupt();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Interpolator interpolator) {
        ArrayList<Interpolator> arrayList = this.newInterpolators;
        synchronized (arrayList) {
            this.newInterpolators.add(interpolator);
            if (!this.isActive()) {
                this.start();
            }
        }
    }

    @Override
    public void animateStep() {
        int i;
        long now = System.currentTimeMillis();
        for (i = 0; i < this.newInterpolators.size(); ++i) {
            Interpolator before;
            int j;
            Interpolator candidate = this.newInterpolators.get(i);
            boolean isEnqueueable = true;
            for (j = 0; j < i; ++j) {
                before = this.newInterpolators.get(j);
                if (!candidate.isSequential(before)) continue;
                isEnqueueable = false;
                break;
            }
            if (isEnqueueable) {
                for (j = 0; j < this.activeInterpolators.size(); ++j) {
                    before = this.activeInterpolators.get(j);
                    if (candidate.replaces(before)) {
                        before.finish(now);
                    }
                    if (!candidate.isSequential(before)) continue;
                    isEnqueueable = false;
                    break;
                }
            }
            if (!isEnqueueable) continue;
            candidate.initialize(now);
            this.activeInterpolators.add(candidate);
            this.newInterpolators.remove(i--);
        }
        for (i = 0; i < this.activeInterpolators.size(); ++i) {
            Interpolator active = this.activeInterpolators.get(i);
            if (active.isFinished()) {
                this.activeInterpolators.remove(i--);
                continue;
            }
            if (active.isElapsed(now)) {
                active.finish(now);
                this.activeInterpolators.remove(i--);
                continue;
            }
            active.interpolate(now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<Interpolator> arrayList;
        while (Thread.currentThread() == this.animationThread) {
            Object object = this.lock;
            synchronized (object) {
                this.animateStep();
            }
            boolean hasFinished = false;
            arrayList = this.newInterpolators;
            synchronized (arrayList) {
                if (this.activeInterpolators.isEmpty() && this.newInterpolators.isEmpty()) {
                    this.animationThread = null;
                    hasFinished = true;
                }
            }
            if (hasFinished) {
                this.fireStateChanged();
                return;
            }
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        ArrayList<Interpolator> arrayList2 = this.newInterpolators;
        synchronized (arrayList2) {
            arrayList = this.lock;
            synchronized (arrayList) {
                int i;
                long now = System.currentTimeMillis();
                for (i = 0; i < this.activeInterpolators.size(); ++i) {
                    Interpolator active = this.activeInterpolators.get(i);
                    active.finish(now);
                }
                for (i = 0; i < this.newInterpolators.size(); ++i) {
                    Interpolator candidate = this.newInterpolators.get(i);
                    candidate.initialize(now);
                    candidate.finish(now);
                }
                this.activeInterpolators.clear();
                this.newInterpolators.clear();
            }
        }
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    @Override
    public boolean isSynchronous() {
        return false;
    }
}

