/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media;

import java.nio.ByteOrder;
import ru.sbtqa.monte.media.AudioFormatKeys;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.math.Rational;

public class FormatFormatter {
    private static String audioToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append(((String)f.get(VideoFormatKeys.EncodingKey)).equals("\u0000\u0000\u0000\u0001") ? "PCM" : (String)f.get(VideoFormatKeys.EncodingKey)).append(", ").append(f.get(AudioFormatKeys.ChannelsKey)).append(" channel(s)").append(", ").append(f.get(AudioFormatKeys.SampleSizeInBitsKey)).append("-bit").append(f.get(AudioFormatKeys.SignedKey) != false ? " signed" : " unsigned").append(f.get(AudioFormatKeys.ByteOrderKey) == ByteOrder.BIG_ENDIAN ? " BE" : " LE").append(", ").append(f.get(AudioFormatKeys.SampleRateKey)).append(" Hz, ").append("");
        return buf.toString();
    }

    private static String videoToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append((String)f.get(VideoFormatKeys.EncodingKey)).append(", ").append(f.get(VideoFormatKeys.WidthKey)).append("x").append(f.get(VideoFormatKeys.HeightKey)).append(", ").append(f.get(VideoFormatKeys.DepthKey)).append("-bit, ").append(f.get(VideoFormatKeys.FrameRateKey, new Rational(0L, 0L))).append(" fps").append(f.get(VideoFormatKeys.FixedFrameRateKey, false) != false ? ", fixed rate" : "").append(f.get(VideoFormatKeys.PixelAspectRatioKey, new Rational(1L, 1L)).equals(new Rational(1L, 1L)) ? "" : ", " + f.get(VideoFormatKeys.PixelAspectRatioKey) + " pixel ratio").append("");
        return buf.toString();
    }

    private static String fileToString(Format f) {
        StringBuilder buf = new StringBuilder();
        buf.append((String)f.get(VideoFormatKeys.MimeTypeKey));
        return buf.toString();
    }

    public static String toString(Format f) {
        switch (f.get(VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO)) {
            case AUDIO: {
                return FormatFormatter.audioToString(f);
            }
            case VIDEO: {
                return FormatFormatter.videoToString(f);
            }
            case FILE: {
                return FormatFormatter.fileToString(f);
            }
        }
        return f.toString();
    }
}

