/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media;

public abstract class Interpolator {
    private float startValue;
    private float endValue;
    private long startTime;
    private long timespan;
    private boolean isFinished;

    public Interpolator() {
        this(0.0f, 1.0f);
    }

    public Interpolator(long timespan) {
        this(0.0f, 1.0f, timespan);
    }

    public Interpolator(boolean reverse) {
        this(reverse ? 1.0f : 0.0f, reverse ? 0.0f : 1.0f);
    }

    public Interpolator(float startValue, float endValue) {
        this(startValue, endValue, 1000L);
    }

    public Interpolator(float startValue, float endValue, long timespan) {
        this.startValue = startValue;
        this.endValue = endValue;
        this.timespan = timespan;
    }

    protected abstract void update(float var1);

    protected float getFraction(float linearFraction) {
        return linearFraction;
    }

    public boolean replaces(Interpolator that) {
        return false;
    }

    public void initialize(long currentTimeMillis) {
        this.startTime = currentTimeMillis;
        this.update(this.getFraction(this.startValue));
    }

    public boolean isElapsed(long currentTimeMillis) {
        return this.timespan <= currentTimeMillis - this.startTime;
    }

    public void interpolate(long currentTimeMillis) {
        long elapsed = Math.min(this.timespan, currentTimeMillis - this.startTime);
        float weight = (float)elapsed / (float)this.timespan;
        this.update(this.getFraction(this.startValue * (1.0f - weight) + this.endValue * weight));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(long currentTimeMillis) {
        if (!this.isFinished) {
            this.update(this.getFraction(this.endValue));
            this.isFinished = true;
            Interpolator interpolator = this;
            synchronized (interpolator) {
                this.notifyAll();
            }
        }
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean isSequential(Interpolator that) {
        return false;
    }

    public void setTimespan(long t) {
        this.timespan = t;
    }
}

