/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.anim;

import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Track;
import ru.sbtqa.monte.media.anim.ANIMDemultiplexer;
import ru.sbtqa.monte.media.image.BitmapImage;
import ru.sbtqa.monte.media.math.Rational;

public class ANIMTrack
implements Track {
    private ANIMDemultiplexer demux;
    private long position;

    public ANIMTrack(ANIMDemultiplexer demux) {
        this.demux = demux;
    }

    @Override
    public long getSampleCount() {
        return this.demux.getFrameCount();
    }

    @Override
    public void setPosition(long pos) {
        this.position = pos;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public void read(Buffer buf) {
        if (this.position < (long)this.demux.getFrameCount()) {
            buf.setFlagsTo(BufferFlag.KEYFRAME);
            if (!(buf.data instanceof BitmapImage)) {
                buf.data = this.demux.createCompatibleBitmap();
            }
            this.demux.readFrame((int)this.position, (BitmapImage)buf.data);
            buf.sampleDuration = new Rational(this.demux.getDuration((int)this.position), this.demux.getJiffies());
            ++this.position;
        } else {
            buf.setFlagsTo(BufferFlag.DISCARD);
        }
    }
}

