/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.anim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.MovieWriter;
import ru.sbtqa.monte.media.anim.ANIMMultiplexer;
import ru.sbtqa.monte.media.anim.AmigaVideoFormatKeys;
import ru.sbtqa.monte.media.math.Rational;

public class ANIMWriter
extends ANIMMultiplexer
implements MovieWriter {
    public static final Format ANIM = new Format(new Object[]{AmigaVideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, AmigaVideoFormatKeys.MimeTypeKey, "x-iff/anim"});
    private ArrayList<Track> tracks = new ArrayList();

    @Override
    public Format getFileFormat() throws IOException {
        return ANIM;
    }

    @Override
    public Rational getDuration(int track) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ANIMWriter(File file) throws IOException {
        super(file);
    }

    @Override
    public int addTrack(Format format) throws IOException {
        if (this.tracks.size() > 0) {
            throw new UnsupportedOperationException("only 1 track supported");
        }
        Format derivedFormat = format.prepend(new Object[]{AmigaVideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, AmigaVideoFormatKeys.MimeTypeKey, "x-iff/anim", AmigaVideoFormatKeys.EncodingKey, "op5", AmigaVideoFormatKeys.DataClassKey, byte[].class, AmigaVideoFormatKeys.FixedFrameRateKey, false});
        this.setCAMG(AmigaVideoFormatKeys.toCAMG(derivedFormat));
        Track tr = new Track();
        tr.format = derivedFormat;
        this.tracks.add(tr);
        return this.tracks.size() - 1;
    }

    @Override
    public Format getFormat(int track) {
        return this.tracks.get((int)track).format;
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    public boolean isVFRSupported() {
        return true;
    }

    @Override
    public boolean isDataLimitReached() {
        return false;
    }

    @Override
    public boolean isEmpty(int track) {
        return this.inputTime.isZero();
    }

    private static class Track {
        Format format;

        private Track() {
        }
    }
}

