/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.avi;

import java.awt.Dimension;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.AbortException;
import ru.sbtqa.monte.media.AudioFormatKeys;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.ParseException;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.avi.AbstractAVIStream;
import ru.sbtqa.monte.media.io.ByteArrayImageInputStream;
import ru.sbtqa.monte.media.math.Rational;
import ru.sbtqa.monte.media.riff.RIFFChunk;
import ru.sbtqa.monte.media.riff.RIFFParser;
import ru.sbtqa.monte.media.riff.RIFFVisitor;

public class AVIInputStream
extends AbstractAVIStream {
    protected final ImageInputStream in;
    private boolean isRealized = false;
    protected AbstractAVIStream.MainHeader mainHeader;
    protected ArrayList<AbstractAVIStream.Sample> idx1 = new ArrayList();
    private long moviOffset = 0L;

    public AVIInputStream(File file) throws IOException {
        this.in = new FileImageInputStream(file);
        this.in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.streamOffset = 0L;
    }

    public AVIInputStream(ImageInputStream in) throws IOException {
        this.in = in;
        this.streamOffset = in.getStreamPosition();
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
    }

    protected void ensureRealized() throws IOException {
        if (!this.isRealized) {
            this.isRealized = true;
            this.readAllMetadata();
        }
        if (this.mainHeader == null) {
            throw new IOException("AVI main header missing.");
        }
    }

    public int getHeaderFlags() throws IOException {
        this.ensureRealized();
        return this.mainHeader.flags;
    }

    public Dimension getVideoDimension() throws IOException {
        this.ensureRealized();
        return (Dimension)this.mainHeader.size.clone();
    }

    public int getTrackCount() throws IOException {
        this.ensureRealized();
        return this.tracks.size();
    }

    public long getMicroSecPerFrame() throws IOException {
        this.ensureRealized();
        return this.mainHeader.microSecPerFrame;
    }

    public long getTimeScale(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).scale;
    }

    public long getStartTime(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).startTime;
    }

    public long getChunkCount(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).samples.size();
    }

    public String getName(int track) throws IOException {
        this.ensureRealized();
        return ((AbstractAVIStream.Track)this.tracks.get((int)track)).name;
    }

    public byte[] getExtraHeader(int track, String fourcc) throws IOException {
        this.ensureRealized();
        int id = RIFFParser.stringToID(fourcc);
        for (RIFFChunk c : ((AbstractAVIStream.Track)this.tracks.get((int)track)).extraHeaders) {
            if (c.getID() != id) continue;
            return c.getData();
        }
        return null;
    }

    public String[] getExtraHeaderFourCCs(int track) throws IOException {
        AbstractAVIStream.Track tr = (AbstractAVIStream.Track)this.tracks.get(track);
        String[] fourccs = new String[tr.extraHeaders.size()];
        for (int i = 0; i < fourccs.length; ++i) {
            fourccs[i] = RIFFParser.idToString(tr.extraHeaders.get(i).getID());
        }
        return fourccs;
    }

    protected void readAllMetadata() throws IOException {
        this.in.seek(this.streamOffset);
        final RIFFParser p = new RIFFParser();
        try {
            RIFFVisitor v = new RIFFVisitor(){
                private AbstractAVIStream.Track currentTrack;

                @Override
                public boolean enteringGroup(RIFFChunk group) {
                    if (group.getType() == 1836021353) {
                        AVIInputStream.this.moviOffset = group.getScan() + 8L;
                    }
                    return group.getType() != 1836021353 || group.getID() != 1279873876 || AVIInputStream.this.mainHeader == null || (AVIInputStream.this.mainHeader.flags & 0x10) == 0 || p.getStreamOffset() != 0L;
                }

                @Override
                public void enterGroup(RIFFChunk group) throws ParseException, AbortException {
                }

                @Override
                public void leaveGroup(RIFFChunk group) throws ParseException, AbortException {
                    if (group.getType() == 1751413356) {
                        this.currentTrack = null;
                    }
                }

                @Override
                public void visitChunk(RIFFChunk group, RIFFChunk chunk) throws ParseException, AbortException {
                    try {
                        block1 : switch (chunk.getType()) {
                            case 1751413356: {
                                switch (chunk.getID()) {
                                    case 1635150184: {
                                        AVIInputStream.this.mainHeader = AVIInputStream.this.readAVIH(chunk.getData());
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case 1937011308: {
                                switch (chunk.getID()) {
                                    case 1937011304: {
                                        this.currentTrack = AVIInputStream.this.readSTRH(chunk.getData());
                                        AVIInputStream.this.tracks.add(this.currentTrack);
                                        break block1;
                                    }
                                    case 1937011302: {
                                        switch (this.currentTrack.mediaType) {
                                            case AUDIO: {
                                                AVIInputStream.this.readAudioSTRF((AbstractAVIStream.AudioTrack)this.currentTrack, chunk.getData());
                                                break block1;
                                            }
                                            case VIDEO: {
                                                AVIInputStream.this.readVideoSTRF((AbstractAVIStream.VideoTrack)this.currentTrack, chunk.getData());
                                                break block1;
                                            }
                                        }
                                        throw new ParseException("Unsupported media type:" + (Object)((Object)this.currentTrack.mediaType));
                                    }
                                    case 1937011310: {
                                        AVIInputStream.this.readSTRN(this.currentTrack, chunk.getData());
                                        break block1;
                                    }
                                }
                                this.currentTrack.extraHeaders.add(chunk);
                                break;
                            }
                            case 1096173856: {
                                switch (chunk.getID()) {
                                    case 1768192049: {
                                        if (!AbstractAVIStream.isFlagSet(AVIInputStream.this.mainHeader.flags, 16)) break block1;
                                        AVIInputStream.this.readIDX1(AVIInputStream.this.tracks, AVIInputStream.this.idx1, chunk.getData());
                                        break block1;
                                    }
                                }
                                break;
                            }
                            case 1836021353: 
                            case 1919247136: {
                                int chunkIdInt;
                                int id = chunkIdInt = chunk.getID();
                                int track = ((chunkIdInt >> 24 & 0xFF) - 48) * 10 + ((chunkIdInt >>> 16 & 0xFF) - 48);
                                if (track >= 0 && track < AVIInputStream.this.tracks.size()) {
                                    AbstractAVIStream.Track tr = (AbstractAVIStream.Track)AVIInputStream.this.tracks.get(track);
                                    AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(id, (id & 0xFFFF) == 28771 ? 0 : 1, chunk.getScan(), chunk.getSize(), false);
                                    if (tr.format.get(VideoFormatKeys.MediaTypeKey) == FormatKeys.MediaType.AUDIO) {
                                        s.duration = (int)(s.length / (long)(tr.format.get(AudioFormatKeys.FrameSizeKey) * tr.format.get(AudioFormatKeys.ChannelsKey)));
                                    }
                                    boolean bl = s.isKeyframe = tr.samples.isEmpty() || (id & 0xFFFF) == 30562 || (id & 0xFFFF) == 25698;
                                    if (tr.samples.size() > 0) {
                                        AbstractAVIStream.Sample lastSample = tr.samples.get(tr.samples.size() - 1);
                                        s.timeStamp = lastSample.timeStamp + (long)lastSample.duration;
                                    }
                                    tr.length = s.timeStamp + (long)s.duration;
                                    AVIInputStream.this.idx1.add(s);
                                    tr.samples.add(s);
                                }
                                break;
                            }
                        }
                    }
                    catch (IOException ex) {
                        throw new ParseException("Error parsing " + RIFFParser.idToString(group.getID()) + "." + RIFFParser.idToString(chunk.getID()), ex);
                    }
                }
            };
            int count = 0;
            while (true) {
                long offset = p.parse(this.in, v);
                p.setStreamOffset(offset);
                ++count;
            }
        }
        catch (EOFException v) {
        }
        catch (ParseException ex) {
            throw new IOException("Error Parsing AVI stream", ex);
        }
        catch (AbortException ex) {
            throw new IOException("Parsing aborted", ex);
        }
    }

    private AbstractAVIStream.MainHeader readAVIH(byte[] data) throws IOException, ParseException {
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, ByteOrder.LITTLE_ENDIAN);
        AbstractAVIStream.MainHeader mh = new AbstractAVIStream.MainHeader();
        mh.microSecPerFrame = in.readUnsignedInt();
        mh.maxBytesPerSec = in.readUnsignedInt();
        mh.paddingGranularity = in.readUnsignedInt();
        mh.flags = in.readInt();
        mh.totalFrames = in.readUnsignedInt();
        mh.initialFrames = in.readUnsignedInt();
        mh.streams = in.readUnsignedInt();
        mh.suggestedBufferSize = in.readUnsignedInt();
        mh.size = new Dimension(in.readInt(), in.readInt());
        return mh;
    }

    private AbstractAVIStream.Track readSTRH(byte[] data) throws IOException, ParseException {
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, ByteOrder.LITTLE_ENDIAN);
        AbstractAVIStream.Track tr = null;
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        String type = AVIInputStream.intToType(in.readInt());
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        int handler = in.readInt();
        if (type.equals(AbstractAVIStream.AVIMediaType.AUDIO.fccType)) {
            tr = new AbstractAVIStream.AudioTrack(this.tracks.size(), handler);
        } else if (type.equals(AbstractAVIStream.AVIMediaType.VIDEO.fccType)) {
            tr = (AbstractAVIStream)this.new AbstractAVIStream.VideoTrack(this.tracks.size(), handler, null);
        } else if (type.equals(AbstractAVIStream.AVIMediaType.MIDI.fccType)) {
            tr = new AbstractAVIStream.MidiTrack(this.tracks.size(), handler);
        } else if (type.equals(AbstractAVIStream.AVIMediaType.TEXT.fccType)) {
            tr = new AbstractAVIStream.TextTrack(this.tracks.size(), handler);
        } else {
            throw new ParseException("Unknown track type " + type);
        }
        tr.fccHandler = handler;
        tr.flags = in.readInt();
        tr.priority = in.readUnsignedShort();
        tr.language = in.readUnsignedShort();
        tr.initialFrames = in.readUnsignedInt();
        tr.scale = in.readUnsignedInt();
        tr.rate = in.readUnsignedInt();
        tr.startTime = in.readUnsignedInt();
        tr.length = in.readUnsignedInt();
        in.readUnsignedInt();
        tr.quality = in.readInt();
        in.readUnsignedInt();
        tr.frameLeft = in.readShort();
        tr.frameTop = in.readShort();
        tr.frameRight = in.readShort();
        tr.frameBottom = in.readShort();
        return tr;
    }

    private void readSTRN(AbstractAVIStream.Track tr, byte[] data) throws IOException {
        tr.name = new String(data, 0, data.length - 1, "ASCII");
    }

    private void readVideoSTRF(AbstractAVIStream.VideoTrack tr, byte[] data) throws IOException {
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, ByteOrder.LITTLE_ENDIAN);
        long structSize = in.readUnsignedInt();
        tr.width = in.readInt();
        tr.height = in.readInt();
        tr.planes = in.readUnsignedShort();
        tr.bitCount = in.readUnsignedShort();
        in.setByteOrder(ByteOrder.BIG_ENDIAN);
        tr.compression = AVIInputStream.intToType(in.readInt());
        in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        long imageSizeInBytes = in.readUnsignedInt();
        tr.xPelsPerMeter = in.readUnsignedInt();
        tr.yPelsPerMeter = in.readUnsignedInt();
        tr.clrUsed = in.readUnsignedInt();
        tr.clrImportant = in.readUnsignedInt();
        if (tr.bitCount == 0) {
            tr.bitCount = (int)(imageSizeInBytes / (long)tr.width / (long)tr.height * 8L);
        }
        tr.format = new Format(new Object[]{VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, tr.compression, VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.WidthKey, tr.width, VideoFormatKeys.HeightKey, tr.height, VideoFormatKeys.DepthKey, tr.bitCount, VideoFormatKeys.PixelAspectRatioKey, new Rational(1L, 1L), VideoFormatKeys.FrameRateKey, new Rational(tr.rate, tr.scale), VideoFormatKeys.FixedFrameRateKey, true});
    }

    private void readAudioSTRF(AbstractAVIStream.AudioTrack tr, byte[] data) throws IOException {
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, ByteOrder.LITTLE_ENDIAN);
        String formatTag = RIFFParser.idToString(in.readUnsignedShort());
        tr.channels = in.readUnsignedShort();
        tr.samplesPerSec = in.readUnsignedInt();
        tr.avgBytesPerSec = in.readUnsignedInt();
        tr.blockAlign = in.readUnsignedShort();
        tr.bitsPerSample = in.readUnsignedShort();
        if (data.length > 16) {
            long l = in.readUnsignedShort();
        }
        tr.format = new Format(new Object[]{VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, VideoFormatKeys.EncodingKey, formatTag, AudioFormatKeys.SampleRateKey, Rational.valueOf(tr.samplesPerSec), AudioFormatKeys.SampleSizeInBitsKey, tr.bitsPerSample, AudioFormatKeys.ChannelsKey, tr.channels, AudioFormatKeys.FrameSizeKey, tr.blockAlign, VideoFormatKeys.FrameRateKey, new Rational(tr.samplesPerSec, 1L), AudioFormatKeys.SignedKey, tr.bitsPerSample != 8, AudioFormatKeys.ByteOrderKey, ByteOrder.LITTLE_ENDIAN, VideoFormatKeys.FixedFrameRateKey, true});
    }

    private void readIDX1(ArrayList<AbstractAVIStream.Track> tracks, ArrayList<AbstractAVIStream.Sample> idx1, byte[] data) throws IOException {
        ByteArrayImageInputStream in = new ByteArrayImageInputStream(data, ByteOrder.LITTLE_ENDIAN);
        long[] trReadTimeStamp = new long[tracks.size()];
        AbstractAVIStream.Sample paletteChange = null;
        while (in.getStreamPosition() < (long)data.length) {
            int duration;
            in.setByteOrder(ByteOrder.BIG_ENDIAN);
            int chunkIdInt = in.readInt();
            in.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            int chunkId = chunkIdInt;
            int track = ((chunkIdInt >>> 24 & 0xFF) - 48) * 10 + ((chunkIdInt >>> 16 & 0xFF) - 48);
            if (track < 0 || track > 99 || track > tracks.size()) {
                throw new IOException("Illegal chunkId in IDX1:" + chunkId);
            }
            int flags = in.readInt();
            long offset = in.readUnsignedInt();
            long size = in.readUnsignedInt();
            AbstractAVIStream.Track tr = tracks.get(track);
            int n = duration = (flags & 0x100) != 0 ? 0 : 1;
            if (tr.mediaType == AbstractAVIStream.AVIMediaType.AUDIO) {
                Format af = tr.format;
                duration = (int)(size * (long)duration / (long)af.get(AudioFormatKeys.FrameSizeKey).intValue());
                flags |= 0x10;
            }
            AbstractAVIStream.Sample s = new AbstractAVIStream.Sample(chunkId, duration, offset + this.moviOffset, size, (flags & 0x10) != 0);
            s.timeStamp = trReadTimeStamp[track];
            idx1.add(s);
            int n2 = track;
            trReadTimeStamp[n2] = trReadTimeStamp[n2] + (long)duration;
            if ((s.chunkType & 0xFFFF) == 28771) {
                paletteChange = s;
                continue;
            }
            if (paletteChange != null) {
                s.header = paletteChange;
            }
            tr.samples.add(s);
        }
        for (AbstractAVIStream.Track tr : tracks) {
            tr.readIndex = 0L;
        }
    }

    public void close() throws IOException {
        this.in.close();
        for (AbstractAVIStream.Track tr : this.tracks) {
            tr.samples.clear();
        }
        this.tracks.clear();
    }
}

