/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.avi;

import java.awt.Dimension;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.stream.ImageOutputStream;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.Codec;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.riff.RIFFChunk;

public abstract class AbstractAVIStream {
    protected static final int RIFF_ID = 1380533830;
    protected static final int AVI_ID = 1096173856;
    protected static final int AVIX_ID = 1096173912;
    protected static final int LIST_ID = 1279873876;
    protected static final int MOVI_ID = 1836021353;
    protected static final int HDRL_ID = 1751413356;
    protected static final int AVIH_ID = 1635150184;
    protected static final int STRL_ID = 1937011308;
    protected static final int STRH_ID = 1937011304;
    protected static final int STRN_ID = 1937011310;
    protected static final int STRF_ID = 1937011302;
    protected static final int STRD_ID = 1937011300;
    protected static final int IDX1_ID = 1768192049;
    protected static final int REC_ID = 1919247136;
    protected static final int CHUNK_SUBTYPE_MASK = 65535;
    protected static final int PC_ID = 28771;
    protected static final int DB_ID = 25698;
    protected static final int DC_ID = 25699;
    protected static final int WB_ID = 30562;
    public static final int AVIH_FLAG_HAS_INDEX = 16;
    public static final int AVIH_FLAG_MUST_USE_INDEX = 32;
    public static final int AVIH_FLAG_IS_INTERLEAVED = 256;
    public static final int AVIH_FLAG_TRUST_CK_TYPE = 2048;
    public static final int AVIH_FLAG_WAS_CAPTURE_FILE = 65536;
    public static final int AVIH_FLAG_COPYRIGHTED = 131072;
    public static final int STRH_FLAG_DISABLED = 1;
    public static final int STRH_FLAG_VIDEO_PALETTE_CHANGES = 65536;
    protected ImageOutputStream out;
    protected long streamOffset;
    protected ArrayList<Track> tracks = new ArrayList();

    protected long getRelativeStreamPosition() throws IOException {
        return this.out.getStreamPosition() - this.streamOffset;
    }

    protected void seekRelative(long newPosition) throws IOException {
        this.out.seek(newPosition + this.streamOffset);
    }

    protected static int typeToInt(String str) {
        int value = (str.charAt(0) & 0xFF) << 24 | (str.charAt(1) & 0xFF) << 16 | (str.charAt(2) & 0xFF) << 8 | str.charAt(3) & 0xFF;
        return value;
    }

    protected static String intToType(int id) {
        char[] b = new char[]{(char)(id >>> 24 & 0xFF), (char)(id >>> 16 & 0xFF), (char)(id >>> 8 & 0xFF), (char)(id & 0xFF)};
        return String.valueOf(b);
    }

    protected static boolean isFlagSet(int flag, int mask) {
        return (flag & mask) == mask;
    }

    protected static class MainHeader {
        protected long microSecPerFrame;
        protected long maxBytesPerSec;
        protected long paddingGranularity;
        protected int flags;
        protected long totalFrames;
        protected long initialFrames;
        protected long streams;
        protected long suggestedBufferSize;
        protected Dimension size;

        protected MainHeader() {
        }
    }

    protected class TextTrack
    extends Track {
        private final int sampleChunkFourCC;

        public TextTrack(int trackIndex, int fourCC) {
            super(trackIndex, AVIMediaType.TEXT, fourCC);
            this.sampleChunkFourCC = this.twoCC | 0x7762;
        }

        @Override
        public long getSTRFChunkSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getSampleChunkFourCC(boolean isSync) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected class MidiTrack
    extends Track {
        private final int sampleChunkFourCC;

        public MidiTrack(int trackIndex, int fourCC) {
            super(trackIndex, AVIMediaType.MIDI, fourCC);
            this.sampleChunkFourCC = this.twoCC | 0x7762;
        }

        @Override
        public long getSTRFChunkSize() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getSampleChunkFourCC(boolean isSync) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    protected class FixedSizeDataChunk
    extends Chunk {
        protected boolean finished;
        protected long fixedSize;

        public FixedSizeDataChunk(int chunkType, long fixedSize) throws IOException {
            super(chunkType);
            this.fixedSize = fixedSize;
            AbstractAVIStream.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
            AbstractAVIStream.this.out.writeInt(chunkType);
            AbstractAVIStream.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            AbstractAVIStream.this.out.writeInt((int)fixedSize);
            byte[] buf = new byte[(int)Math.min(512L, fixedSize)];
            for (long written = 0L; written < fixedSize; written += Math.min((long)buf.length, fixedSize - written)) {
                AbstractAVIStream.this.out.write(buf, 0, (int)Math.min((long)buf.length, fixedSize - written));
            }
            if (fixedSize % 2L == 1L) {
                AbstractAVIStream.this.out.writeByte(0);
            }
            this.seekToStartOfData();
        }

        public ImageOutputStream getOutputStream() {
            return AbstractAVIStream.this.out;
        }

        public long getOffset() {
            return this.offset;
        }

        public void seekToStartOfData() throws IOException {
            AbstractAVIStream.this.seekRelative(this.offset + 8L);
        }

        public void seekToEndOfChunk() throws IOException {
            AbstractAVIStream.this.seekRelative(this.offset + 8L + this.fixedSize + this.fixedSize % 2L);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                this.finished = true;
            }
        }

        @Override
        public long size() {
            return 8L + this.fixedSize;
        }
    }

    protected class DataChunk
    extends Chunk {
        protected boolean finished;
        private long finishedSize;

        public DataChunk(int name) throws IOException {
            this(name, -1L);
        }

        public DataChunk(int name, long dataSize) throws IOException {
            super(name);
            AbstractAVIStream.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
            AbstractAVIStream.this.out.writeInt(this.chunkType);
            AbstractAVIStream.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            AbstractAVIStream.this.out.writeInt((int)Math.max(0L, dataSize));
            this.finishedSize = dataSize == -1L ? -1L : dataSize + 8L;
        }

        public ImageOutputStream getOutputStream() {
            if (this.finished) {
                throw new IllegalStateException("DataChunk is finished");
            }
            return AbstractAVIStream.this.out;
        }

        public long getOffset() {
            return this.offset;
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.finishedSize == -1L) {
                    this.finishedSize = this.size();
                    if (this.finishedSize > 0xFFFFFFFFL) {
                        throw new IOException("DataChunk \"" + this.chunkType + "\" is too large: " + this.size());
                    }
                    AbstractAVIStream.this.seekRelative(this.offset + 4L);
                    AbstractAVIStream.this.out.writeInt((int)(this.finishedSize - 8L));
                    AbstractAVIStream.this.seekRelative(this.offset + this.finishedSize);
                } else if (this.size() != this.finishedSize) {
                    throw new IOException("DataChunk \"" + this.chunkType + "\" actual size differs from given size: actual size:" + this.size() + " given size:" + this.finishedSize);
                }
                if (this.size() % 2L == 1L) {
                    AbstractAVIStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            if (this.finished) {
                return this.finishedSize;
            }
            try {
                return AbstractAVIStream.this.out.getStreamPosition() - this.offset;
            }
            catch (IOException ex) {
                InternalError ie = new InternalError("IOException");
                ie.initCause(ex);
                throw ie;
            }
        }
    }

    protected class CompositeChunk
    extends Chunk {
        protected int compositeType;
        protected LinkedList<Chunk> children;
        protected boolean finished;

        public CompositeChunk(int compositeType, int chunkType) throws IOException {
            super(chunkType);
            this.compositeType = compositeType;
            AbstractAVIStream.this.out.writeLong(0L);
            AbstractAVIStream.this.out.writeInt(0);
            this.children = new LinkedList();
        }

        public void add(Chunk child) throws IOException {
            if (this.children.size() > 0) {
                this.children.getLast().finish();
            }
            this.children.add(child);
        }

        @Override
        public void finish() throws IOException {
            if (!this.finished) {
                if (this.size() > 0xFFFFFFFFL) {
                    throw new IOException("CompositeChunk \"" + this.chunkType + "\" is too large: " + this.size());
                }
                long pointer = AbstractAVIStream.this.getRelativeStreamPosition();
                AbstractAVIStream.this.seekRelative(this.offset);
                AbstractAVIStream.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
                AbstractAVIStream.this.out.writeInt(this.compositeType);
                AbstractAVIStream.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                AbstractAVIStream.this.out.writeInt((int)(this.size() - 8L));
                AbstractAVIStream.this.out.setByteOrder(ByteOrder.BIG_ENDIAN);
                AbstractAVIStream.this.out.writeInt(this.chunkType);
                AbstractAVIStream.this.out.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                for (Chunk child : this.children) {
                    child.finish();
                }
                AbstractAVIStream.this.seekRelative(pointer);
                if (this.size() % 2L == 1L) {
                    AbstractAVIStream.this.out.writeByte(0);
                }
                this.finished = true;
            }
        }

        @Override
        public long size() {
            long length = 12L;
            for (Chunk child : this.children) {
                length += child.size() + child.size() % 2L;
            }
            return length;
        }
    }

    protected abstract class Chunk {
        protected int chunkType;
        protected long offset;

        public Chunk(int chunkType) throws IOException {
            this.chunkType = chunkType;
            this.offset = AbstractAVIStream.this.getRelativeStreamPosition();
        }

        public abstract void finish() throws IOException;

        public abstract long size();
    }

    protected class AudioTrack
    extends Track {
        protected int wFormatTag;
        protected int channels;
        protected long samplesPerSec;
        protected long avgBytesPerSec;
        protected int blockAlign;
        protected int bitsPerSample;
        protected static final int WAVE_FORMAT_PCM = 1;
        protected static final int WAVE_FORMAT_ADPCM = 2;
        protected static final int WAVE_FORMAT_IEEE_FLOAT = 3;
        protected static final int WAVE_FORMAT_IBM_CVSD = 5;
        protected static final int WAVE_FORMAT_ALAW = 6;
        protected static final int WAVE_FORMAT_MULAW = 7;
        protected static final int WAVE_FORMAT_OKI_ADPCM = 16;
        protected static final int WAVE_FORMAT_DVI_ADPCM = 17;
        protected static final int WAVE_FORMAT_IMA_ADPCM = 17;
        protected static final int WAVE_FORMAT_MEDIASPACE_ADPCM = 18;
        protected static final int WAVE_FORMAT_SIERRA_ADPCM = 19;
        protected static final int WAVE_FORMAT_G723_ADPCM = 20;
        protected static final int WAVE_FORMAT_DIGISTD = 21;
        protected static final int WAVE_FORMAT_DIGIFIX = 22;
        protected static final int WAVE_FORMAT_DIALOGIC_OKI_ADPCM = 23;
        protected static final int WAVE_FORMAT_MEDIAVISION_ADPCM = 24;
        protected static final int WAVE_FORMAT_YAMAHA_ADPCM = 32;
        protected static final int WAVE_FORMAT_SONARC = 33;
        protected static final int WAVE_FORMAT_DSPGROUP_TRUESPEECH = 34;
        protected static final int WAVE_FORMAT_ECHOSC1 = 35;
        protected static final int WAVE_FORMAT_AUDIOFILE_AF36 = 36;
        protected static final int WAVE_FORMAT_APTX = 37;
        protected static final int WAVE_FORMAT_AUDIOFILE_AF10 = 38;
        protected static final int WAVE_FORMAT_DOLBY_AC2 = 48;
        protected static final int WAVE_FORMAT_GSM610 = 49;
        protected static final int WAVE_FORMAT_MSNAUDIO = 50;
        protected static final int WAVE_FORMAT_ANTEX_ADPCME = 51;
        protected static final int WAVE_FORMAT_CONTROL_RES_VQLPC = 52;
        protected static final int WAVE_FORMAT_DIGIREAL = 53;
        protected static final int WAVE_FORMAT_DIGIADPCM = 54;
        protected static final int WAVE_FORMAT_CONTROL_RES_CR10 = 55;
        protected static final int WAVE_FORMAT_NMS_VBXADPCM = 56;
        protected static final int WAVE_FORMAT_CS_IMAADPCM = 57;
        protected static final int WAVE_FORMAT_ECHOSC3 = 58;
        protected static final int WAVE_FORMAT_ROCKWELL_ADPCM = 59;
        protected static final int WAVE_FORMAT_ROCKWELL_DIGITALK = 60;
        protected static final int WAVE_FORMAT_XEBEC = 61;
        protected static final int WAVE_FORMAT_G721_ADPCM = 64;
        protected static final int WAVE_FORMAT_G728_CELP = 65;
        protected static final int WAVE_FORMAT_MPEG = 80;
        protected static final int WAVE_FORMAT_MPEGLAYER3 = 85;
        protected static final int WAVE_FORMAT_CIRRUS = 96;
        protected static final int WAVE_FORMAT_ESPCM = 97;
        protected static final int WAVE_FORMAT_VOXWARE = 98;
        protected static final int WAVE_FORMAT_CANOPUS_ATRAC = 99;
        protected static final int WAVE_FORMAT_G726_ADPCM = 100;
        protected static final int WAVE_FORMAT_G722_ADPCM = 101;
        protected static final int WAVE_FORMAT_DSAT = 102;
        protected static final int WAVE_FORMAT_DSAT_DISPLAY = 103;
        protected static final int WAVE_FORMAT_SOFTSOUND = 128;
        protected static final int WAVE_FORMAT_RHETOREX_ADPCM = 256;
        protected static final int WAVE_FORMAT_CREATIVE_ADPCM = 512;
        protected static final int WAVE_FORMAT_CREATIVE_FASTSPEECH8 = 514;
        protected static final int WAVE_FORMAT_CREATIVE_FASTSPEECH10 = 515;
        protected static final int WAVE_FORMAT_QUARTERDECK = 544;
        protected static final int WAVE_FORMAT_FM_TOWNS_SND = 768;
        protected static final int WAVE_FORMAT_BTV_DIGITAL = 1024;
        protected static final int WAVE_FORMAT_OLIGSM = 4096;
        protected static final int WAVE_FORMAT_OLIADPCM = 4097;
        protected static final int WAVE_FORMAT_OLICELP = 4098;
        protected static final int WAVE_FORMAT_OLISBC = 4099;
        protected static final int WAVE_FORMAT_OLIOPR = 4100;
        protected static final int WAVE_FORMAT_LH_CODEC = 4352;
        protected static final int WAVE_FORMAT_NORRIS = 5120;
        protected static final int WAVE_FORMAT_DEVELOPMENT = 65535;
        private int sampleChunkFourCC;

        public AudioTrack(int trackIndex, int fourCC) {
            super(trackIndex, AVIMediaType.AUDIO, fourCC);
            this.sampleChunkFourCC = this.twoCC | 0x7762;
        }

        @Override
        public long getSTRFChunkSize() {
            return 18L;
        }

        @Override
        public int getSampleChunkFourCC(boolean isSync) {
            return this.sampleChunkFourCC;
        }
    }

    protected class VideoTrack
    extends Track {
        protected IndexColorModel palette;
        protected IndexColorModel previousPalette;
        protected Object previousData;
        int width;
        int height;
        int planes;
        int bitCount;
        String compression;
        long sizeImage;
        long xPelsPerMeter;
        long yPelsPerMeter;
        long clrUsed;
        long clrImportant;
        private int sampleChunkFourCC;

        public VideoTrack(int trackIndex, int fourCC, Format videoFormat) {
            super(trackIndex, AVIMediaType.VIDEO, fourCC);
            this.format = videoFormat;
            this.sampleChunkFourCC = videoFormat != null && ((String)videoFormat.get(VideoFormatKeys.EncodingKey)).equals("\u0000\u0000\u0000\u0000") ? this.twoCC | 0x6462 : this.twoCC | 0x6463;
        }

        @Override
        public long getSTRFChunkSize() {
            return this.palette == null ? 40L : (long)(40 + this.palette.getMapSize() * 4);
        }

        @Override
        public int getSampleChunkFourCC(boolean isSync) {
            return this.sampleChunkFourCC;
        }
    }

    protected abstract class Track {
        protected Format format;
        protected ArrayList<Sample> samples;
        protected int syncInterval = 30;
        protected int twoCC;
        protected final AVIMediaType mediaType;
        protected int fccHandler;
        protected int flags;
        protected int priority = 0;
        protected int language = 0;
        protected long initialFrames = 0L;
        protected long scale = 1L;
        protected long rate = 30L;
        protected long startTime = 0L;
        protected long length;
        protected int quality = -1;
        int frameLeft;
        int frameTop;
        int frameRight;
        int frameBottom;
        protected FixedSizeDataChunk strhChunk;
        protected FixedSizeDataChunk strfChunk;
        protected String name;
        protected Codec codec;
        protected Buffer outputBuffer;
        protected Buffer inputBuffer;
        protected long readIndex = 0L;
        protected ArrayList<RIFFChunk> extraHeaders;

        public Track(int trackIndex, AVIMediaType mediaType, int fourCC) {
            this.mediaType = mediaType;
            this.twoCC = 48 + trackIndex / 10 << 24 | 48 + trackIndex % 10 << 16;
            this.fccHandler = fourCC;
            this.samples = new ArrayList();
            this.extraHeaders = new ArrayList();
        }

        public abstract long getSTRFChunkSize();

        public abstract int getSampleChunkFourCC(boolean var1);

        public void addSample(Sample s) {
            if (!this.samples.isEmpty()) {
                s.timeStamp = this.samples.get((int)(this.samples.size() - 1)).timeStamp + (long)this.samples.get((int)(this.samples.size() - 1)).duration;
            }
            this.samples.add(s);
            ++this.length;
        }
    }

    protected static class Sample {
        int chunkType;
        long offset;
        long length;
        int duration;
        boolean isKeyframe;
        long timeStamp;
        Sample header;

        public Sample(int chunkId, int duration, long offset, long length, boolean isSync) {
            this.chunkType = chunkId;
            this.duration = duration;
            this.offset = offset;
            this.length = length;
            this.isKeyframe = isSync;
        }
    }

    public static enum AVIMediaType {
        AUDIO("auds"),
        MIDI("mids"),
        TEXT("txts"),
        VIDEO("vids");

        protected final String fccType;

        public String toString() {
            return this.fccType;
        }

        private AVIMediaType(String fourCC) {
            this.fccType = fourCC;
        }
    }
}

