/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.avi;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import ru.sbtqa.monte.media.AbstractVideoCodec;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.avi.ZMBVCodecCore;

public class ZMBVCodec
extends AbstractVideoCodec {
    private ZMBVCodecCore state;
    private Object oldPixels;
    private Object newPixels;

    public ZMBVCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, "ZMBV", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.FixedFrameRateKey, true})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.FixedFrameRateKey, true})});
        this.name = "ZMBV Codec";
    }

    @Override
    public Format setOutputFormat(Format f) {
        super.setOutputFormat(f);
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey, VideoFormatKeys.DepthKey));
        }
        return this.outputFormat;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        return this.decode(in, out);
    }

    public int decode(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        out.length = 1;
        out.offset = 0;
        int width = this.outputFormat.get(VideoFormatKeys.WidthKey);
        int height = this.outputFormat.get(VideoFormatKeys.HeightKey);
        if (this.state == null) {
            this.state = new ZMBVCodecCore();
        }
        Object[] newPixelHolder = new Object[]{this.newPixels};
        Object[] oldPixelHolder = new Object[]{this.oldPixels};
        int result = this.state.decode((byte[])in.data, in.offset, in.length, newPixelHolder, oldPixelHolder, width, height, false);
        boolean isKeyframe = result < 0;
        int depth = Math.abs(result);
        this.newPixels = newPixelHolder[0];
        this.oldPixels = oldPixelHolder[0];
        MyBufferedImage img = null;
        if (out.data instanceof MyBufferedImage) {
            img = (MyBufferedImage)out.data;
        }
        switch (depth) {
            case 8: {
                IndexColorModel icm;
                int[] cmap;
                int imgType = 13;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    cmap = new int[256];
                    icm = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
                    img = new MyBufferedImage(width, height, imgType, icm);
                } else {
                    MyBufferedImage oldImg = img;
                    img = new MyBufferedImage(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                cmap = this.state.getPalette();
                icm = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
                img.setColorModel(icm);
                byte[] pixels = ((DataBufferByte)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((byte[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            case 15: {
                int imgType = 9;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    DirectColorModel cm = new DirectColorModel(15, 31744, 992, 31);
                    img = new MyBufferedImage(cm, Raster.createWritableRaster(cm.createCompatibleSampleModel(width, height), new Point(0, 0)), false);
                } else {
                    MyBufferedImage oldImg = img;
                    img = new MyBufferedImage(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                short[] pixels = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((short[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            case 16: {
                int imgType = 8;
                if (img == null || img.getWidth() != width || img.getHeight() != height || img.getType() != imgType) {
                    DirectColorModel cm = new DirectColorModel(15, 63488, 2016, 31);
                    img = new MyBufferedImage(cm, Raster.createWritableRaster(cm.createCompatibleSampleModel(width, height), new Point(0, 0)), false);
                } else {
                    MyBufferedImage oldImg = img;
                    img = new MyBufferedImage(oldImg.getColorModel(), oldImg.getRaster(), oldImg.isAlphaPremultiplied(), null);
                }
                short[] pixels = ((DataBufferUShort)img.getRaster().getDataBuffer()).getData();
                System.arraycopy((short[])this.newPixels, 0, pixels, 0, width * height);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported depth:" + depth);
            }
        }
        Object swap = this.oldPixels;
        this.oldPixels = this.newPixels;
        this.newPixels = swap;
        out.setFlag(BufferFlag.KEYFRAME, isKeyframe);
        out.data = img;
        return 0;
    }

    private static class MyBufferedImage
    extends BufferedImage {
        private ColorModel colorModel;

        public MyBufferedImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied) {
            super(cm, raster, isRasterPremultiplied, new Hashtable());
            this.colorModel = cm;
        }

        public MyBufferedImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
            super(cm, raster, isRasterPremultiplied, properties);
            this.colorModel = cm;
        }

        public MyBufferedImage(int width, int height, int imageType, IndexColorModel cm) {
            super(width, height, imageType, cm);
            this.colorModel = cm;
        }

        public MyBufferedImage(int width, int height, int imageType) {
            super(width, height, imageType);
        }

        @Override
        public ColorModel getColorModel() {
            return this.colorModel;
        }

        public void setColorModel(ColorModel newValue) {
            this.colorModel = newValue;
        }
    }
}

