/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.binary;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.WeakHashMap;
import ru.sbtqa.monte.media.binary.BinaryModel;

public class FileBasedBinaryModel
implements BinaryModel {
    private int segsize = 1024;
    private long offset;
    private long length;
    private RandomAccessFile racf;
    private WeakHashMap<Long, byte[]> cache = new WeakHashMap();
    private File file;

    public FileBasedBinaryModel(File file) throws IOException {
        this(file, 0L, file.length());
    }

    public FileBasedBinaryModel(File file, long offset, long length) throws IOException {
        this.racf = new RandomAccessFile(file, "r");
        this.offset = offset;
        this.length = length;
        this.file = file;
    }

    public String toString() {
        return "FileBasedBinaryModel " + this.file.getName() + " " + this.offset + " " + this.length;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public int getBytes(long off, int len, byte[] target) {
        byte[] cdat = this.cache.get(off);
        if (off + (long)len > this.length) {
            len = (int)(this.length - off);
        }
        if (cdat != null && cdat.length >= len) {
            System.arraycopy(cdat, 0, target, 0, len);
            return len;
        }
        try {
            this.racf.seek(off + this.offset);
            this.racf.readFully(target, 0, len);
            byte[] cached = (byte[])target.clone();
            this.cache.put(off, cached);
        }
        catch (IOException ex) {
            Arrays.fill(target, 0, len, (byte)0);
            ex.printStackTrace();
        }
        return len;
    }

    @Override
    public void close() {
        if (this.racf != null) {
            try {
                this.racf.close();
                this.racf = null;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void finalize() {
        this.close();
    }
}

