/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.binary;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import ru.sbtqa.monte.media.ParseException;
import ru.sbtqa.monte.media.binary.StructTableModel;
import ru.sbtqa.monte.media.io.ByteArrayImageInputStream;
import ru.sbtqa.monte.media.io.StreamPosTokenizer;
import ru.sbtqa.monte.media.math.ExtendedReal;

public class StructParser {
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();
    private Declarations declarations;

    public StructParser() {
    }

    public StructParser(Reader r) throws IOException, ParseException {
        this.parse(r);
    }

    public String getName(String magic) {
        return this.getName((Object)magic);
    }

    public String getName(Object magic) {
        MagicDeclaration md = this.declarations.magics.get(magic);
        DescriptionDeclaration dd = md == null ? null : this.declarations.descriptions.get(md.identifier);
        return dd == null ? null : dd.name;
    }

    public String getIdentifierName(String magic) {
        MagicDeclaration md = this.declarations.magics.get(magic);
        DescriptionDeclaration dd = md == null ? null : this.declarations.descriptions.get(md.identifier);
        return md == null ? null : md.identifier;
    }

    public boolean isMagicDeclared(String magic) {
        return this.isMagicDeclared((Object)magic);
    }

    public boolean isMagicDeclared(Object magic) {
        MagicDeclaration md = this.declarations.magics.get(magic);
        return md != null;
    }

    public boolean isTypeDeclared(String magic) {
        return this.isTypeDeclared((Object)magic);
    }

    public boolean isTypeDeclared(Object magic) {
        TypedefDeclaration typedef = null;
        MagicDeclaration magicdef = this.declarations.magics.get(magic);
        if (magicdef == null) {
            return false;
        }
        typedef = this.declarations.typedefs.get(magicdef.identifier);
        return typedef != null;
    }

    public String getDescription(String magic) {
        return this.getDescription((Object)magic);
    }

    public String getDescription(Object magic) {
        MagicDeclaration md = this.declarations.magics.get(magic);
        DescriptionDeclaration dd = md == null ? null : this.declarations.descriptions.get(md.identifier);
        return dd == null ? null : dd.description;
    }

    public StructTableModel readStruct(String magic, byte[] data) throws IOException {
        return this.declarations.readStruct(magic, new ByteArrayImageInputStream(data));
    }

    public StructTableModel readStruct(int magic, byte[] data) throws IOException {
        return this.declarations.readStruct(magic, new ByteArrayImageInputStream(data));
    }

    public StructTableModel readStruct(String magic, InputStream data) throws IOException {
        if (data instanceof ImageInputStream) {
            return this.declarations.readStruct(magic, (ImageInputStream)((Object)data));
        }
        return this.declarations.readStruct(magic, new MemoryCacheImageInputStream(data));
    }

    public StructTableModel readStruct(int magic, InputStream data) throws IOException {
        if (data instanceof ImageInputStream) {
            return this.declarations.readStruct(magic, (ImageInputStream)((Object)data));
        }
        return this.declarations.readStruct(magic, new MemoryCacheImageInputStream(data));
    }

    private static String errorMsg(String text, StreamPosTokenizer scanner) {
        StringBuilder b = new StringBuilder();
        b.append("line ");
        b.append(Integer.toString(scanner.lineno()));
        b.append(": ");
        b.append(text);
        b.append(" instead of ");
        switch (scanner.ttype) {
            case -3: {
                b.append('\'');
                b.append(scanner.sval);
                b.append('\'');
                break;
            }
            case -1: {
                b.append("EOF");
                break;
            }
            case 10: {
                b.append("EOL");
                break;
            }
            case -2: {
                b.append(Double.toString(scanner.nval));
                break;
            }
            case 34: {
                b.append('\"');
                b.append(scanner.sval);
                b.append('\"');
                break;
            }
            default: {
                b.append('\'');
                b.append((char)scanner.ttype);
                b.append('\'');
                b.append("(0x");
                b.append(Integer.toHexString(scanner.ttype));
                b.append(')');
            }
        }
        return b.toString();
    }

    protected void parse(Reader r) throws IOException, ParseException {
        StreamPosTokenizer scanner = new StreamPosTokenizer(r);
        scanner.resetSyntax();
        scanner.wordChars(97, 122);
        scanner.wordChars(65, 90);
        scanner.wordChars(160, 255);
        scanner.wordChars(95, 95);
        scanner.whitespaceChars(0, 32);
        scanner.quoteChar(34);
        scanner.quoteChar(39);
        scanner.parseNumbers();
        scanner.parseHexNumbers();
        scanner.slashSlashComments(true);
        scanner.slashStarComments(true);
        scanner.ordinaryChar(59);
        scanner.ordinaryChar(91);
        scanner.ordinaryChar(93);
        scanner.ordinaryChar(123);
        scanner.ordinaryChar(125);
        scanner.ordinaryChar(43);
        scanner.ordinaryChar(45);
        this.declarations = new Declarations(scanner);
    }

    protected static class MagicOrIntLiteral {
        public int intValue;
        public String magicValue;

        public MagicOrIntLiteral(StreamPosTokenizer scanner) throws IOException, ParseException {
            switch (scanner.nextToken()) {
                case -2: {
                    this.intValue = (int)scanner.nval;
                    if (scanner.nval != 0.0) break;
                    if (scanner.nextToken() == -3 && scanner.sval.startsWith("x")) {
                        this.intValue = Integer.valueOf(scanner.sval.substring(1), 16);
                        break;
                    }
                    scanner.pushBack();
                    break;
                }
                case 45: {
                    if (scanner.nextToken() != -2) {
                        throw new ParseException(StructParser.errorMsg("MagicOrIntLiteral: numeric value expected", scanner));
                    }
                    this.intValue = -((int)scanner.nval);
                    break;
                }
                case 34: {
                    if (scanner.sval.length() != 4) {
                        throw new ParseException(StructParser.errorMsg("MagicOrIntLiteral: magic with length of 4 characters expected", scanner));
                    }
                    this.magicValue = scanner.sval;
                    this.intValue = MagicOrIntLiteral.toInt(this.magicValue);
                    break;
                }
                default: {
                    throw new ParseException(StructParser.errorMsg("MagicOrIntLiteral: numeric value expected", scanner));
                }
            }
        }

        public boolean isMagic() {
            return this.magicValue != null;
        }

        public int intValue() {
            return this.intValue;
        }

        public String stringValue() {
            return this.magicValue == null ? Integer.toString(this.intValue) : this.magicValue;
        }

        public static int toInt(String magic) {
            return (magic.charAt(0) & 0xFF) << 24 | (magic.charAt(1) & 0xFF) << 16 | (magic.charAt(2) & 0xFF) << 8 | (magic.charAt(3) & 0xFF) << 0;
        }

        public static String toMagic(int value) {
            byte[] buf = new byte[]{(byte)((value & 0xFF000000) >>> 24), (byte)((value & 0xFF0000) >>> 16), (byte)((value & 0xFF00) >>> 8), (byte)(value & 0xFF)};
            try {
                return new String(buf, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                InternalError error = new InternalError(e.getMessage());
                error.initCause(e);
                throw error;
            }
        }
    }

    protected static class IntLiteral {
        public int value;

        public IntLiteral(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -2) {
                throw new ParseException(StructParser.errorMsg("IntLiteral: numeric value expected", scanner));
            }
            this.value = (int)scanner.nval;
            if (scanner.nval == 0.0) {
                if (scanner.nextToken() == -3 && scanner.sval.startsWith("x")) {
                    this.value = Integer.valueOf(scanner.sval.substring(1), 16);
                } else {
                    scanner.pushBack();
                }
            }
        }

        public int intValue() {
            return this.value;
        }
    }

    protected static class ArraySize {
        public static final int REMAINDER = -1;
        public static final int LITERAL = 0;
        public static final int VARIABLE = 1;
        public static final int NEGATIVE_VARIABLE = 2;
        public static final int EQUAL = 3;
        public static final int NOT_EQUAL = 4;
        public int type = 0;
        public int size;
        public String variable;
        public int offset;
        public Object equal;

        public ArraySize(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() == 93) {
                scanner.pushBack();
                this.type = -1;
            } else if (scanner.ttype == -3) {
                this.variable = scanner.sval;
                if (scanner.nextToken() == 45) {
                    this.offset = new IntLiteral(scanner).intValue() * -1;
                    this.type = 1;
                } else if (scanner.ttype == 43) {
                    this.offset = new IntLiteral(scanner).intValue();
                    this.type = 1;
                } else if (scanner.ttype == 61) {
                    if (scanner.nextToken() != 61) {
                        throw new ParseException(StructParser.errorMsg("== expected", scanner));
                    }
                    if (scanner.nextToken() == 34) {
                        this.equal = scanner.sval;
                    } else {
                        scanner.pushBack();
                        this.equal = new IntLiteral(scanner).intValue();
                    }
                    this.type = 3;
                } else if (scanner.ttype == 33) {
                    if (scanner.nextToken() != 61) {
                        throw new ParseException(StructParser.errorMsg("!= expected", scanner));
                    }
                    if (scanner.nextToken() == 34) {
                        this.equal = scanner.sval;
                    } else {
                        int sign;
                        if (scanner.ttype == 45) {
                            sign = -1;
                        } else {
                            sign = 1;
                            scanner.pushBack();
                        }
                        this.equal = new IntLiteral(scanner).intValue() * sign;
                    }
                    this.type = 4;
                } else {
                    this.type = 1;
                    scanner.pushBack();
                }
            } else {
                scanner.pushBack();
                this.size = new IntLiteral(scanner).intValue();
                if (scanner.nextToken() == 45) {
                    this.offset = this.size;
                    this.size = 0;
                    if (scanner.nextToken() != -3) {
                        throw new ParseException(StructParser.errorMsg("Variable name expected", scanner));
                    }
                    this.variable = scanner.sval;
                    this.type = 2;
                } else if (scanner.ttype == 43) {
                    this.offset = this.size;
                    this.size = 0;
                    if (scanner.nextToken() != -3) {
                        throw new ParseException(StructParser.errorMsg("Variable name expected", scanner));
                    }
                    this.variable = scanner.sval;
                    this.type = 1;
                } else if (scanner.ttype == 61) {
                    if (scanner.nextToken() != 61) {
                        throw new ParseException(StructParser.errorMsg("== expected", scanner));
                    }
                    this.offset = this.size;
                    this.size = 0;
                    if (scanner.nextToken() != -3) {
                        throw new ParseException(StructParser.errorMsg("Variable name expected", scanner));
                    }
                    this.variable = scanner.sval;
                    this.type = 3;
                } else if (scanner.ttype == 33) {
                    if (scanner.nextToken() != 61) {
                        throw new ParseException(StructParser.errorMsg("== expected", scanner));
                    }
                    this.offset = this.size;
                    this.size = 0;
                    if (scanner.nextToken() != -3) {
                        throw new ParseException(StructParser.errorMsg("Variable name expected", scanner));
                    }
                    this.variable = scanner.sval;
                    this.type = 4;
                } else {
                    this.type = 0;
                    scanner.pushBack();
                }
            }
        }

        public int getArraySize(Declarations declarations, ArrayList<StructTableModel.Value> result) {
            switch (this.type) {
                case 0: {
                    return this.size;
                }
                case 1: 
                case 2: {
                    StructTableModel.Value value;
                    int i;
                    int sign = this.type == 2 ? -1 : 1;
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.declaration.equals(this.variable)) continue;
                        int variableValue = ((Number)value.value).intValue();
                        return variableValue * sign + this.offset;
                    }
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.qualifiedIdentifier.equals(this.variable)) continue;
                        int variableValue = ((Number)value.value).intValue();
                        return variableValue * sign + this.offset;
                    }
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.qualifiedIdentifier.endsWith(this.variable)) continue;
                        int variableValue = ((Number)value.value).intValue();
                        return variableValue * sign + this.offset;
                    }
                    throw new InternalError("Invalid ArraySize variable:" + this.variable);
                }
                case 3: 
                case 4: {
                    StructTableModel.Value value;
                    int i;
                    int trueValue = this.type == 3 ? 1 : 0;
                    int falseValue = 1 - trueValue;
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.declaration.equals(this.variable)) continue;
                        return ((Number)this.equal).intValue() == ((Number)value.value).intValue() ? trueValue : falseValue;
                    }
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.qualifiedIdentifier.equals(this.variable)) continue;
                        return ((Number)this.equal).intValue() == ((Number)value.value).intValue() ? trueValue : falseValue;
                    }
                    for (i = result.size() - 1; i > -1; --i) {
                        value = result.get(i);
                        if (!value.qualifiedIdentifier.endsWith(this.variable)) continue;
                        return ((Number)this.equal).intValue() == ((Number)value.value).intValue() ? trueValue : falseValue;
                    }
                    throw new InternalError("Invalid ArraySize variable:" + this.variable);
                }
                case -1: {
                    return -1;
                }
            }
            throw new InternalError("Invalid ArraySize type:" + this.type);
        }
    }

    protected static class PrimitiveSpecifier {
        private static final int NON_PRIMITIVE = -1;
        private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        public static final int BYTE = 0;
        public static final int UBYTE = 1;
        public static final int SHORT = 2;
        public static final int USHORT = 3;
        public static final int INT = 4;
        public static final int UINT = 5;
        public static final int LONG = 6;
        public static final int FLOAT = 7;
        public static final int DOUBLE = 8;
        public static final int EXTENDED = 9;
        public static final int CHARBYTE = 10;
        public static final int CHAR = 11;
        public static final int CSTRING = 12;
        public static final int PSTRING = 13;
        public static final int PSTRING32 = 30;
        public static final int UTF8 = 32;
        public static final int UTF16LE = 29;
        public static final int MAGIC = 14;
        public static final int MAC_TIMESTAMP = 15;
        public static final int TYPEDEF_TYPE = 16;
        public static final int SHORTLE = 17;
        public static final int USHORTLE = 18;
        public static final int INTLE = 19;
        public static final int UINTLE = 20;
        public static final int LONGLE = 21;
        public static final int BCD2 = 22;
        public static final int BCD4 = 23;
        public static final int FIXED_16D16 = 24;
        public static final int FIXED_2D30 = 25;
        public static final int FIXED_8D8 = 26;
        public static final int UINT1 = 34;
        public static final int UINT2 = 35;
        public static final int UINT3 = 36;
        public static final int UINT4 = 27;
        public static final int UINT5 = 37;
        public static final int UINT9 = 41;
        public static final int UINT8 = 33;
        public static final int UINT12 = 38;
        public static final int UINT16 = 39;
        public static final int UINT31LE = 42;
        public static final int INT9 = 40;
        public static final int ATARI_COLOR = 31;
        public int type;
        public String typedef;

        public PrimitiveSpecifier(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("PrimitiveSpecifier: primitive type name expected", scanner));
            }
            if (scanner.sval.equals("ataricolor")) {
                this.type = 31;
            } else if (scanner.sval.equals("byte")) {
                this.type = 0;
            } else if (scanner.sval.equals("ubyte")) {
                this.type = 1;
            } else if (scanner.sval.equals("uint8")) {
                this.type = 33;
            } else if (scanner.sval.equals("short")) {
                this.type = 2;
            } else if (scanner.sval.equals("int16")) {
                this.type = 2;
            } else if (scanner.sval.equals("ushort")) {
                this.type = 3;
            } else if (scanner.sval.equals("uint16")) {
                this.type = 39;
            } else if (scanner.sval.equals("int")) {
                this.type = 4;
            } else if (scanner.sval.equals("uint")) {
                this.type = 5;
            } else if (scanner.sval.equals("uint32")) {
                this.type = 5;
            } else if (scanner.sval.equals("long")) {
                this.type = 6;
            } else if (scanner.sval.equals("float")) {
                this.type = 7;
            } else if (scanner.sval.equals("double")) {
                this.type = 8;
            } else if (scanner.sval.equals("extended")) {
                this.type = 9;
            } else if (scanner.sval.equals("char")) {
                this.type = 11;
            } else if (scanner.sval.equals("charbyte")) {
                this.type = 10;
            } else if (scanner.sval.equals("cstring")) {
                this.type = 12;
            } else if (scanner.sval.equals("utf8")) {
                this.type = 32;
            } else if (scanner.sval.equals("utf16le")) {
                this.type = 29;
            } else if (scanner.sval.equals("pstring")) {
                this.type = 13;
            } else if (scanner.sval.equals("pstring32")) {
                this.type = 30;
            } else if (scanner.sval.equals("magic")) {
                this.type = 14;
            } else if (scanner.sval.equals("mactimestamp")) {
                this.type = 15;
            } else if (scanner.sval.equals("shortLE")) {
                this.type = 17;
            } else if (scanner.sval.equals("ushortLE")) {
                this.type = 18;
            } else if (scanner.sval.equals("intLE")) {
                this.type = 19;
            } else if (scanner.sval.equals("uintLE")) {
                this.type = 20;
            } else if (scanner.sval.equals("longLE")) {
                this.type = 21;
            } else if (scanner.sval.equals("bcd2")) {
                this.type = 22;
            } else if (scanner.sval.equals("bcd4")) {
                this.type = 23;
            } else if (scanner.sval.equals("fixed16d16")) {
                this.type = 24;
            } else if (scanner.sval.equals("fixed2d30")) {
                this.type = 25;
            } else if (scanner.sval.equals("fixed8d8")) {
                this.type = 26;
            } else if (scanner.sval.equals("uint1")) {
                this.type = 34;
            } else if (scanner.sval.equals("uint2")) {
                this.type = 35;
            } else if (scanner.sval.equals("uint3")) {
                this.type = 36;
            } else if (scanner.sval.equals("uint4")) {
                this.type = 27;
            } else if (scanner.sval.equals("uint5")) {
                this.type = 37;
            } else if (scanner.sval.equals("uint9")) {
                this.type = 41;
            } else if (scanner.sval.equals("uint12")) {
                this.type = 38;
            } else if (scanner.sval.equals("int9")) {
                this.type = 40;
            } else if (scanner.sval.equals("uint31LE")) {
                this.type = 42;
            } else {
                this.type = 16;
                this.typedef = scanner.sval;
            }
        }

        private int getResolvedPrimitveType(Declarations declarations) throws IOException {
            switch (this.type) {
                case 16: {
                    TypedefDeclaration typedefDeclaration = declarations.typedefs.get(this.typedef);
                    if (typedefDeclaration == null) {
                        throw new IOException("typedef not found for:" + this.typedef);
                    }
                    return typedefDeclaration.getResolvedType(declarations);
                }
            }
            return this.type;
        }

        private Object read(ImageInputStream in, String parentIdentifier, Declarations declarations, ArrayList<StructTableModel.Value> result) throws IOException {
            switch (this.type) {
                case 0: {
                    return new Byte(in.readByte());
                }
                case 1: {
                    int b = in.read();
                    if (b == -1) {
                        throw new EOFException();
                    }
                    return new Integer(b);
                }
                case 2: {
                    return new Short(in.readShort());
                }
                case 3: {
                    return new Integer(in.readShort() & 0xFFFF);
                }
                case 4: {
                    return new Integer(in.readInt());
                }
                case 5: {
                    return new Long((long)in.readInt() & 0xFFFFFFFFL);
                }
                case 6: {
                    return new Long(in.readLong());
                }
                case 7: {
                    return new Float(in.readFloat());
                }
                case 8: {
                    return new Double(in.readDouble());
                }
                case 9: {
                    byte[] bits = new byte[10];
                    in.readFully(bits);
                    return new ExtendedReal(bits);
                }
                case 10: {
                    char ch = (char)(in.readByte() & 0xFF);
                    if (ch <= ' ' || Character.isIdentifierIgnorable(ch)) {
                        return "0x" + Integer.toHexString(ch);
                    }
                    return new Character(ch);
                }
                case 11: {
                    return new Character(in.readChar());
                }
                case 12: {
                    int ch;
                    StringBuilder buf = new StringBuilder();
                    while ((ch = in.read()) > 0) {
                        buf.append((char)ch);
                    }
                    return buf.toString();
                }
                case 32: {
                    int ch1;
                    ByteArrayOutputStream buf = new ByteArrayOutputStream();
                    while ((ch1 = in.read()) > 0) {
                        buf.write(ch1);
                    }
                    return new String(buf.toByteArray(), "UTF-8");
                }
                case 29: {
                    int ch1;
                    StringBuilder buf = new StringBuilder();
                    while ((ch1 = in.read()) > 0) {
                        int ch2 = in.read();
                        buf.append((char)(ch1 | ch2 << 8));
                    }
                    return buf.toString();
                }
                case 13: {
                    int count;
                    int size = in.read();
                    if (size == 0) {
                        size = in.read();
                        in.read();
                        in.read();
                    }
                    if (size < 0) {
                        return "";
                    }
                    byte[] bytes = new byte[size];
                    for (int n = 0; n < size; n += count) {
                        count = in.read(bytes, n, size - n);
                        if (count >= 0) continue;
                        System.out.println("StructParser.PrimitiveSpecifier.read not enough bytes for pstring. Expected size:" + size + " actual size:" + n);
                        break;
                    }
                    return new String(bytes);
                }
                case 30: {
                    int count;
                    int used = 1;
                    int size = in.read();
                    if (size > 32 - used) {
                        size = 32 - used;
                    }
                    byte[] bytes = new byte[size];
                    for (int n = 0; n < size; n += count) {
                        count = in.read(bytes, n, size - n);
                        if (count >= 0) continue;
                        System.out.println("StructParser.PrimitiveSpecifier.read not enough bytes for pstring. Expected size:" + size + " actual size:" + n);
                        break;
                    }
                    if ((used += size) < 32) {
                        in.skipBytes(32 - used);
                    }
                    return new String(bytes);
                }
                case 14: {
                    int magic = in.readInt();
                    byte[] bytes = new byte[]{(byte)(magic >>> 24), (byte)(magic >>> 16), (byte)(magic >>> 8), (byte)(magic >>> 0)};
                    return new String(bytes);
                }
                case 15: {
                    long timestamp = (long)in.readInt() & 0xFFFFFFFFL;
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = new Date(MAC_TIMESTAMP_EPOCH + timestamp * 1000L);
                    return fmt.format(date);
                }
                case 16: {
                    TypedefDeclaration typedefDeclaration = declarations.typedefs.get(this.typedef);
                    if (typedefDeclaration == null) {
                        throw new IOException("typedef not found for:" + this.typedef);
                    }
                    return typedefDeclaration.read(in, parentIdentifier, declarations, result);
                }
                case 17: {
                    int b0 = in.read();
                    int b1 = in.read();
                    if (b1 == -1) {
                        throw new EOFException();
                    }
                    return new Short((short)(b0 & 0xFF | (b1 & 0xFF) << 8));
                }
                case 18: {
                    int b0 = in.read();
                    int b1 = in.read();
                    if (b1 == -1) {
                        throw new EOFException();
                    }
                    return new Integer(b0 & 0xFF | (b1 & 0xFF) << 8);
                }
                case 19: {
                    int b0 = in.read();
                    int b1 = in.read();
                    int b2 = in.read();
                    int b3 = in.read();
                    if (b3 == -1) {
                        throw new EOFException();
                    }
                    return new Integer(b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 24);
                }
                case 20: {
                    int b0 = in.read();
                    int b1 = in.read();
                    int b2 = in.read();
                    int b3 = in.read();
                    if (b3 == -1) {
                        throw new EOFException();
                    }
                    return new Long((long)(b0 & 0xFF | (b1 & 0xFF) << 8 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 24) & 0xFFFFFFFFFFFFFFFFL);
                }
                case 21: {
                    int b0 = in.read();
                    int b1 = in.read();
                    int b2 = in.read();
                    int b3 = in.read();
                    int b4 = in.read();
                    int b5 = in.read();
                    int b6 = in.read();
                    int b7 = in.read();
                    if (b7 == -1) {
                        throw new EOFException();
                    }
                    return new Long((long)b0 & 0xFFL | (long)(b1 & 0xFF) << 8 | (long)(b2 & 0xFF) << 16 | (long)(b3 & 0xFF) << 24 | (long)(b4 & 0xFF) << 32 | (long)(b5 & 0xFF) << 40 | (long)(b6 & 0xFF) << 48 | (long)(b7 & 0xFF) << 56);
                }
                case 22: {
                    int b0 = in.read();
                    return new Integer(((b0 & 0xF0) >> 4) * 10 + (b0 & 0xF));
                }
                case 23: {
                    int b0 = in.read();
                    int b1 = in.read();
                    return new Integer(((b0 & 0xF0) >> 4) * 1000 + (b0 & 0xF) * 100 + ((b1 & 0xF0) >> 4) * 10 + (b1 & 0xF));
                }
                case 24: {
                    int wholePart = in.readUnsignedShort();
                    int fractionPart = in.readUnsignedShort();
                    return new Double((double)wholePart + (double)fractionPart / 65536.0);
                }
                case 25: {
                    int fixed = in.readInt();
                    int wholePart = fixed >>> 30;
                    int fractionPart = fixed & 0x3FFFFFFF;
                    return new Double((double)wholePart + (double)fractionPart / 1.073741823E9);
                }
                case 26: {
                    int fixed = in.readUnsignedShort();
                    int wholePart = fixed >>> 8;
                    int fractionPart = fixed & 0xFF;
                    return new Float((float)wholePart + (float)fractionPart / 256.0f);
                }
                case 34: {
                    return in.readBit();
                }
                case 35: {
                    return (int)in.readBits(2);
                }
                case 36: {
                    return (int)in.readBits(3);
                }
                case 27: {
                    return (int)in.readBits(4);
                }
                case 37: {
                    return (int)in.readBits(5);
                }
                case 41: {
                    return (int)in.readBits(9);
                }
                case 33: {
                    return (int)in.readBits(8);
                }
                case 38: {
                    return (int)in.readBits(12);
                }
                case 39: {
                    return (int)in.readBits(16);
                }
                case 42: {
                    int value = (int)in.readBits(31);
                    return (value & 0xFF) << 24 | (value & 0xFF00) << 8 | (value & 0xFF0000) >>> 8 | (value & 0xFF000000) >>> 24;
                }
                case 40: {
                    int value = (int)in.readBits(9);
                    if ((value & 0x256) != 0) {
                        value |= 0xFFFFFF00;
                    }
                    return value;
                }
                case 31: {
                    int clr = in.readUnsignedShort();
                    int red = (clr & 0x700) >> 8;
                    int green = (clr & 0x70) >> 4;
                    int blue = clr & 7;
                    StringBuilder buf = new StringBuilder();
                    String hex = Integer.toHexString(clr);
                    buf.append("0x");
                    for (int i = 0; i < 4 - hex.length(); ++i) {
                        buf.append('0');
                    }
                    buf.append(hex);
                    buf.append(" {rgb:0x");
                    int rgb = (red << 5 | red << 2 | red >>> 1) << 16 | (green << 5 | green << 2 | green >>> 1) << 8 | (blue << 5 | blue << 2 | blue >>> 1);
                    hex = Integer.toHexString(rgb);
                    for (int i = 0; i < 6 - hex.length(); ++i) {
                        buf.append('0');
                    }
                    buf.append(hex);
                    buf.append(", rgb:");
                    buf.append(red << 5 | red << 2 | red >>> 1);
                    buf.append(' ');
                    buf.append(green << 5 | green << 2 | green >>> 1);
                    buf.append(' ');
                    buf.append(blue << 5 | blue << 2 | blue >>> 1);
                    buf.append('}');
                    return new String(buf);
                }
            }
            throw new InternalError("invalid type:" + this.type);
        }
    }

    protected static class MemberDeclaration {
        public TypeSpecifier typeSpecifier;
        public String identifier;
        public ArrayList<ArraySize> arrayList;

        public MemberDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            this.typeSpecifier = new TypeSpecifier(scanner);
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("MemberDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() == 91) {
                this.arrayList = new ArrayList();
                do {
                    this.arrayList.add(new ArraySize(scanner));
                    if (scanner.nextToken() == 93) continue;
                    throw new ParseException(StructParser.errorMsg("MemberDeclaration: ']' expected", scanner));
                } while (scanner.nextToken() == 91);
                scanner.pushBack();
            } else {
                scanner.pushBack();
            }
            if (scanner.nextToken() != 59) {
                if (scanner.ttype == 125) {
                    scanner.pushBack();
                } else {
                    throw new ParseException(StructParser.errorMsg("MemberDeclaration: ';' expected", scanner));
                }
            }
        }

        private void read(ImageInputStream in, String parentIdentifier, Declarations declarations, ArrayList<StructTableModel.Value> result) throws IOException {
            if (this.arrayList != null) {
                for (ArraySize arraySize : this.arrayList) {
                    StructTableModel.Value value;
                    Object obj;
                    int loc;
                    int size = arraySize.getArraySize(declarations, result);
                    if (size == -1) {
                        try {
                            int i = 0;
                            while (true) {
                                loc = result.size();
                                obj = this.typeSpecifier.read(in, parentIdentifier + "." + this.identifier + "[" + i + "]", declarations, this.identifier, result);
                                if (obj != null) {
                                    value = new StructTableModel.Value();
                                    value.qualifiedIdentifier = parentIdentifier + "." + this.identifier;
                                    value.declaration = this.identifier;
                                    value.value = obj;
                                    result.add(value);
                                }
                                ++i;
                            }
                        }
                        catch (EOFException i) {
                            continue;
                        }
                    }
                    for (int i = 0; i < size; ++i) {
                        loc = result.size();
                        obj = this.typeSpecifier.read(in, parentIdentifier + "." + this.identifier + "[" + i + "]", declarations, this.identifier, result);
                        if (obj == null) continue;
                        value = new StructTableModel.Value();
                        value.qualifiedIdentifier = parentIdentifier + "." + this.identifier + "[" + i + "]";
                        value.declaration = this.identifier;
                        value.value = obj;
                        result.add(value);
                    }
                }
            } else {
                Object obj = this.typeSpecifier.read(in, parentIdentifier + "." + this.identifier, declarations, this.identifier, result);
                if (obj != null) {
                    StructTableModel.Value value = new StructTableModel.Value();
                    value.qualifiedIdentifier = parentIdentifier + "." + this.identifier;
                    value.declaration = this.identifier;
                    value.value = obj;
                    result.add(value);
                }
            }
        }
    }

    protected static class StructSpecifier {
        public String identifier;
        public ArrayList<MemberDeclaration> members;

        public StructSpecifier(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("struct")) {
                throw new ParseException(StructParser.errorMsg("StructSpecifier: 'struct' expected", scanner));
            }
            scanner.nextToken();
            if (scanner.ttype == -3) {
                this.identifier = scanner.sval;
            } else if (scanner.ttype == 123) {
                this.members = new ArrayList();
                while (scanner.nextToken() != 125) {
                    scanner.pushBack();
                    this.members.add(new MemberDeclaration(scanner));
                }
            } else {
                throw new ParseException(StructParser.errorMsg("StructSpecifier: identifier or '{' expected", scanner));
            }
        }

        private void read(ImageInputStream in, String parentIdentifier, Declarations declarations, ArrayList<StructTableModel.Value> result) throws IOException {
            for (MemberDeclaration aMember : this.members) {
                aMember.read(in, parentIdentifier, declarations, result);
            }
        }
    }

    protected static class TypeSpecifier {
        public StructSpecifier structSpecifier;
        public PrimitiveSpecifier primitiveSpecifier;
        public EnumSpecifier enumSpecifier;
        public SetSpecifier setSpecifier;
        public ArrayList<ArraySize> arrayList;

        public TypeSpecifier(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() == -3 && scanner.sval.equals("struct")) {
                scanner.pushBack();
                this.structSpecifier = new StructSpecifier(scanner);
            } else {
                scanner.pushBack();
                this.primitiveSpecifier = new PrimitiveSpecifier(scanner);
                scanner.nextToken();
                if (scanner.ttype == -3 && scanner.sval.equals("enum")) {
                    scanner.pushBack();
                    this.enumSpecifier = new EnumSpecifier(scanner);
                } else if (scanner.ttype == -3 && scanner.sval.equals("set")) {
                    scanner.pushBack();
                    this.setSpecifier = new SetSpecifier(scanner);
                } else {
                    scanner.pushBack();
                }
            }
            if (scanner.nextToken() == 91) {
                this.arrayList = new ArrayList();
                do {
                    this.arrayList.add(new ArraySize(scanner));
                    if (scanner.nextToken() == 93) continue;
                    throw new ParseException(StructParser.errorMsg("MemberDeclaration: ']' expected", scanner));
                } while (scanner.nextToken() == 91);
                scanner.pushBack();
            } else {
                scanner.pushBack();
            }
        }

        private int getResolvedPrimitiveType(Declarations declarations) throws IOException {
            if (this.structSpecifier != null) {
                return -1;
            }
            if (this.primitiveSpecifier != null) {
                return this.primitiveSpecifier.getResolvedPrimitveType(declarations);
            }
            return -1;
        }

        private Object read(ImageInputStream in, String parentIdentifier, Declarations declarations, String identifier, ArrayList<StructTableModel.Value> result) throws IOException {
            if (this.structSpecifier != null) {
                if (this.arrayList != null) {
                    for (ArraySize arraySize : this.arrayList) {
                        StructTableModel.Value arrayValue;
                        int j;
                        int loc;
                        int size = arraySize.getArraySize(declarations, result);
                        if (size == -1) {
                            try {
                                int i = 0;
                                while (true) {
                                    loc = result.size();
                                    this.structSpecifier.read(in, parentIdentifier, declarations, result);
                                    for (j = loc; j < result.size(); ++j) {
                                        arrayValue = result.get(j);
                                        arrayValue.index = arrayValue.index == null ? "[" + i + "]" : "[" + i + "]" + arrayValue.index;
                                    }
                                    ++i;
                                }
                            }
                            catch (EOFException i) {
                                continue;
                            }
                        }
                        for (int i = 0; i < size; ++i) {
                            loc = result.size();
                            this.structSpecifier.read(in, parentIdentifier, declarations, result);
                            for (j = loc; j < result.size(); ++j) {
                                arrayValue = result.get(j);
                                arrayValue.index = arrayValue.index == null ? "[" + i + "]" : "[" + i + "]" + arrayValue.index;
                            }
                        }
                    }
                    return null;
                }
                this.structSpecifier.read(in, parentIdentifier, declarations, result);
                return null;
            }
            if (this.primitiveSpecifier.getResolvedPrimitveType(declarations) == 11) {
                if (this.arrayList != null) {
                    StringBuilder buf = new StringBuilder();
                    buf.append('\"');
                    boolean hasValue = false;
                    for (ArraySize arraySize : this.arrayList) {
                        Object value;
                        int size = arraySize.getArraySize(declarations, result);
                        if (size == -1) {
                            try {
                                int i = 0;
                                while (true) {
                                    if ((value = this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result)) != null) {
                                        hasValue = true;
                                        if (value.toString().equals("0x20")) {
                                            buf.append(' ');
                                        } else {
                                            buf.append(value.toString());
                                        }
                                    }
                                    ++i;
                                }
                            }
                            catch (EOFException i) {
                                continue;
                            }
                        }
                        for (int i = 0; i < size; ++i) {
                            value = this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result);
                            if (value == null) continue;
                            hasValue = true;
                            if (value.toString().equals("0x20")) {
                                buf.append(' ');
                                continue;
                            }
                            buf.append(value.toString());
                        }
                    }
                    if (hasValue) {
                        buf.append('\"');
                        return buf.toString();
                    }
                    return null;
                }
                return this.readValue(in, parentIdentifier, declarations, result);
            }
            if (this.primitiveSpecifier.getResolvedPrimitveType(declarations) == 1) {
                if (this.arrayList != null) {
                    StringBuilder buf = new StringBuilder();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    buf.append("0x");
                    boolean hasValue = false;
                    for (ArraySize arraySize : this.arrayList) {
                        String str;
                        Integer value;
                        int size = arraySize.getArraySize(declarations, result);
                        if (size == -1) {
                            try {
                                int i = 0;
                                while (true) {
                                    if ((value = (Integer)this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result)) != null) {
                                        hasValue = true;
                                        str = Integer.toHexString(value & 0xFF);
                                        if (str.length() == 1) {
                                            buf.append('0');
                                        }
                                        buf.append(str);
                                        bout.write(value);
                                    }
                                    ++i;
                                }
                            }
                            catch (EOFException i) {
                                continue;
                            }
                        }
                        for (int i = 0; i < size; ++i) {
                            value = (Integer)this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result);
                            if (value == null) continue;
                            hasValue = true;
                            str = Integer.toHexString(value & 0xFF);
                            if (str.length() == 1) {
                                buf.append('0');
                            }
                            buf.append(str);
                            bout.write(value);
                        }
                    }
                    if (hasValue) {
                        return bout.toByteArray();
                    }
                    return null;
                }
                return this.readValue(in, parentIdentifier, declarations, result);
            }
            if (this.arrayList != null) {
                StringBuilder buf = new StringBuilder();
                buf.append('{');
                boolean hasValue = false;
                for (ArraySize arraySize : this.arrayList) {
                    Object value;
                    int size = arraySize.getArraySize(declarations, result);
                    if (size == -1) {
                        try {
                            int i = 0;
                            while (true) {
                                if (i > 0) {
                                    buf.append(", ");
                                }
                                if ((value = this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result)) != null) {
                                    hasValue = true;
                                    buf.append(value.toString());
                                }
                                ++i;
                            }
                        }
                        catch (EOFException i) {
                            continue;
                        }
                    }
                    for (int i = 0; i < size; ++i) {
                        if (i > 0) {
                            buf.append(", ");
                        }
                        if ((value = arraySize.type == 3 || arraySize.type == 4 ? this.readValue(in, parentIdentifier, declarations, result) : this.readValue(in, parentIdentifier + "[" + i + "]", declarations, result)) == null) continue;
                        hasValue = true;
                        buf.append(value.toString());
                    }
                }
                if (hasValue) {
                    buf.append('}');
                    return buf.toString();
                }
                return null;
            }
            return this.readValue(in, parentIdentifier, declarations, result);
        }

        private Object readValue(ImageInputStream in, String parentIdentifier, Declarations declarations, ArrayList<StructTableModel.Value> result) throws IOException {
            Object value = this.primitiveSpecifier.read(in, parentIdentifier, declarations, result);
            if (value != null) {
                if (value instanceof Number) {
                    int intValue = ((Number)value).intValue();
                    if (this.enumSpecifier != null) {
                        value = this.enumSpecifier.toEnumString(intValue, declarations);
                    } else if (this.setSpecifier != null) {
                        value = this.setSpecifier.toSetString(intValue, declarations);
                    }
                } else if (value instanceof String && this.enumSpecifier != null) {
                    value = this.enumSpecifier.toEnumString((String)value, declarations);
                }
            }
            return value;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("TypeSpecifier ");
            buf.append(this.structSpecifier);
            buf.append(this.primitiveSpecifier);
            buf.append(this.enumSpecifier);
            buf.append(this.setSpecifier);
            buf.append(this.arrayList);
            return buf.toString();
        }
    }

    protected static class SetSpecifier {
        public HashMap<Integer, String> members;
        public String identifier;

        public SetSpecifier(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("set")) {
                throw new ParseException(StructParser.errorMsg("SetSpecifier: 'set' expected", scanner));
            }
            if (scanner.nextToken() == -3) {
                this.identifier = scanner.sval;
            } else if (scanner.ttype == 123) {
                int value = 0;
                this.members = new HashMap();
                do {
                    if (scanner.nextToken() != -3 && scanner.ttype != 34) {
                        throw new ParseException(StructParser.errorMsg("SetSpecifier: set name expected", scanner));
                    }
                    String name = scanner.sval;
                    if (scanner.nextToken() == 61) {
                        value = new IntLiteral(scanner).intValue();
                    } else {
                        value = value == 0 ? 1 : value << 1;
                        scanner.pushBack();
                    }
                    this.members.put(new Integer(value), name);
                } while (scanner.nextToken() == 44);
                if (scanner.ttype != 125) {
                    throw new ParseException(StructParser.errorMsg("SetSpecifier: '}' expected", scanner));
                }
            } else {
                throw new ParseException(StructParser.errorMsg("SetSpecifier: identifier or '{' expected", scanner));
            }
            this.identifier = scanner.sval;
        }

        public String toSetString(int value, Declarations declarations) {
            if (this.identifier != null) {
                SetDeclaration setDecl = declarations.sets.get(this.identifier);
                if (setDecl == null) {
                    throw new InternalError("Set Declaration missing for " + this.identifier);
                }
                return setDecl.setSpecifier.toSetString(value, declarations);
            }
            StringBuilder buf = new StringBuilder();
            buf.append("0x");
            buf.append(Integer.toHexString(value));
            buf.append(" {");
            boolean isFirst = true;
            for (Map.Entry<Integer, String> entry : this.members.entrySet()) {
                int intKey = entry.getKey();
                if ((intKey != 0 || value != 0) && (intKey & value) != intKey) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    buf.append(", ");
                }
                buf.append(entry.getValue());
            }
            buf.append('}');
            return buf.toString();
        }
    }

    protected static class EnumSpecifier {
        public HashMap<Integer, String> members;
        public String identifier;
        public boolean isMagicEnum;

        public EnumSpecifier(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("enum")) {
                throw new ParseException(StructParser.errorMsg("EnumSpecifier: 'enum' expected", scanner));
            }
            if (scanner.nextToken() == -3) {
                this.identifier = scanner.sval;
            } else if (scanner.ttype == 123) {
                int value = -1;
                this.members = new HashMap();
                while (scanner.nextToken() != 125) {
                    if (scanner.ttype != -3 && scanner.ttype != 34) {
                        throw new ParseException(StructParser.errorMsg("EnumSpecifier: enumeration name expected", scanner));
                    }
                    String name = scanner.sval;
                    if (scanner.nextToken() == 61) {
                        MagicOrIntLiteral literal = new MagicOrIntLiteral(scanner);
                        value = literal.intValue();
                        this.isMagicEnum = literal.isMagic();
                    } else {
                        ++value;
                        scanner.pushBack();
                    }
                    this.members.put(new Integer(value), name);
                    if (scanner.nextToken() == 44) continue;
                }
                if (scanner.ttype != 125) {
                    throw new ParseException(StructParser.errorMsg("EnumSpecifier: '}' expected", scanner));
                }
            } else {
                throw new ParseException(StructParser.errorMsg("EnumSpecifier: identifier or '{' expected", scanner));
            }
            this.identifier = scanner.sval;
        }

        public String toEnumString(int value, Declarations declarations) {
            if (this.identifier != null) {
                EnumDeclaration enumDecl = declarations.enums.get(this.identifier);
                if (enumDecl == null) {
                    throw new InternalError("Enum Declaration missing for " + this.identifier);
                }
                return enumDecl.enumSpecifier.toEnumString(value, declarations);
            }
            StringBuilder buf = new StringBuilder();
            Integer intValue = new Integer(value);
            if (this.isMagicEnum) {
                buf.append('\"');
                buf.append(MagicOrIntLiteral.toMagic(value));
                buf.append('\"');
            } else {
                buf.append(Integer.toString(value));
            }
            buf.append(" {");
            if (this.members.get(intValue) != null) {
                buf.append(this.members.get(intValue).toString());
            }
            buf.append('}');
            return buf.toString();
        }

        public String toEnumString(String value, Declarations declarations) {
            if (this.identifier != null) {
                EnumDeclaration enumDecl = declarations.enums.get(this.identifier);
                if (enumDecl == null) {
                    throw new InternalError("Enum Declaration missing for " + this.identifier);
                }
                return enumDecl.enumSpecifier.toEnumString(value, declarations);
            }
            if (value == null || value.length() != 4 || !this.isMagicEnum) {
                return value;
            }
            return this.toEnumString(MagicOrIntLiteral.toInt(value), declarations);
        }
    }

    protected static class TypedefDeclaration {
        public TypeSpecifier typeSpecifier;
        public String identifier;

        public TypedefDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("typedef")) {
                throw new ParseException(StructParser.errorMsg("TypedefDeclaration: 'typedef' expected", scanner));
            }
            this.typeSpecifier = new TypeSpecifier(scanner);
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("TypedefDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() != 59) {
                throw new ParseException(StructParser.errorMsg("TypedefDeclaration: ';' expected", scanner));
            }
        }

        private int getResolvedType(Declarations declarations) throws IOException {
            return this.typeSpecifier.getResolvedPrimitiveType(declarations);
        }

        private Object read(ImageInputStream in, String parentIdentifier, Declarations declarations, ArrayList<StructTableModel.Value> result) throws IOException {
            return this.typeSpecifier.read(in, parentIdentifier, declarations, this.identifier, result);
        }
    }

    protected static class SetDeclaration {
        public SetSpecifier setSpecifier;
        public String identifier;

        public SetDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            this.setSpecifier = new SetSpecifier(scanner);
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("SetDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() != 59) {
                throw new ParseException(StructParser.errorMsg("SetDeclaration: ';' expected", scanner));
            }
        }
    }

    protected static class EnumDeclaration {
        public EnumSpecifier enumSpecifier;
        public String identifier;

        public EnumDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            this.enumSpecifier = new EnumSpecifier(scanner);
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("EnumDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() != 59) {
                throw new ParseException(StructParser.errorMsg("EnumDeclaration: ';' expected", scanner));
            }
        }
    }

    protected static class DescriptionDeclaration {
        public String identifier;
        public String name;
        public String description;

        public DescriptionDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("description")) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: 'magic' expected", scanner));
            }
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() != 34) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: string literal (title) expected", scanner));
            }
            this.name = scanner.sval;
            if (scanner.nextToken() != 44) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: ',' expected", scanner));
            }
            if (scanner.nextToken() != 34) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: string literal (description) expected", scanner));
            }
            this.description = scanner.sval;
            while (scanner.nextToken() == 43) {
                if (scanner.nextToken() != 34) {
                    throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: string literal (description) after '+' expected", scanner));
                }
                this.description = this.description + scanner.sval;
            }
            scanner.pushBack();
            if (scanner.nextToken() != 59) {
                throw new ParseException(StructParser.errorMsg("DescriptionDeclaration: ';' expected", scanner));
            }
        }
    }

    protected static class MagicDeclaration {
        public String identifier;
        public String magic;
        public int ushortMagicFrom;
        public int ushortMagicTo;

        public MagicDeclaration(StreamPosTokenizer scanner) throws IOException, ParseException {
            if (scanner.nextToken() != -3 || !scanner.sval.equals("magic")) {
                throw new ParseException(StructParser.errorMsg("MagicDeclaration: 'magic' expected", scanner));
            }
            if (scanner.nextToken() != -3) {
                throw new ParseException(StructParser.errorMsg("MagicDeclaration: identifier expected", scanner));
            }
            this.identifier = scanner.sval;
            if (scanner.nextToken() == -3 && scanner.sval.equals("ushort")) {
                if (scanner.nextToken() != -2) {
                    throw new ParseException(StructParser.errorMsg("MagicDeclaration: ushort literal expected", scanner));
                }
                this.ushortMagicFrom = (int)scanner.nval;
                if (scanner.nextToken() == 46) {
                    if (scanner.nextToken() != 46) {
                        throw new ParseException(StructParser.errorMsg("MagicDeclaration: interval literal expected", scanner));
                    }
                    if (scanner.nextToken() != -2) {
                        throw new ParseException(StructParser.errorMsg("MagicDeclaration: end interval literal expected", scanner));
                    }
                    this.ushortMagicTo = (int)scanner.nval;
                } else {
                    this.ushortMagicTo = this.ushortMagicFrom;
                    scanner.pushBack();
                }
            } else {
                if (scanner.ttype != 34) {
                    throw new ParseException(StructParser.errorMsg("MagicDeclaration: string literal expected", scanner));
                }
                this.magic = scanner.sval;
            }
            if (scanner.nextToken() != 59) {
                throw new ParseException(StructParser.errorMsg("MagicDeclaration: ';' expected", scanner));
            }
        }
    }

    protected static class Declarations {
        public HashMap<Object, MagicDeclaration> magics = new HashMap();
        public HashMap<String, DescriptionDeclaration> descriptions = new HashMap();
        public HashMap<String, EnumDeclaration> enums = new HashMap();
        public HashMap<String, SetDeclaration> sets = new HashMap();
        public HashMap<String, TypedefDeclaration> typedefs = new HashMap();

        public Declarations(StreamPosTokenizer scanner) throws IOException, ParseException {
            while (scanner.nextToken() != -1) {
                if (scanner.ttype != -3) continue;
                if (scanner.sval.equals("magic")) {
                    scanner.pushBack();
                    MagicDeclaration md = new MagicDeclaration(scanner);
                    if (md.magic != null) {
                        this.magics.put(md.magic, md);
                        continue;
                    }
                    for (int i = md.ushortMagicFrom; i <= md.ushortMagicTo; ++i) {
                        this.magics.put(i, md);
                    }
                    continue;
                }
                if (scanner.sval.equals("description")) {
                    scanner.pushBack();
                    DescriptionDeclaration dd = new DescriptionDeclaration(scanner);
                    this.descriptions.put(dd.identifier, dd);
                    continue;
                }
                if (scanner.sval.equals("enum")) {
                    scanner.pushBack();
                    EnumDeclaration ed = new EnumDeclaration(scanner);
                    this.enums.put(ed.identifier, ed);
                    continue;
                }
                if (scanner.sval.equals("set")) {
                    scanner.pushBack();
                    SetDeclaration sd = new SetDeclaration(scanner);
                    this.sets.put(sd.identifier, sd);
                    continue;
                }
                if (scanner.sval.equals("typedef")) {
                    scanner.pushBack();
                    TypedefDeclaration td = new TypedefDeclaration(scanner);
                    this.typedefs.put(td.identifier, td);
                    continue;
                }
                throw new ParseException(StructParser.errorMsg("Declarations: Expected 'magic', 'description', 'enum', 'set' or 'typedef' ", scanner));
            }
        }

        private StructTableModel readStruct(Object magic, ImageInputStream in) throws IOException {
            ArrayList<StructTableModel.Value> result = new ArrayList<StructTableModel.Value>();
            TypedefDeclaration typedef = null;
            MagicDeclaration magicdef = this.magics.get(magic);
            if (magicdef == null) {
                if (magic instanceof Integer) {
                    throw new IOException("unknown magic:" + Integer.toHexString((Integer)magic));
                }
                throw new IOException("unknown magic:" + magic);
            }
            typedef = this.typedefs.get(magicdef.identifier);
            if (typedef == null) {
                throw new IOException("unknown type:" + magicdef.identifier);
            }
            try {
                Object obj = typedef.read(in, typedef.identifier, this, result);
                if (obj != null) {
                    StructTableModel.Value value = new StructTableModel.Value();
                    value.declaration = typedef.identifier;
                    value.value = obj;
                    result.add(value);
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            return new StructTableModel(typedef, result);
        }
    }
}

