/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.binary;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import ru.sbtqa.monte.media.binary.StructParser;

public class StructTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected ArrayList<Value> data;
    protected StructParser.TypedefDeclaration typedef;
    private final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public StructTableModel(StructParser.TypedefDeclaration typedef, ArrayList<Value> data) {
        this.typedef = typedef;
        this.data = data;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object value;
        Value elem = this.data.get(row);
        if (column == 0) {
            int p = elem.qualifiedIdentifier.indexOf(46);
            String identifier = p == -1 ? elem.qualifiedIdentifier : elem.qualifiedIdentifier.substring(p + 1);
            value = StructTableModel.identifierToString((elem.index == null ? identifier : identifier + elem.index).toString());
        } else {
            value = elem.value;
        }
        return value;
    }

    public static String identifierToString(String s) {
        StringBuilder b = new StringBuilder();
        boolean wasUpperCase = true;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i))) {
                if (!wasUpperCase) {
                    b.append(' ');
                }
                wasUpperCase = true;
            } else {
                wasUpperCase = false;
            }
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Name" : "Value";
    }

    public String toString() {
        return this.typedef != null ? this.typedef.toString() : super.toString();
    }

    public static class Value {
        public String qualifiedIdentifier;
        public Object declaration;
        public String index;
        public Object value;
        public int intValue;

        public Value() {
        }

        public Value(String qualfiedIdentifier, String index, Object declaration, Object value, int intValue) {
            this.qualifiedIdentifier = this.qualifiedIdentifier;
            this.index = index;
            this.declaration = declaration;
            this.value = value;
            this.intValue = intValue;
        }
    }
}

