/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;

public class ColorSpaces {
    public static String toString(ColorSpace cs) {
        if (cs instanceof ICC_ColorSpace) {
            return ColorSpaces.toString((ICC_ColorSpace)cs);
        }
        return cs.toString();
    }

    public static String toString(ICC_ColorSpace cs) {
        StringBuilder b = new StringBuilder();
        b.append("ICC_ColorSpace{");
        b.append("components=" + cs.getNumComponents());
        ICC_Profile p = cs.getProfile();
        b.append(",colorSpaceType=").append(ColorSpaces.colorSpaceTypeToString(p.getColorSpaceType()));
        b.append(",profileClass=").append(ColorSpaces.profileClassToString(p.getProfileClass()));
        b.append('}');
        return b.toString();
    }

    private static String profileClassToString(int profileClass) {
        switch (profileClass) {
            case 5: {
                return "abstract";
            }
            case 4: {
                return "colorspace conversion";
            }
            case 3: {
                return "device link";
            }
            case 1: {
                return "display";
            }
            case 0: {
                return "input";
            }
            case 6: {
                return "named color";
            }
            case 2: {
                return "output";
            }
        }
        return Integer.toString(profileClass);
    }

    private static String colorSpaceTypeToString(int colorSpaceType) {
        switch (colorSpaceType) {
            case 9: {
                return "CMYK";
            }
            case 5: {
                return "RGB";
            }
        }
        return Integer.toString(colorSpaceType);
    }

    public static String toString(ICC_Profile p) {
        StringBuilder b = new StringBuilder();
        b.append("ICC_Profile{");
        b.append("version:");
        b.append(p.getMajorVersion());
        b.append('.');
        b.append(p.getMinorVersion());
        b.append(" numComponents:");
        b.append(p.getNumComponents());
        b.append(",colorSpaceType=").append(ColorSpaces.colorSpaceTypeToString(p.getColorSpaceType()));
        b.append(",profileClass=").append(ColorSpaces.profileClassToString(p.getProfileClass()));
        b.append(p.getPCSType());
        b.append(p.getProfileClass());
        b.append('}');
        return b.toString();
    }
}

