/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.concurrent;

import java.util.LinkedList;

public abstract class EventLoop<E> {
    protected Thread eventProcessor;
    private int priority;
    private final LinkedList<E> queue = new LinkedList();
    private boolean isCoalesce;
    private volatile boolean isAlive = true;

    public EventLoop() {
        this(5);
    }

    public EventLoop(int priority) {
        this.priority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectEvent(E event) {
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            if (!this.isCoalesce || !this.queue.contains(event)) {
                this.queue.add(event);
                if (this.isAlive) {
                    this.startProcessor();
                }
            }
        }
    }

    public void setCoalesce(boolean b) {
        this.isCoalesce = b;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            this.isAlive = true;
            this.startProcessor();
        }
    }

    public void stop() {
        this.isAlive = false;
    }

    public void join() throws InterruptedException {
        Thread t = this.eventProcessor;
        if (t != null) {
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessor() {
        LinkedList<E> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.eventProcessor == null) {
                this.eventProcessor = new Thread(this + " Event Processor"){

                    @Override
                    public void run() {
                        EventLoop.this.processEvents();
                    }
                };
                try {
                    this.eventProcessor.setDaemon(false);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    this.eventProcessor.setPriority(this.priority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.eventProcessor.start();
            }
        }
    }

    protected abstract void processEvent(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (this.isAlive) {
            E event;
            LinkedList<E> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.queue.isEmpty()) {
                    this.eventProcessor = null;
                    return;
                }
                event = this.queue.pop();
            }
            try {
                this.processEvent(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

