/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.eightsvx;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import ru.sbtqa.monte.media.eightsvx.LoopableAudioClip;

public class JDK13ShortAudioClip
implements LoopableAudioClip {
    private Clip clip;
    private byte[] samples;
    private int sampleRate;
    private int volume;
    private float pan;
    private AudioFormat audioFormat;

    public JDK13ShortAudioClip(byte[] samples, int sampleRate, int volume, float pan) {
        this.samples = samples;
        this.sampleRate = sampleRate;
        this.volume = volume;
        this.pan = pan;
    }

    @Override
    public synchronized void loop() {
        this.loop(-1);
    }

    @Override
    public synchronized void play() {
        this.stop();
        if (this.clip == null) {
            try {
                FloatControl control;
                this.clip = this.createClip();
                this.clip.open(this.getAudioFormat(), (byte[])this.samples.clone(), 0, this.samples.length);
                if (this.clip.isControlSupported(FloatControl.Type.PAN)) {
                    control = (FloatControl)this.clip.getControl(FloatControl.Type.PAN);
                    control.setValue(this.pan);
                }
                if (this.clip.isControlSupported(FloatControl.Type.VOLUME)) {
                    control = (FloatControl)this.clip.getControl(FloatControl.Type.VOLUME);
                    control.setValue((float)this.volume / 64.0f);
                }
                this.clip.start();
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                throw new InternalError(e.getMessage());
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.clip != null) {
            this.clip.stop();
            this.clip.close();
            this.clip = null;
        }
    }

    private AudioFormat getAudioFormat() {
        if (this.audioFormat == null) {
            this.audioFormat = new AudioFormat(this.sampleRate, 8, 1, true, true);
        }
        return this.audioFormat;
    }

    private Clip createClip() throws LineUnavailableException {
        DataLine.Info lineInfo = new DataLine.Info(Clip.class, this.getAudioFormat());
        Clip c = (Clip)AudioSystem.getLine(lineInfo);
        return c;
    }

    @Override
    public void loop(int count) {
        this.stop();
        try {
            FloatControl control;
            this.clip = this.createClip();
            this.clip.open(this.getAudioFormat(), (byte[])this.samples.clone(), 0, this.samples.length);
            if (this.clip.isControlSupported(FloatControl.Type.PAN)) {
                control = (FloatControl)this.clip.getControl(FloatControl.Type.PAN);
                control.setValue(this.pan);
            }
            if (this.clip.isControlSupported(FloatControl.Type.VOLUME)) {
                control = (FloatControl)this.clip.getControl(FloatControl.Type.VOLUME);
                control.setValue((float)this.volume / 64.0f);
            }
            this.clip.loop(count);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
            throw new InternalError(e.getMessage());
        }
    }
}

