/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import ru.sbtqa.monte.media.Movie;
import ru.sbtqa.monte.media.gui.border.ImageBevelBorder;
import ru.sbtqa.monte.media.image.Images;
import ru.sbtqa.monte.media.math.Rational;

public class JTimelineEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Movie movie;
    private int timeTrack = 0;
    private Insets trackInsets = new Insets(6, 10, 6, 10);
    private Dimension inSize = new Dimension(9, 6);
    private Dimension outSize = new Dimension(9, 6);
    private Dimension playheadSize = new Dimension(15, 10);
    private Handle focusedHandle = null;
    private Handler handler = new Handler();
    private Border backgroundBorder;
    private Border[] trackBorders;
    private Border[] thumbBorders;
    private Icon[] insertionPointIcon;
    private Icon[] selectionStartIcon;
    private Icon[] selectionEndIcon;

    public JTimelineEditor() {
        this.initComponents();
        this.addMouseListener(this.handler);
        this.addMouseMotionListener(this.handler);
        this.addKeyListener(this.handler);
        this.addFocusListener(this.handler);
        this.setPreferredSize(new Dimension(200, 22));
        this.setMinimumSize(new Dimension(100, 22));
        this.setFocusable(true);
    }

    public Movie getMovie() {
        return this.movie;
    }

    public void setMovie(Movie newValue) {
        if (this.movie != null) {
            this.movie.removePropertyChangeListener(this.handler);
        }
        this.movie = newValue;
        if (this.movie != null) {
            this.movie.addPropertyChangeListener(this.handler);
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        super.paintComponent(g);
        boolean isEnabled = this.isEnabled();
        Window window = SwingUtilities.getWindowAncestor(this);
        boolean isOnActiveWindow = window != null && window.isActive();
        this.getBackgroundBorder().paintBorder(this, gr, 0, 0, this.getWidth(), this.getHeight());
        Rectangle tr = this.getTrackBounds();
        this.getTrackBorder(isEnabled && isOnActiveWindow && this.movie != null).paintBorder(this, gr, tr.x, tr.y, tr.width, tr.height);
        if (this.movie == null) {
            return;
        }
        int ppos = this.timeToPos(this.movie.getInsertionPoint());
        int inpos = this.timeToPos(this.movie.getSelectionStart());
        int outpos = this.timeToPos(this.movie.getSelectionEnd());
        this.getThumbBorder(isEnabled && isOnActiveWindow).paintBorder(this, gr, inpos, tr.y, outpos - inpos + 1, tr.height);
        if (isEnabled) {
            boolean isFocused = this.isFocusOwner();
            this.getSelectionStartIcon(isEnabled && isFocused && this.focusedHandle == Handle.SelectionStart).paintIcon(this, gr, inpos, tr.y);
            this.getSelectionEndIcon(isEnabled && isFocused && this.focusedHandle == Handle.SelectionEnd).paintIcon(this, gr, outpos, tr.y);
            this.getInsertionPointIcon(isEnabled && isFocused && this.focusedHandle == Handle.InsertionPoint).paintIcon(this, gr, ppos, tr.y);
        }
    }

    protected void paintComponentOld(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        super.paintComponent(g);
        Rectangle tr = this.getTrackBounds();
        if (this.movie != null) {
            int x1 = this.timeToPos(this.movie.getSelectionStart());
            int x2 = this.timeToPos(this.movie.getSelectionEnd());
            g.setColor(new Color(0xACACAC));
            g.fillRect(x1, tr.y + 1, x2 - x1 + 1, tr.height - 1);
        }
        g.setColor(new Color(0x8E8E8E));
        g.drawRect(tr.x, tr.y, tr.width, tr.height);
        if (this.movie == null) {
            return;
        }
        g.setColor(new Color(0x737373));
        int x = this.timeToPos(this.movie.getInsertionPoint());
        g.drawLine(x, tr.y, x, tr.y + tr.height - 1);
        Rectangle r = this.getInsertionPointBounds();
        Polygon p = new Polygon();
        p.addPoint(r.x, r.y);
        p.addPoint(r.x + r.width - 1, r.y);
        p.addPoint(r.x + r.width / 2, r.y + r.height - 1);
        p.addPoint(r.x, r.y);
        if (this.focusedHandle == Handle.InsertionPoint && this.isFocusOwner()) {
            g.setColor(new Color(0x737373));
        } else {
            g.setColor(new Color(0xDDDDDD));
        }
        g.fill(p);
        g.setColor(new Color(0x737373));
        g.draw(p);
        r = this.getSelectionStartBounds();
        p = new Polygon();
        p.addPoint(r.x, r.y + r.height - 1);
        p.addPoint(r.x + r.width - 1, r.y + r.height - 1);
        p.addPoint(r.x + r.width - 1, r.y);
        p.addPoint(r.x, r.y + r.height - 1);
        if (this.focusedHandle == Handle.SelectionStart && this.isFocusOwner()) {
            g.setColor(new Color(0x737373));
        } else {
            g.setColor(new Color(0xDDDDDD));
        }
        g.fill(p);
        g.setColor(new Color(0x737373));
        g.draw(p);
        r = this.getSelectionEndBounds();
        p = new Polygon();
        p.addPoint(r.x, r.y + r.height - 1);
        p.addPoint(r.x + r.width - 1, r.y + r.height - 1);
        p.addPoint(r.x, r.y);
        p.addPoint(r.x, r.y + r.height - 1);
        if (this.focusedHandle == Handle.SelectionEnd && this.isFocusOwner()) {
            g.setColor(new Color(0x737373));
        } else {
            g.setColor(new Color(0xDDDDDD));
        }
        g.fill(p);
        g.setColor(new Color(0x737373));
        g.draw(p);
    }

    protected int timeToPos(Rational time) {
        float fraction = time.divide(this.movie.getDuration()).floatValue();
        int pos = (int)(fraction * (float)(this.getWidth() - this.trackInsets.left - this.trackInsets.right));
        return pos + this.trackInsets.left;
    }

    protected Rational posToTime(int pos) {
        Rational fraction = new Rational(pos - this.trackInsets.left, this.getWidth() - this.trackInsets.left - this.trackInsets.right);
        fraction = Rational.max(new Rational(0L, 1L), Rational.min(new Rational(1L, 1L), fraction));
        Rational time = fraction.multiply(this.movie.getDuration());
        if (this.timeTrack != -1) {
            long sample = this.movie.timeToSample(this.timeTrack, time);
            time = this.movie.sampleToTime(this.timeTrack, sample);
        }
        return time;
    }

    protected Rectangle getSelectionStartBounds() {
        int pos = this.timeToPos(this.movie.getSelectionStart());
        return new Rectangle(pos - this.inSize.width, this.getHeight() - this.trackInsets.bottom, this.inSize.width, this.inSize.height);
    }

    protected Rectangle getSelectionEndBounds() {
        int pos = this.timeToPos(this.movie.getSelectionEnd());
        return new Rectangle(pos, this.getHeight() - this.trackInsets.bottom, this.outSize.width, this.outSize.height);
    }

    protected Rectangle getInsertionPointBounds() {
        int pos = this.timeToPos(this.movie.getInsertionPoint());
        return new Rectangle(pos - this.playheadSize.width / 2, 0, this.playheadSize.width, this.playheadSize.height);
    }

    protected Rectangle getTrackBounds() {
        return new Rectangle(this.trackInsets.left, this.trackInsets.top, this.getWidth() - this.trackInsets.left - this.trackInsets.right, 10);
    }

    protected Border getBackgroundBorder() {
        if (this.backgroundBorder == null) {
            this.backgroundBorder = this.readBorders("images/TimelineEditor.background.png", 1, false, new Insets(3, 3, 3, 3))[0];
        }
        return this.backgroundBorder;
    }

    protected Border getTrackBorder(boolean isOnActiveWindow) {
        if (this.trackBorders == null) {
            this.trackBorders = this.readBorders("images/TimelineEditor.tracks.png", 2, false, new Insets(3, 3, 3, 3));
        }
        return this.trackBorders[isOnActiveWindow ? 0 : 1];
    }

    protected Border getThumbBorder(boolean isOnActiveWindow) {
        if (this.thumbBorders == null) {
            this.thumbBorders = this.readBorders("images/TimelineEditor.thumbs.png", 2, false, new Insets(3, 3, 3, 3));
        }
        return this.thumbBorders[isOnActiveWindow ? 0 : 1];
    }

    protected Icon getInsertionPointIcon(boolean isFocused) {
        if (this.insertionPointIcon == null) {
            this.insertionPointIcon = this.readIcons("images/TimelineEditor.playHeads.png", 2, false, new Point(-8, -6));
        }
        return this.insertionPointIcon[isFocused ? 1 : 0];
    }

    protected Icon getSelectionStartIcon(boolean isFocused) {
        if (this.selectionStartIcon == null) {
            this.selectionStartIcon = this.readIcons("images/TimelineEditor.inPoints.png", 2, false, new Point(-12, -6));
        }
        return this.selectionStartIcon[isFocused ? 1 : 0];
    }

    private void updateStyle() {
        this.trackBorders = null;
        this.thumbBorders = null;
        this.insertionPointIcon = null;
        this.selectionStartIcon = null;
        this.selectionEndIcon = null;
    }

    protected Icon getSelectionEndIcon(boolean isFocused) {
        if (this.selectionEndIcon == null) {
            this.selectionEndIcon = this.readIcons("images/TimelineEditor.outPoints.png", 2, false, new Point(-3, -6));
        }
        return this.selectionEndIcon[isFocused ? 1 : 0];
    }

    protected Border[] readBorders(String resource, int count, boolean isHorizontal, Insets insets) {
        resource = resource.substring(0, resource.length() - 4) + this.getStyleSuffix() + ".png";
        try {
            BufferedImage[] imgs = Images.split(ImageIO.read(JTimelineEditor.class.getResource(resource)), count, false);
            Border[] borders = new Border[count];
            for (int i = 0; i < count; ++i) {
                borders[i] = new ImageBevelBorder(imgs[i], new Insets(1, 3, 1, 3));
            }
            return borders;
        }
        catch (Throwable ex) {
            throw new InternalError("JTimelineEditor image not found:" + resource);
        }
    }

    protected Icon[] readIcons(String resource, int count, boolean isHorizontal, final Point offset) {
        resource = resource.substring(0, resource.length() - 4) + this.getStyleSuffix() + ".png";
        try {
            BufferedImage[] imgs = Images.split(ImageIO.read(JTimelineEditor.class.getResource(resource)), count, false);
            Icon[] icons = new Icon[count];
            for (int i = 0; i < count; ++i) {
                icons[i] = new ImageIcon(imgs[i]){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
                        super.paintIcon(c, g, x + offset.x, y + offset.y);
                    }
                };
            }
            return icons;
        }
        catch (Throwable ex) {
            throw new InternalError("JTimelineEditor image not found:" + resource);
        }
    }

    protected String getStyleSuffix() {
        String style = (String)this.getClientProperty("style");
        return style == null ? "" : "." + style;
    }

    public int getTimeTrack() {
        return this.timeTrack;
    }

    public void setTimeTrack(int timeTrack) {
        this.timeTrack = timeTrack;
    }

    private void initComponents() {
        this.setLayout(new GridLayout(1, 0));
    }

    private class Handler
    implements MouseListener,
    MouseMotionListener,
    KeyListener,
    PropertyChangeListener,
    FocusListener {
        private Handle pressedHandle = null;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (JTimelineEditor.this.movie == null) {
                return;
            }
            Point p = e.getPoint();
            Rectangle phBounds = JTimelineEditor.this.getInsertionPointBounds();
            Rectangle inBounds = JTimelineEditor.this.getSelectionStartBounds();
            Rectangle outBounds = JTimelineEditor.this.getSelectionEndBounds();
            if (phBounds.contains(p)) {
                this.pressedHandle = JTimelineEditor.this.focusedHandle = Handle.InsertionPoint;
            } else if (inBounds.contains(p)) {
                this.pressedHandle = JTimelineEditor.this.focusedHandle = Handle.SelectionStart;
                JTimelineEditor.this.movie.setInsertionPoint(JTimelineEditor.this.movie.getSelectionStart());
            } else if (outBounds.contains(p)) {
                this.pressedHandle = JTimelineEditor.this.focusedHandle = Handle.SelectionEnd;
                JTimelineEditor.this.movie.setInsertionPoint(JTimelineEditor.this.movie.getSelectionEnd());
            } else {
                int y = e.getY();
                Rational time = phBounds.contains(e.getX(), phBounds.y) ? JTimelineEditor.this.movie.getInsertionPoint() : JTimelineEditor.this.posToTime(e.getX());
                JTimelineEditor.this.movie.setInsertionPoint(time);
                if (phBounds.contains(phBounds.x, y)) {
                    this.pressedHandle = Handle.InsertionPoint;
                    JTimelineEditor.this.focusedHandle = this.pressedHandle;
                } else if (inBounds.contains(inBounds.x, y)) {
                    int splitPos = (outBounds.x - inBounds.x - inBounds.width) / 2 + inBounds.x + inBounds.width;
                    if (e.getX() < splitPos) {
                        JTimelineEditor.this.movie.setSelectionStart(time);
                        JTimelineEditor.this.movie.setSelectionEnd(Rational.max(JTimelineEditor.this.movie.getSelectionStart(), JTimelineEditor.this.movie.getSelectionEnd()));
                        this.pressedHandle = Handle.SelectionStart;
                        JTimelineEditor.this.focusedHandle = this.pressedHandle;
                    } else {
                        JTimelineEditor.this.movie.setSelectionEnd(time);
                        JTimelineEditor.this.movie.setSelectionStart(Rational.min(JTimelineEditor.this.movie.getSelectionStart(), JTimelineEditor.this.movie.getSelectionEnd()));
                        this.pressedHandle = Handle.SelectionEnd;
                        JTimelineEditor.this.focusedHandle = this.pressedHandle;
                    }
                }
            }
            if (JTimelineEditor.this.focusedHandle != null) {
                JTimelineEditor.this.requestFocus();
            }
            JTimelineEditor.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (JTimelineEditor.this.movie == null) {
                return;
            }
            if (this.pressedHandle != null) {
                Rational time = JTimelineEditor.this.posToTime(e.getX());
                switch (this.pressedHandle) {
                    case SelectionStart: {
                        time = Rational.min(time, JTimelineEditor.this.movie.getSelectionEnd());
                        JTimelineEditor.this.movie.setSelectionStart(time);
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                        break;
                    }
                    case SelectionEnd: {
                        time = Rational.max(JTimelineEditor.this.movie.getSelectionStart(), time);
                        JTimelineEditor.this.movie.setSelectionEnd(time);
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                        break;
                    }
                    case InsertionPoint: {
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                    }
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (JTimelineEditor.this.movie == null) {
                return;
            }
            if (JTimelineEditor.this.focusedHandle != null) {
                Rational time;
                switch (JTimelineEditor.this.focusedHandle) {
                    case SelectionStart: {
                        time = JTimelineEditor.this.movie.getSelectionStart();
                        break;
                    }
                    case SelectionEnd: {
                        time = JTimelineEditor.this.movie.getSelectionEnd();
                        break;
                    }
                    case InsertionPoint: {
                        time = JTimelineEditor.this.movie.getInsertionPoint();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                long sample = JTimelineEditor.this.movie.timeToSample(0, time);
                if (e.getKeyCode() == 37) {
                    time = JTimelineEditor.this.movie.sampleToTime(0, sample - 1L);
                } else if (e.getKeyCode() == 39) {
                    time = JTimelineEditor.this.movie.sampleToTime(0, sample + 1L);
                }
                switch (JTimelineEditor.this.focusedHandle) {
                    case SelectionStart: {
                        JTimelineEditor.this.movie.setSelectionStart(time);
                        JTimelineEditor.this.movie.setSelectionEnd(Rational.max(JTimelineEditor.this.movie.getSelectionStart(), JTimelineEditor.this.movie.getSelectionEnd()));
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                        break;
                    }
                    case SelectionEnd: {
                        JTimelineEditor.this.movie.setSelectionEnd(time);
                        JTimelineEditor.this.movie.setSelectionStart(Rational.min(JTimelineEditor.this.movie.getSelectionStart(), JTimelineEditor.this.movie.getSelectionEnd()));
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                        break;
                    }
                    case InsertionPoint: {
                        JTimelineEditor.this.movie.setInsertionPoint(time);
                    }
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("style")) {
                JTimelineEditor.this.updateStyle();
            }
            JTimelineEditor.this.repaint();
        }

        @Override
        public void focusGained(FocusEvent e) {
            JTimelineEditor.this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            JTimelineEditor.this.repaint();
        }
    }

    static enum Handle {
        InsertionPoint,
        SelectionStart,
        SelectionEnd;

    }
}

