/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import ru.sbtqa.monte.media.gui.datatransfer.CompositeTransferable;
import ru.sbtqa.monte.media.gui.datatransfer.PlainTextTransferable;
import ru.sbtqa.monte.media.gui.datatransfer.StringTransferable;

public class FileTextFieldTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private boolean shouldRemove;
    private JTextComponent exportComp;
    private int p0;
    private int p1;
    private int fileSelectionMode;
    private FileFilter fileFilter;

    public FileTextFieldTransferHandler() {
        this(0);
    }

    public FileTextFieldTransferHandler(int fileSelectionMode) {
        this(fileSelectionMode, null);
    }

    public FileTextFieldTransferHandler(int fileSelectionMode, FileFilter filter) {
        this.fileFilter = filter;
        if (fileSelectionMode != 2 && fileSelectionMode != 0 && fileSelectionMode != 1) {
            throw new IllegalArgumentException("illegal file selection mode:" + fileSelectionMode);
        }
        this.fileSelectionMode = fileSelectionMode;
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        DataFlavor importFlavor;
        JTextComponent c = (JTextComponent)comp;
        if (c == this.exportComp && c.getCaretPosition() >= this.p0 && c.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean imported = false;
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            InputContext ic = c.getInputContext();
            if (ic != null) {
                ic.endComposition();
            }
            try {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (!list.isEmpty()) {
                    File file = (File)list.get(0);
                    switch (this.fileSelectionMode) {
                        case 2: {
                            break;
                        }
                        case 0: {
                            if (!file.isDirectory()) break;
                            return false;
                        }
                        case 1: {
                            if (file.isDirectory()) break;
                            return false;
                        }
                    }
                    if (this.fileFilter != null && !this.fileFilter.accept(file)) {
                        return false;
                    }
                    c.setText(file.getPath());
                }
                imported = true;
            }
            catch (UnsupportedFlavorException list) {
            }
            catch (IOException list) {
                // empty catch block
            }
        }
        if (!imported && (importFlavor = this.getImportFlavor(t.getTransferDataFlavors(), c)) != null) {
            InputContext ic = c.getInputContext();
            if (ic != null) {
                ic.endComposition();
            }
            try {
                String text = (String)t.getTransferData(DataFlavor.stringFlavor);
                Reader r = importFlavor.getReaderForText(t);
                boolean useRead = false;
                this.handleReaderImport(r, c, useRead);
                imported = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imported;
    }

    @Override
    protected Transferable createTransferable(JComponent comp) {
        CompositeTransferable t;
        JTextComponent c = (JTextComponent)comp;
        this.shouldRemove = true;
        this.p0 = c.getSelectionStart();
        this.p1 = c.getSelectionEnd();
        if (this.p0 != this.p1) {
            t = new CompositeTransferable();
            String text = c.getSelectedText();
            t.add(new StringTransferable(text));
            t.add(new PlainTextTransferable(text));
        } else {
            t = null;
        }
        return t;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        JTextComponent c = (JTextComponent)comp;
        if (!c.isEditable() || !c.isEnabled()) {
            return false;
        }
        for (DataFlavor flavor : transferFlavors) {
            if (!flavor.isFlavorJavaFileListType() && !flavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    protected DataFlavor getImportFlavor(DataFlavor[] flavors, JTextComponent c) {
        Object plainFlavor = null;
        DataFlavor refFlavor = null;
        DataFlavor stringFlavor = null;
        for (int i = 0; i < flavors.length; ++i) {
            String mime = flavors[i].getMimeType();
            if (mime.startsWith("text/plain")) {
                return flavors[i];
            }
            if (refFlavor == null && mime.startsWith("application/x-java-jvm-local-objectref") && flavors[i].getRepresentationClass() == String.class) {
                refFlavor = flavors[i];
                continue;
            }
            if (stringFlavor != null || !flavors[i].equals(DataFlavor.stringFlavor)) continue;
            stringFlavor = flavors[i];
        }
        if (refFlavor != null) {
            return refFlavor;
        }
        if (stringFlavor != null) {
            return stringFlavor;
        }
        return null;
    }

    protected void handleReaderImport(Reader in, JTextComponent c, boolean useRead) throws BadLocationException, IOException {
        if (useRead) {
            int startPosition = c.getSelectionStart();
            int endPosition = c.getSelectionEnd();
            int length = endPosition - startPosition;
            EditorKit kit = c.getUI().getEditorKit(c);
            Document doc = c.getDocument();
            if (length > 0) {
                doc.remove(startPosition, length);
            }
            kit.read(in, doc, startPosition);
        } else {
            int nch;
            char[] buff = new char[1024];
            boolean lastWasCR = false;
            StringBuffer sbuff = null;
            while ((nch = in.read(buff, 0, buff.length)) != -1) {
                if (sbuff == null) {
                    sbuff = new StringBuffer(nch);
                }
                int last = 0;
                block5: for (int counter = 0; counter < nch; ++counter) {
                    switch (buff[counter]) {
                        case '\r': {
                            if (lastWasCR) {
                                if (counter == 0) {
                                    sbuff.append('\n');
                                    continue block5;
                                }
                                buff[counter - 1] = 10;
                                continue block5;
                            }
                            lastWasCR = true;
                            continue block5;
                        }
                        case '\n': {
                            if (!lastWasCR) continue block5;
                            if (counter > last + 1) {
                                sbuff.append(buff, last, counter - last - 1);
                            }
                            lastWasCR = false;
                            last = counter;
                            continue block5;
                        }
                        default: {
                            if (!lastWasCR) continue block5;
                            if (counter == 0) {
                                sbuff.append('\n');
                            } else {
                                buff[counter - 1] = 10;
                            }
                            lastWasCR = false;
                        }
                    }
                }
                if (last >= nch) continue;
                if (lastWasCR) {
                    if (last >= nch - 1) continue;
                    sbuff.append(buff, last, nch - last - 1);
                    continue;
                }
                sbuff.append(buff, last, nch - last);
            }
            if (lastWasCR) {
                sbuff.append('\n');
            }
            System.out.println("FileTextTransferHandler " + c.getSelectionStart() + ".." + c.getSelectionEnd());
            c.replaceSelection(sbuff != null ? sbuff.toString() : "");
        }
    }

    @Override
    public int getSourceActions(JComponent comp) {
        JTextComponent c = (JTextComponent)comp;
        if (c instanceof JPasswordField && c.getClientProperty("JPasswordField.cutCopyAllowed") != Boolean.TRUE) {
            return 0;
        }
        return c.isEditable() ? 3 : 1;
    }

    @Override
    protected void exportDone(JComponent comp, Transferable data, int action) {
        JTextComponent c = (JTextComponent)comp;
        if (this.shouldRemove && action == 2) {
            try {
                Document doc = c.getDocument();
                doc.remove(this.p0, this.p1 - this.p0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.exportComp = null;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }
}

