/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.gui.tree;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import ru.sbtqa.monte.media.util.EnumerationIterator;

public class TreeNodeImpl<T extends TreeNodeImpl<T>>
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;

    public TreeNodeImpl(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public TreeNodeImpl(Object userObject) {
        super(userObject);
    }

    public TreeNodeImpl() {
    }

    @Override
    public void add(MutableTreeNode newChild) {
        this.add((TreeNodeImpl)newChild);
    }

    public Iterable<T> breadthFirstIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new EnumerationIterator<TreeNode>(TreeNodeImpl.this.breadthFirstEnumeration());
            }
        };
    }

    public List<T> getChildren() {
        if (this.children == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.children);
    }

    public T clone() {
        return (T)((TreeNodeImpl)super.clone());
    }

    public Iterable<T> depthFirstIterable() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new EnumerationIterator<TreeNode>(TreeNodeImpl.this.depthFirstEnumeration());
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return super.getAllowsChildren();
    }

    public T getChildAfter(TreeNode aChild) {
        return (T)((TreeNodeImpl)super.getChildAfter(aChild));
    }

    public T getChildAt(int index) {
        return (T)((TreeNodeImpl)super.getChildAt(index));
    }

    public T getChildBefore(TreeNode aChild) {
        return (T)((TreeNodeImpl)super.getChildBefore(aChild));
    }

    public T getFirstChild() {
        return (T)((TreeNodeImpl)super.getFirstChild());
    }

    public T getFirstLeaf() {
        return (T)((TreeNodeImpl)super.getFirstLeaf());
    }

    @Override
    public int getIndex(TreeNode aChild) {
        return super.getIndex(aChild);
    }

    public T getLastChild() {
        return (T)((TreeNodeImpl)super.getLastChild());
    }

    public T getLastLeaf() {
        return (T)((TreeNodeImpl)super.getLastLeaf());
    }

    public T getNextLeaf() {
        return (T)((TreeNodeImpl)super.getNextLeaf());
    }

    public T getNextNode() {
        return (T)((TreeNodeImpl)super.getNextNode());
    }

    public T getNextSibling() {
        return (T)((TreeNodeImpl)super.getNextSibling());
    }

    public T getParent() {
        return (T)((TreeNodeImpl)super.getParent());
    }

    @Override
    public TreeNode[] getPath() {
        return this.getPathToRootEx(this, 0);
    }

    protected TreeNode[] getPathToRootEx(TreeNodeImpl<T> aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRootEx((TreeNodeImpl<T>)aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public T getPreviousLeaf() {
        return (T)((TreeNodeImpl)super.getPreviousLeaf());
    }

    public T getPreviousNode() {
        return (T)((TreeNodeImpl)super.getPreviousNode());
    }

    public T getPreviousSibling() {
        return (T)((TreeNodeImpl)super.getPreviousSibling());
    }

    public T getRoot() {
        return (T)((TreeNodeImpl)super.getRoot());
    }

    public T getSharedAncestor(DefaultMutableTreeNode aNode) {
        return (T)((TreeNodeImpl)super.getSharedAncestor(aNode));
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert((TreeNodeImpl)newChild, childIndex);
    }

    public Iterable<T> pathFromAncestorIterable(TreeNode ancestor) {
        return (Iterable)((Object)new EnumerationIterator<TreeNode>(this.pathFromAncestorEnumeration(ancestor)));
    }

    public Iterable<T> postorderIterable() {
        return (Iterable)((Object)new EnumerationIterator<TreeNode>(this.postorderEnumeration()));
    }

    public Iterable<T> preorderIterable() {
        return (Iterable)((Object)new EnumerationIterator<TreeNode>(this.preorderEnumeration()));
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        super.setParent((TreeNodeImpl)newParent);
    }
}

