/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.iff;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.tree.TreeNode;
import ru.sbtqa.monte.media.AbortException;
import ru.sbtqa.monte.media.ParseException;
import ru.sbtqa.monte.media.gui.BackgroundTask;
import ru.sbtqa.monte.media.gui.tree.TreeNodeImpl;
import ru.sbtqa.monte.media.iff.IFFChunk;
import ru.sbtqa.monte.media.iff.IFFParser;
import ru.sbtqa.monte.media.iff.IFFVisitor;

public class AnimMerger
extends JFrame {
    private static final long serialVersionUID = 1L;
    private File file1;
    private File file2;
    private JFileChooser chooser;
    private static NumberFormat numFormat = NumberFormat.getInstance();
    public static final int CMAP_ID = IFFParser.stringToID("CMAP");
    public static final int ILBM_ID = IFFParser.stringToID("ILBM");
    public static final int ANHD_ID = IFFParser.stringToID("ANHD");
    private static final int[] sequence = new int[]{IFFParser.stringToID("ANIM"), IFFParser.stringToID("8SVX"), IFFParser.stringToID("ILBM"), IFFParser.stringToID("VHDR"), IFFParser.stringToID("ANNO"), IFFParser.stringToID("CAMG"), IFFParser.stringToID("BMHD"), IFFParser.stringToID("ANHD"), IFFParser.stringToID("CHAN"), IFFParser.stringToID("SCTL"), IFFParser.stringToID("CMAP"), IFFParser.stringToID("DPPS"), IFFParser.stringToID("DPAN"), IFFParser.stringToID("DLTA"), IFFParser.stringToID("BODY")};
    private static Comparator<IFFChunkNode> nodeComparator = new Comparator<IFFChunkNode>(){

        @Override
        public int compare(IFFChunkNode o1, IFFChunkNode o2) {
            return o1.getSeqIndex() - o2.getSeqIndex();
        }
    };
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuBar menuBar;
    private JMenuItem mergeMenuItem;

    public AnimMerger() {
        this.initComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(File f1, File f2) throws IOException {
        IFFParser iff;
        Loader loader = new Loader();
        try (FileInputStream in = new FileInputStream(f1);){
            iff = new IFFParser();
            iff.parse(in, loader);
        }
        IFFChunkNode root1 = loader.getRoot();
        loader = new Loader();
        in = new FileInputStream(f2);
        try {
            iff = new IFFParser();
            iff.parse(in, loader);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        catch (AbortException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            ((InputStream)in).close();
        }
        IFFChunkNode root2 = loader.getRoot();
        root1.mergeFrom(root2);
        File file3 = new File(this.file1.getParentFile(), "merged" + this.file1.getName());
        try (DataOutputStream out = new DataOutputStream(new FileOutputStream(file3));){
            root1.write(out);
            out.flush();
        }
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.mergeMenuItem = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.setTitle("ANIM Merger");
        this.fileMenu.setText("File");
        this.mergeMenuItem.setText("Merge...");
        this.mergeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimMerger.this.merge(evt);
            }
        });
        this.fileMenu.add(this.mergeMenuItem);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnimMerger.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void merge(ActionEvent evt) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setDialogType(0);
        if (this.file1 != null) {
            this.chooser.setSelectedFile(this.file1);
        }
        if (this.chooser.showDialog(this, "Open File 1") == 0) {
            this.file1 = this.chooser.getSelectedFile();
            if (this.file2 != null) {
                this.chooser.setSelectedFile(this.file2);
            }
            if (this.chooser.showDialog(this, "Open File 2") == 0) {
                this.file2 = this.chooser.getSelectedFile();
                new BackgroundTask(){

                    @Override
                    public void construct() throws IOException {
                        AnimMerger.this.merge(AnimMerger.this.file1, AnimMerger.this.file2);
                    }

                    @Override
                    public void failed(Throwable result) {
                        result.printStackTrace();
                        JOptionPane.showMessageDialog(AnimMerger.this, "<html>Error merging files<br>" + result, "AnimMerger", 0);
                    }

                    @Override
                    public void done() {
                        JOptionPane.showMessageDialog(AnimMerger.this, "Done", "AnimMerger", 1);
                    }
                }.start();
            }
        }
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        AnimMerger f = new AnimMerger();
        f.setSize(400, 300);
        f.setVisible(true);
    }

    protected static class Loader
    implements IFFVisitor {
        private IFFChunkNode root;
        private IFFChunkNode current;

        public IFFChunkNode getRoot() {
            return this.root;
        }

        @Override
        public void enterGroup(IFFChunk group) throws ParseException, AbortException {
            IFFChunkNode groupNode = new IFFChunkNode(group.getID(), group.getType(), (int)group.getSize(), (int)group.getScan(), null);
            if (this.current == null) {
                this.root = this.current = groupNode;
            } else {
                this.current.add(groupNode);
                this.current = groupNode;
            }
        }

        @Override
        public void leaveGroup(IFFChunk group) throws ParseException, AbortException {
            this.current = (IFFChunkNode)this.current.getParent();
        }

        @Override
        public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException, AbortException {
            IFFChunkNode chunkNode = new IFFChunkNode(group.getType(), chunk.getID(), (int)chunk.getSize(), (int)chunk.getScan(), chunk.getData());
            this.current.add(chunkNode);
        }
    }

    protected static class IFFChunkNode
    extends TreeNodeImpl<IFFChunkNode> {
        private static final long serialVersionUID = 1L;
        private int type;
        private int id;
        private int size;
        private int offset;
        private byte[] data;

        public int getPaddedChunkSize() {
            return this.size + this.size % 2 + 8;
        }

        public void write(DataOutputStream out) throws IOException {
            System.out.println("write " + IFFParser.idToString(this.id) + " size=" + this.size);
            if (this.data != null) {
                out.writeInt(this.id);
                out.writeInt(this.size);
                out.write(this.data);
                if (this.data.length % 2 == 1) {
                    out.writeByte(0);
                }
            } else {
                out.writeInt(this.type);
                out.writeInt(this.size);
                out.writeInt(this.id);
                Enumeration<TreeNode> i = this.children();
                while (i.hasMoreElements()) {
                    IFFChunkNode child = (IFFChunkNode)i.nextElement();
                    child.write(out);
                }
            }
        }

        public void mergeFrom(IFFChunkNode that) {
            if (this.data != null) {
                if (this.id == ANHD_ID) {
                    this.mergeANHD(that);
                }
            } else if (this.isSameAs(that)) {
                ArrayList<TreeNode> mergedChildren = new ArrayList<TreeNode>(Math.max(this.getChildCount(), that.getChildCount()));
                Collections.sort(this.getChildren(), nodeComparator);
                Collections.sort(that.getChildren(), nodeComparator);
                int thatCount = that.getChildCount();
                int thisCount = this.getChildCount();
                int thisIndex = 0;
                int thatIndex = 0;
                while (thisIndex < thisCount || thatIndex < thatCount) {
                    int comparison = thisIndex >= thisCount ? 1 : (thatIndex >= thatCount ? -1 : ((IFFChunkNode)this.getChildAt(thisIndex)).compareTo((IFFChunkNode)that.getChildAt(thatIndex)));
                    if (comparison < 0) {
                        System.out.println("Inserting from File1:" + this.getChildAt(thisIndex) + " into " + this);
                        mergedChildren.add(this.getChildAt(thisIndex));
                        ++thisIndex;
                        continue;
                    }
                    if (comparison == 0) {
                        ((IFFChunkNode)this.getChildAt(thisIndex)).mergeFrom((IFFChunkNode)that.getChildAt(thatIndex));
                        mergedChildren.add(this.getChildAt(thisIndex));
                        ++thatIndex;
                        ++thisIndex;
                        continue;
                    }
                    IFFChunkNode thatNode = (IFFChunkNode)that.getChildAt(thatIndex);
                    if (thatNode.id == CMAP_ID || thatNode.id == ILBM_ID) {
                        System.out.println("Skipping from File2:" + that.getChildAt(thatIndex));
                    } else {
                        System.out.println("Inserting from File2:" + that.getChildAt(thatIndex) + " into " + this);
                        mergedChildren.add(that.getChildAt(thatIndex));
                    }
                    ++thatIndex;
                }
                this.removeAllChildren();
                this.size = 4;
                for (IFFChunkNode iFFChunkNode : mergedChildren) {
                    this.size += iFFChunkNode.getPaddedChunkSize();
                    this.add(iFFChunkNode);
                }
            } else {
                System.out.println(this + "!=" + that);
            }
        }

        public void mergeANHD(IFFChunkNode that) {
            int i;
            System.out.print(IFFParser.idToString(this.id) + " " + IFFParser.idToString(that.id) + " reltime=");
            for (i = 0; i < 4; ++i) {
                this.data[10 + i] = 0;
            }
            for (i = 0; i < 4; ++i) {
                this.data[14 + i] = that.data[14 + i];
                System.out.print(that.data[14 + i] + " ");
            }
            System.out.println();
        }

        public int compareTo(IFFChunkNode that) {
            return this.getSeqIndex() - that.getSeqIndex();
        }

        public int getSeqIndex() {
            for (int i = 0; i < sequence.length; ++i) {
                if (this.id != sequence[i]) continue;
                return i;
            }
            throw new ArrayIndexOutOfBoundsException("no index for " + IFFParser.idToString(this.id));
        }

        public IFFChunkNode(int type, int id, int size, int offset, byte[] data) {
            this.type = type;
            this.id = id;
            this.size = size;
            this.offset = offset;
            this.data = data;
        }

        public String getType() {
            return IFFParser.idToString(this.type);
        }

        public String getID() {
            return IFFParser.idToString(this.id);
        }

        public int getSize() {
            return this.size;
        }

        public int getOffset() {
            return this.offset;
        }

        public byte[] getRawData() {
            return this.data;
        }

        public boolean isSameAs(IFFChunkNode that) {
            return this.type == that.type && this.id == that.id;
        }

        @Override
        public String toString() {
            return IFFParser.idToString(this.type) + " " + IFFParser.idToString(this.id);
        }

        public void dump(int depth) {
            StringBuffer buf = new StringBuffer(depth);
            for (int i = 0; i < depth; ++i) {
                buf.append('.');
            }
            buf.append(IFFParser.idToString(this.type) + " " + IFFParser.idToString(this.id) + " " + numFormat.format(this.size));
            System.out.println(buf.toString());
            for (IFFChunkNode child : this.getChildren()) {
                child.dump(depth + 1);
            }
        }
    }
}

