/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.iff;

import java.util.ArrayList;
import java.util.HashMap;
import ru.sbtqa.monte.media.iff.IFFParser;

public class IFFChunk {
    private int id;
    private int type;
    private long size;
    private long scan;
    private byte[] data;
    private HashMap<IFFChunk, IFFChunk> propertyChunks;
    private ArrayList<IFFChunk> collectionChunks;

    public IFFChunk(int type, int id) {
        this.id = id;
        this.type = type;
        this.size = -1L;
        this.scan = -1L;
    }

    public IFFChunk(int type, int id, long size, long scan) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
    }

    public IFFChunk(int type, int id, long size, long scan, IFFChunk propGroup) {
        this.id = id;
        this.type = type;
        this.size = size;
        this.scan = scan;
        if (propGroup != null) {
            if (propGroup.propertyChunks != null) {
                this.propertyChunks = (HashMap)propGroup.propertyChunks.clone();
            }
            if (propGroup.collectionChunks != null) {
                this.collectionChunks = (ArrayList)propGroup.collectionChunks.clone();
            }
        }
    }

    public int getID() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public long getScan() {
        return this.scan;
    }

    public void putPropertyChunk(IFFChunk chunk) {
        if (this.propertyChunks == null) {
            this.propertyChunks = new HashMap();
        }
        this.propertyChunks.put(chunk, chunk);
    }

    public IFFChunk getPropertyChunk(int id) {
        if (this.propertyChunks == null) {
            return null;
        }
        IFFChunk chunk = new IFFChunk(this.type, id);
        return this.propertyChunks.get(chunk);
    }

    public Iterable<IFFChunk> propertyChunks() {
        if (this.propertyChunks == null) {
            this.propertyChunks = new HashMap();
        }
        return this.propertyChunks.keySet();
    }

    public void addCollectionChunk(IFFChunk chunk) {
        if (this.collectionChunks == null) {
            this.collectionChunks = new ArrayList();
        }
        this.collectionChunks.add(chunk);
    }

    public IFFChunk[] getCollectionChunks(int id) {
        if (this.collectionChunks == null) {
            return new IFFChunk[0];
        }
        int i = 0;
        for (IFFChunk chunk : this.collectionChunks) {
            if (chunk.id != id) continue;
            ++i;
        }
        IFFChunk[] array = new IFFChunk[i];
        i = 0;
        for (IFFChunk chunk : this.collectionChunks) {
            if (chunk.id != id) continue;
            array[i++] = chunk;
        }
        return array;
    }

    public Iterable<IFFChunk> collectionChunks() {
        if (this.collectionChunks == null) {
            this.collectionChunks = new ArrayList();
        }
        return this.collectionChunks;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public boolean equals(Object another) {
        if (another instanceof IFFChunk) {
            IFFChunk that = (IFFChunk)another;
            return that.id == this.id && that.type == this.type;
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return super.toString() + "{" + IFFParser.idToString(this.getType()) + "," + IFFParser.idToString(this.getID()) + "}";
    }
}

