/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.ilbm;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.ilbm.ColorCyclingMemoryImageSource;
import ru.sbtqa.monte.media.ilbm.ILBMDecoder;
import ru.sbtqa.monte.media.ilbm.ILBMImageReaderSpi;
import ru.sbtqa.monte.media.io.ImageInputStreamAdapter;

public class ILBMImageReader
extends ImageReader {
    private ArrayList<ColorCyclingMemoryImageSource> images = null;

    public ILBMImageReader(ILBMImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        if (allowSearch && this.images == null) {
            this.readImages();
        }
        return this.images.size();
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readImages();
        ColorCyclingMemoryImageSource iip = this.images.get(imageIndex);
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(iip.getColorModel(), iip.getColorModel().createCompatibleSampleModel(iip.getWidth(), iip.getHeight())));
        return l.iterator();
    }

    @Override
    public float getAspectRatio(int imageIndex) throws IOException {
        this.readImages();
        ColorCyclingMemoryImageSource mis = this.images.get(imageIndex);
        float ratio = (float)this.getWidth(imageIndex) / (float)this.getHeight(imageIndex);
        if (mis.getProperties().containsKey("aspect")) {
            ratio = (float)((double)ratio * (Double)mis.getProperties().get("aspect"));
        }
        return ratio;
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.readImages();
        return this.images.get(imageIndex).toBufferedImage();
    }

    private void readImages() throws IOException {
        ImageInputStream in = (ImageInputStream)this.getInput();
        if (this.images == null) {
            in.seek(0L);
            ILBMDecoder d = new ILBMDecoder(new ImageInputStreamAdapter(in));
            this.images = d.produce();
        }
    }
}

