/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.image;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import ru.sbtqa.monte.media.AbstractVideoCodec;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.iff.IFFVisitor;
import ru.sbtqa.monte.media.ilbm.ColorCyclingMemoryImageSource;
import ru.sbtqa.monte.media.ilbm.ILBMDecoder;
import ru.sbtqa.monte.media.image.BitmapImage;
import ru.sbtqa.monte.media.image.BitmapImageFactory;
import ru.sbtqa.monte.media.pbm.PBMDecoder;

public class BitmapCodec
extends AbstractVideoCodec {
    public BitmapCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "ILBM", VideoFormatKeys.DataClassKey, BitmapImage.class})});
    }

    @Override
    public Format setOutputFormat(Format f) {
        super.setOutputFormat(f);
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey, VideoFormatKeys.DepthKey));
        }
        return this.outputFormat;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        out.setMetaTo(in);
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        out.format = this.outputFormat;
        try {
            out.setFlag(BufferFlag.KEYFRAME);
            if (in.data instanceof File) {
                boolean success;
                ArrayList<Object> imgs;
                IFFVisitor d2;
                Throwable throwable;
                BufferedInputStream ins;
                File f = (File)in.data;
                try {
                    ins = new BufferedInputStream(new FileInputStream(f));
                    throwable = null;
                    try {
                        d2 = new ILBMDecoder(ins);
                        imgs = ((ILBMDecoder)d2).produceBitmaps();
                        BitmapImage img = imgs.get(0);
                        out.data = img;
                        success = true;
                    }
                    catch (Throwable d2) {
                        throwable = d2;
                        throw d2;
                    }
                    finally {
                        if (ins != null) {
                            if (throwable != null) {
                                try {
                                    ((InputStream)ins).close();
                                }
                                catch (Throwable d2) {
                                    throwable.addSuppressed(d2);
                                }
                            } else {
                                ((InputStream)ins).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    success = false;
                }
                if (!success) {
                    try {
                        ins = new BufferedInputStream(new FileInputStream(f));
                        throwable = null;
                        try {
                            d2 = new PBMDecoder(ins);
                            imgs = ((PBMDecoder)d2).produce();
                            ColorCyclingMemoryImageSource mis = (ColorCyclingMemoryImageSource)imgs.get(0);
                            out.data = BitmapImageFactory.toBitmapImage(mis);
                            success = true;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ins != null) {
                                if (throwable != null) {
                                    try {
                                        ((InputStream)ins).close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    ((InputStream)ins).close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        success = false;
                    }
                }
                if (!success) {
                    BufferedImage img = ImageIO.read(f);
                    out.data = BitmapImageFactory.toBitmapImage(img);
                    success = true;
                }
            } else if (in.data instanceof BitmapImage) {
                out.data = in.data;
            } else if (in.data instanceof BufferedImage) {
                out.data = BitmapImageFactory.toBitmapImage((BufferedImage)in.data);
            }
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

