/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import ru.sbtqa.monte.media.ilbm.HAMColorModel;

public class BitmapImage
implements Cloneable {
    private byte[] bitmap;
    private int width;
    private int height;
    private int depth;
    private int bitplaneStride;
    private int scanlineStride;
    private ColorModel planarColorModel;
    private ColorModel preferredChunkyColorModel_;
    private ColorModel currentChunkyColorModel_;
    private ColorModel lastPixelColorModel_;
    private int pixelType;
    public static final int BYTE_PIXEL = 1;
    public static final int INT_PIXEL = 2;
    public static final int SHORT_PIXEL = 2;
    public static final int NO_PIXEL = 0;
    private byte[] bytePixels;
    private int[] intPixels;
    private short[] shortPixels;
    private boolean enforceDirectColors_ = false;

    public void setEnforceDirectColors(boolean b) {
        this.enforceDirectColors_ = b;
    }

    public boolean isEnforceDirectColors() {
        return this.enforceDirectColors_;
    }

    public BitmapImage(int width, int height, int depth, ColorModel colorModel) {
        this(width, height, depth, colorModel, true);
    }

    public BitmapImage(int width, int height, int depth, ColorModel colorModel, boolean isInterleaved) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.planarColorModel = colorModel;
        if (isInterleaved) {
            this.bitplaneStride = (width + 15) / 16 * 2;
            this.scanlineStride = this.bitplaneStride * depth;
            this.bitmap = new byte[this.scanlineStride * height];
        } else {
            this.scanlineStride = (width + 15) / 16 * 2;
            this.bitplaneStride = this.scanlineStride * depth;
            this.bitmap = new byte[this.bitplaneStride * height];
        }
        this.pixelType = 0;
    }

    public BitmapImage(int width, int height, int depth, ColorModel colorModel, int bitStride, int scanlineStride) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.planarColorModel = colorModel;
        this.bitplaneStride = bitStride;
        this.scanlineStride = scanlineStride;
        this.bitmap = this.bitplaneStride < scanlineStride ? new byte[scanlineStride * height] : new byte[this.bitplaneStride * height];
        this.pixelType = 0;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getBitplaneStride() {
        return this.bitplaneStride;
    }

    public void setPlanarColorModel(ColorModel colorModel) {
        this.planarColorModel = colorModel;
    }

    public ColorModel getPlanarColorModel() {
        return this.planarColorModel;
    }

    public void setPreferredChunkyColorModel(ColorModel colorModel) {
        this.preferredChunkyColorModel_ = colorModel;
    }

    public ColorModel getChunkyColorModel() {
        if (this.currentChunkyColorModel_ == null) {
            this.convertToChunky(0, 0, 0, 0);
        }
        return this.currentChunkyColorModel_;
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public byte[] getBytePixels() {
        if (this.pixelType == 1) {
            return this.bytePixels;
        }
        return null;
    }

    public short[] getShortPixels() {
        if (this.pixelType == 1) {
            return this.shortPixels;
        }
        return null;
    }

    public int[] getIntPixels() {
        if (this.pixelType == 2) {
            return this.intPixels;
        }
        return null;
    }

    public int getPixelType() {
        return this.pixelType;
    }

    public BitmapImage clone() {
        try {
            BitmapImage theClone = (BitmapImage)super.clone();
            theClone.bitmap = (byte[])this.bitmap.clone();
            if (this.getPixelType() == 1) {
                theClone.bytePixels = (byte[])this.bytePixels.clone();
            }
            if (this.getPixelType() == 2) {
                theClone.intPixels = (int[])this.intPixels.clone();
            }
            return theClone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int convertToChunky() {
        return this.convertToChunky(0, 0, this.getHeight() - 1, this.getWidth() - 1);
    }

    public int convertToChunky(int top, int left, int bottom, int right) {
        this.pixelType = 0;
        if (top < 0) {
            top = 0;
        }
        if (left < 0) {
            left = 0;
        }
        if (bottom > this.getHeight() - 1) {
            bottom = this.getHeight() - 1;
        }
        if (right > this.getWidth() - 1) {
            right = this.getWidth() - 1;
        }
        if (this.planarColorModel instanceof HAMColorModel) {
            if (this.intPixels == null || this.intPixels.length != this.getWidth() * this.getHeight()) {
                this.bytePixels = null;
                this.shortPixels = null;
                this.intPixels = new int[this.getWidth() * this.getHeight()];
            }
            this.currentChunkyColorModel_ = this.planarColorModel;
            if (((HAMColorModel)this.planarColorModel).getHAMType() == 6) {
                this.ham6PlanesToDirectPixels(top, left, bottom, right);
            } else if (((HAMColorModel)this.planarColorModel).getHAMType() == 8) {
                this.ham8PlanesToDirectPixels(top, left, bottom, right);
            } else {
                throw new InternalError("unsupported ham model:" + this.planarColorModel);
            }
            this.pixelType = 2;
        } else if (this.planarColorModel instanceof IndexColorModel) {
            if (this.enforceDirectColors_ || this.preferredChunkyColorModel_ instanceof DirectColorModel) {
                if (this.preferredChunkyColorModel_ != null && ((DirectColorModel)this.preferredChunkyColorModel_).getPixelSize() == 16) {
                    if (this.shortPixels == null || this.shortPixels.length != this.getWidth() * this.getHeight()) {
                        this.bytePixels = null;
                        this.intPixels = null;
                        this.shortPixels = null;
                        this.shortPixels = new short[this.getWidth() * this.getHeight()];
                    }
                    this.currentChunkyColorModel_ = this.preferredChunkyColorModel_ != null && this.preferredChunkyColorModel_ instanceof DirectColorModel ? this.preferredChunkyColorModel_ : new DirectColorModel(16, 31744, 992, 31);
                    this.indexPlanesTo555(top, left, bottom, right);
                    this.pixelType = 2;
                } else {
                    if (this.intPixels == null || this.intPixels.length != this.getWidth() * this.getHeight()) {
                        this.bytePixels = null;
                        this.shortPixels = null;
                        this.intPixels = new int[this.getWidth() * this.getHeight()];
                    }
                    this.currentChunkyColorModel_ = this.preferredChunkyColorModel_ != null && this.preferredChunkyColorModel_ instanceof DirectColorModel ? this.preferredChunkyColorModel_ : ColorModel.getRGBdefault();
                    this.currentChunkyColorModel_ = new DirectColorModel(24, 0xFF0000, 65280, 255);
                    this.indexPlanesToDirectPixels(top, left, bottom, right);
                    this.pixelType = 2;
                }
            } else {
                if (this.bytePixels == null || this.bytePixels.length != this.getWidth() * this.getHeight()) {
                    this.intPixels = null;
                    this.shortPixels = null;
                    this.bytePixels = new byte[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.planarColorModel;
                this.indexPlanesToIndexPixels(top, left, bottom, right);
                this.pixelType = 1;
            }
        } else if (this.planarColorModel instanceof DirectColorModel) {
            if (((DirectColorModel)this.planarColorModel).getPixelSize() == 16) {
                if (this.shortPixels == null || this.shortPixels.length != this.getWidth() * this.getHeight()) {
                    this.bytePixels = null;
                    this.intPixels = null;
                    this.shortPixels = null;
                    this.shortPixels = new short[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.planarColorModel;
                this.directPlanesTo555(top, left, bottom, right);
                this.pixelType = 2;
            } else {
                if (this.intPixels == null || this.intPixels.length != this.getWidth() * this.getHeight()) {
                    this.bytePixels = null;
                    this.shortPixels = null;
                    this.shortPixels = null;
                    this.intPixels = new int[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.planarColorModel;
                this.directPlanesToDirectPixels(top, left, bottom, right);
                this.pixelType = 2;
            }
        } else {
            throw new InternalError("unsupported color model:" + this.planarColorModel);
        }
        return this.pixelType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void convertFromChunky(BufferedImage image) {
        if (this.planarColorModel instanceof HAMColorModel) {
            throw new UnsupportedOperationException("HAM mode not implemented:" + this.planarColorModel);
        }
        if (this.planarColorModel instanceof IndexColorModel) {
            void var2_3;
            if (image.getType() != 13) throw new UnsupportedOperationException("index color model not implemented:" + this.planarColorModel);
            this.planarColorModel = image.getColorModel();
            WritableRaster writableRaster = image.getRaster();
            int dx = 0;
            int dy = 0;
            while (var2_3.getParent() != null) {
                dx += var2_3.getMinX();
                dy += var2_3.getMinY();
                Raster raster = var2_3.getParent();
            }
            DataBufferByte dbuf = (DataBufferByte)image.getRaster().getDataBuffer();
            int inScanlineStride = var2_3.getWidth();
            byte[] inb = dbuf.getData();
            if (this.bytePixels == null || this.bytePixels.length != this.width * this.height) {
                this.bytePixels = new byte[this.width * this.height];
            }
            for (int y = 0; y < this.height; ++y) {
                System.arraycopy(inb, dx + (y + dy) * inScanlineStride, this.bytePixels, y * this.width, this.width);
            }
        } else {
            if (!(this.planarColorModel instanceof DirectColorModel)) throw new UnsupportedOperationException("unsupported color model:" + this.planarColorModel);
            throw new UnsupportedOperationException("index color model not implemented:" + this.planarColorModel);
        }
        this.indexPixelsToIndexPlanes(0, 0, this.getHeight() - 1, this.getWidth() - 1);
    }

    public void flushPixels() {
        this.pixelType = 0;
        this.intPixels = null;
        this.shortPixels = null;
        this.bytePixels = null;
    }

    private void indexPlanesToIndexPixels(int top, int left, int bottom, int right) {
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int pixel = 0;
        byte b7 = 0;
        byte b6 = 0;
        byte b5 = 0;
        byte b4 = 0;
        byte b3 = 0;
        byte b2 = 0;
        byte b1 = 0;
        byte b0 = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        switch (depth) {
            case 1: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        this.bytePixels[iPixel++] = (byte)((this.bitmap[iScanline + (x >>> 3)] << (x & 7) & 0x80) >>> 7);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 2: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels[iPixel++] = (byte)((this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 3: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels[iPixel++] = (byte)((this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 4: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels[iPixel++] = (byte)((this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2 | (this.bitmap[iBitmap + bitplaneStride3] & bitMask) << 3) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 5: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                        }
                        this.bytePixels[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 6: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                        }
                        this.bytePixels[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 7: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                        }
                        this.bytePixels[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                            b7 = this.bitmap[iBitmap + bitplaneStride7];
                        }
                        this.bytePixels[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6 | (b7 & bitMask) << 7) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                for (int iScanline = top * scanlineStride + scanlineStride; iScanline <= bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        pixel = 0;
                        for (int iDepth = 0; iDepth < depth; ++iDepth) {
                            pixel = pixel << 1 | this.bitmap[iBitmap -= bitplaneStride] & bitMask;
                        }
                        this.bytePixels[iPixel++] = (byte)(pixel >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
            }
        }
    }

    private void indexPixelsToIndexPlanes(int top, int left, int bottom, int right) {
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        boolean pixel = false;
        int b7 = 0;
        int b6 = 0;
        int b5 = 0;
        int b4 = 0;
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        switch (depth) {
            case 1: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 2: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 3: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 4: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 5: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 6: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 7: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        byte px = this.bytePixels[iPixel++];
                        b7 = b7 << 1 | px >>> 7 & 1;
                        b6 = b6 << 1 | px >>> 6 & 1;
                        b5 = b5 << 1 | px >>> 5 & 1;
                        b4 = b4 << 1 | px >>> 4 & 1;
                        b3 = b3 << 1 | px >>> 3 & 1;
                        b2 = b2 << 1 | px >>> 2 & 1;
                        b1 = b1 << 1 | px >>> 1 & 1;
                        b0 = b0 << 1 | px >>> 0 & 1;
                        if (iBit != 7) continue;
                        this.bitmap[iBitmap] = (byte)b0;
                        this.bitmap[iBitmap + bitplaneStride] = (byte)b1;
                        this.bitmap[iBitmap + bitplaneStride2] = (byte)b2;
                        this.bitmap[iBitmap + bitplaneStride3] = (byte)b3;
                        this.bitmap[iBitmap + bitplaneStride4] = (byte)b4;
                        this.bitmap[iBitmap + bitplaneStride5] = (byte)b5;
                        this.bitmap[iBitmap + bitplaneStride6] = (byte)b6;
                        this.bitmap[iBitmap + bitplaneStride7] = (byte)b7;
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException(depth + " not yet implemented");
            }
        }
    }

    private void indexPlanesToDirectPixels(int top, int left, int bottom, int right) {
        IndexColorModel colorModel = (IndexColorModel)this.planarColorModel;
        int[] clut = new int[colorModel.getMapSize()];
        IndexColorModel icm = (IndexColorModel)this.planarColorModel;
        byte[] reds = new byte[clut.length];
        byte[] greens = new byte[clut.length];
        byte[] blues = new byte[clut.length];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < clut.length; ++i) {
            clut[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
        }
        if (clut.length < 1 << this.getDepth()) {
            throw new IndexOutOfBoundsException("Clut must not be smaller than depth");
        }
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        byte b7 = 0;
        byte b6 = 0;
        byte b5 = 0;
        byte b4 = 0;
        byte b3 = 0;
        byte b2 = 0;
        byte b1 = 0;
        byte b0 = 0;
        switch (depth) {
            case 1: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        this.intPixels[iPixel++] = clut[(this.bitmap[iScanline + (x >>> 3)] << (x & 7) & 0x80) >>> 7];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 2: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 3: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 4: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2 | (this.bitmap[iBitmap + bitplaneStride3] & bitMask) << 3) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 5: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                        }
                        this.intPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 6: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                        }
                        this.intPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 7: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                        }
                        this.intPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                            b7 = this.bitmap[iBitmap + bitplaneStride7];
                        }
                        this.intPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6 | (b7 & bitMask) << 7) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                for (int iScanline = top * scanlineStride + scanlineStride; iScanline <= bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        pixel = 0;
                        for (int iDepth = 0; iDepth < depth; ++iDepth) {
                            pixel = pixel << 1 | this.bitmap[iBitmap -= bitplaneStride] & bitMask;
                        }
                        this.intPixels[iPixel++] = clut[pixel >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
            }
        }
    }

    private void indexPlanesTo555(int top, int left, int bottom, int right) {
        IndexColorModel colorModel = (IndexColorModel)this.planarColorModel;
        short[] clut = new short[colorModel.getMapSize()];
        IndexColorModel icm = (IndexColorModel)this.planarColorModel;
        byte[] reds = new byte[clut.length];
        byte[] greens = new byte[clut.length];
        byte[] blues = new byte[clut.length];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < clut.length; ++i) {
            clut[i] = (short)((reds[i] & 0xF8) << 7 | (greens[i] & 0xF8) << 2 | (blues[i] & 0xF8) >> 3);
        }
        if (clut.length < 1 << this.getDepth()) {
            throw new IndexOutOfBoundsException("Clut must not be smaller than depth");
        }
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        byte b7 = 0;
        byte b6 = 0;
        byte b5 = 0;
        byte b4 = 0;
        byte b3 = 0;
        byte b2 = 0;
        byte b1 = 0;
        byte b0 = 0;
        switch (depth) {
            case 1: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        this.shortPixels[iPixel++] = clut[(this.bitmap[iScanline + (x >>> 3)] << (x & 7) & 0x80) >>> 7];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 2: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.shortPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 3: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.shortPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 4: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.shortPixels[iPixel++] = clut[(this.bitmap[iBitmap] & bitMask | (this.bitmap[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap[iBitmap + bitplaneStride2] & bitMask) << 2 | (this.bitmap[iBitmap + bitplaneStride3] & bitMask) << 3) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 5: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                        }
                        this.shortPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 6: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                        }
                        this.shortPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 7: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                        }
                        this.shortPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap[iBitmap];
                            b1 = this.bitmap[iBitmap + bitplaneStride];
                            b2 = this.bitmap[iBitmap + bitplaneStride2];
                            b3 = this.bitmap[iBitmap + bitplaneStride3];
                            b4 = this.bitmap[iBitmap + bitplaneStride4];
                            b5 = this.bitmap[iBitmap + bitplaneStride5];
                            b6 = this.bitmap[iBitmap + bitplaneStride6];
                            b7 = this.bitmap[iBitmap + bitplaneStride7];
                        }
                        this.shortPixels[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6 | (b7 & bitMask) << 7) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                for (int iScanline = top * scanlineStride + scanlineStride; iScanline <= bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        pixel = 0;
                        for (int iDepth = 0; iDepth < depth; ++iDepth) {
                            pixel = pixel << 1 | this.bitmap[iBitmap -= bitplaneStride] & bitMask;
                        }
                        this.shortPixels[iPixel++] = clut[pixel >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
            }
        }
    }

    private void directPlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        boolean pixel = false;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        int bitplaneStride8 = bitplaneStride * 8;
        int bitplaneStride9 = bitplaneStride * 9;
        int bitplaneStride10 = bitplaneStride * 10;
        int bitplaneStride11 = bitplaneStride * 11;
        int bitplaneStride12 = bitplaneStride * 12;
        int bitplaneStride13 = bitplaneStride * 13;
        int bitplaneStride14 = bitplaneStride * 14;
        int bitplaneStride15 = bitplaneStride * 15;
        int bitplaneStride16 = bitplaneStride * 16;
        int bitplaneStride17 = bitplaneStride * 17;
        int bitplaneStride18 = bitplaneStride * 18;
        int bitplaneStride19 = bitplaneStride * 19;
        int bitplaneStride20 = bitplaneStride * 20;
        int bitplaneStride21 = bitplaneStride * 21;
        int bitplaneStride22 = bitplaneStride * 22;
        int bitplaneStride23 = bitplaneStride * 23;
        int iBitmap = top * scanlineStride + left / 8;
        byte b0 = this.bitmap[iBitmap];
        byte b1 = this.bitmap[iBitmap + bitplaneStride];
        byte b2 = this.bitmap[iBitmap + bitplaneStride2];
        byte b3 = this.bitmap[iBitmap + bitplaneStride4];
        byte b4 = this.bitmap[iBitmap + bitplaneStride4];
        byte b5 = this.bitmap[iBitmap + bitplaneStride5];
        byte b6 = this.bitmap[iBitmap + bitplaneStride6];
        byte b7 = this.bitmap[iBitmap + bitplaneStride7];
        byte b8 = this.bitmap[iBitmap + bitplaneStride8];
        byte b9 = this.bitmap[iBitmap + bitplaneStride9];
        byte b10 = this.bitmap[iBitmap + bitplaneStride10];
        byte b11 = this.bitmap[iBitmap + bitplaneStride11];
        byte b12 = this.bitmap[iBitmap + bitplaneStride12];
        byte b13 = this.bitmap[iBitmap + bitplaneStride13];
        byte b14 = this.bitmap[iBitmap + bitplaneStride14];
        byte b15 = this.bitmap[iBitmap + bitplaneStride15];
        byte b16 = this.bitmap[iBitmap + bitplaneStride16];
        byte b17 = this.bitmap[iBitmap + bitplaneStride17];
        byte b18 = this.bitmap[iBitmap + bitplaneStride18];
        byte b19 = this.bitmap[iBitmap + bitplaneStride19];
        byte b20 = this.bitmap[iBitmap + bitplaneStride20];
        byte b21 = this.bitmap[iBitmap + bitplaneStride21];
        byte b22 = this.bitmap[iBitmap + bitplaneStride22];
        byte b23 = this.bitmap[iBitmap + bitplaneStride23];
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap[iBitmap];
                    b1 = this.bitmap[iBitmap + bitplaneStride];
                    b2 = this.bitmap[iBitmap + bitplaneStride2];
                    b3 = this.bitmap[iBitmap + bitplaneStride3];
                    b4 = this.bitmap[iBitmap + bitplaneStride4];
                    b5 = this.bitmap[iBitmap + bitplaneStride5];
                    b6 = this.bitmap[iBitmap + bitplaneStride6];
                    b7 = this.bitmap[iBitmap + bitplaneStride7];
                    b8 = this.bitmap[iBitmap + bitplaneStride8];
                    b9 = this.bitmap[iBitmap + bitplaneStride9];
                    b10 = this.bitmap[iBitmap + bitplaneStride10];
                    b11 = this.bitmap[iBitmap + bitplaneStride11];
                    b12 = this.bitmap[iBitmap + bitplaneStride12];
                    b13 = this.bitmap[iBitmap + bitplaneStride13];
                    b14 = this.bitmap[iBitmap + bitplaneStride14];
                    b15 = this.bitmap[iBitmap + bitplaneStride15];
                    b16 = this.bitmap[iBitmap + bitplaneStride16];
                    b17 = this.bitmap[iBitmap + bitplaneStride17];
                    b18 = this.bitmap[iBitmap + bitplaneStride18];
                    b19 = this.bitmap[iBitmap + bitplaneStride19];
                    b20 = this.bitmap[iBitmap + bitplaneStride20];
                    b21 = this.bitmap[iBitmap + bitplaneStride21];
                    b22 = this.bitmap[iBitmap + bitplaneStride22];
                    b23 = this.bitmap[iBitmap + bitplaneStride23];
                }
                this.intPixels[iPixel++] = ((b0 & bitMask) << 16 | (b1 & bitMask) << 17 | (b2 & bitMask) << 18 | (b3 & bitMask) << 19 | (b4 & bitMask) << 20 | (b5 & bitMask) << 21 | (b6 & bitMask) << 22 | (b7 & bitMask) << 23 | (b8 & bitMask) << 8 | (b9 & bitMask) << 9 | (b10 & bitMask) << 10 | (b11 & bitMask) << 11 | (b12 & bitMask) << 12 | (b13 & bitMask) << 13 | (b14 & bitMask) << 14 | (b15 & bitMask) << 15 | b16 & bitMask | (b17 & bitMask) << 1 | (b18 & bitMask) << 2 | (b19 & bitMask) << 3 | (b20 & bitMask) << 4 | (b21 & bitMask) << 5 | (b22 & bitMask) << 6 | (b23 & bitMask) << 7) >>> 7 - iBit;
            }
            iPixel += pixelLineStride;
        }
    }

    private void ham6PlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        ++right;
        int[] HAMColors = new int[((HAMColorModel)this.planarColorModel).getMapSize()];
        ((HAMColorModel)this.planarColorModel).getRGBs(HAMColors);
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int iLastPixel = top * width + left - 1;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int b5 = 0;
        int b4 = 0;
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            int lastPixel;
            if (left == 0) {
                lastPixel = -16777216;
            } else {
                lastPixel = this.intPixels[iLastPixel];
                iLastPixel += width;
            }
            block6: for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                int iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap[iBitmap];
                    b1 = this.bitmap[iBitmap + bitplaneStride];
                    b2 = this.bitmap[iBitmap + bitplaneStride2];
                    b3 = this.bitmap[iBitmap + bitplaneStride3];
                    b4 = this.bitmap[iBitmap + bitplaneStride4];
                    b5 = this.bitmap[iBitmap + bitplaneStride5];
                }
                pixel = (b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3) >>> 7 - iBit;
                switch ((b4 & bitMask | (b5 & bitMask) << 1) >>> 7 - iBit) {
                    case 0: {
                        this.intPixels[iPixel++] = lastPixel = HAMColors[pixel];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFFFFFF00 | pixel | pixel << 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFF00FFFF | pixel << 16 | pixel << 20;
                        continue block6;
                    }
                    default: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFFFF00FF | pixel << 8 | pixel << 12;
                    }
                }
            }
            iPixel += pixelLineStride;
        }
    }

    private void ham8PlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        ++right;
        int[] HAMColors = new int[((HAMColorModel)this.planarColorModel).getMapSize()];
        ((HAMColorModel)this.planarColorModel).getRGBs(HAMColors);
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int iLastPixel = top * width + left - 1;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        int iBitmap = top * scanlineStride + left / 8;
        int b7 = 0;
        int b6 = 0;
        int b5 = 0;
        int b4 = 0;
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            int lastPixel;
            if (left == 0) {
                lastPixel = -16777216;
            } else {
                lastPixel = this.intPixels[iLastPixel];
                iLastPixel += width;
            }
            block6: for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap[iBitmap];
                    b1 = this.bitmap[iBitmap + bitplaneStride];
                    b2 = this.bitmap[iBitmap + bitplaneStride2];
                    b3 = this.bitmap[iBitmap + bitplaneStride3];
                    b4 = this.bitmap[iBitmap + bitplaneStride4];
                    b5 = this.bitmap[iBitmap + bitplaneStride5];
                    b6 = this.bitmap[iBitmap + bitplaneStride6];
                    b7 = this.bitmap[iBitmap + bitplaneStride7];
                }
                pixel = (b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit;
                switch ((b6 & bitMask | (b7 & bitMask) << 1) >>> 7 - iBit) {
                    case 0: {
                        this.intPixels[iPixel++] = lastPixel = HAMColors[pixel];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFFFFFF00 | pixel << 2 | pixel >>> 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFF00FFFF | pixel << 18 | (pixel & 3) << 16;
                        continue block6;
                    }
                    default: {
                        this.intPixels[iPixel++] = lastPixel = lastPixel & 0xFFFF00FF | pixel << 10 | (pixel & 3) << 8;
                    }
                }
            }
            iPixel += pixelLineStride;
        }
    }

    public void setIntPixels(int[] buf) {
        if (buf.length != this.getWidth() * this.getHeight()) {
            throw new IllegalArgumentException("Illegal size");
        }
        this.intPixels = buf;
    }

    public void setBytePixels(byte[] buf) {
        if (buf.length != this.getWidth() * this.getHeight()) {
            throw new IllegalArgumentException("Illegal size");
        }
        this.bytePixels = buf;
    }

    public void setShortPixels(short[] buf) {
        if (buf.length != this.getWidth() * this.getHeight()) {
            throw new IllegalArgumentException("Illegal size");
        }
        this.shortPixels = buf;
    }

    private void directPlanesTo555(int top, int left, int bottom, int right) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

