/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ClearType {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame();
                f.setDefaultCloseOperation(3);
                f.setSize(430, 180);
                f.setTitle("ClearType");
                JPanel p = new JPanel(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void update(Graphics g) {
                        this.paint(g);
                    }

                    @Override
                    public void paint(Graphics g) {
                        Font f = new Font("Times New Roman", 0, 18);
                        Graphics2D grph = (Graphics2D)g;
                        grph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                        g.setFont(f);
                        g.setColor(Color.white);
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        g.setColor(Color.black);
                        g.drawString("Sample Text String", 5, this.getFontMetrics(f).getHeight());
                        this.drawClearType(g, "Sample Text String", 5, this.getFontMetrics(f).getHeight() * 3);
                    }

                    public void drawClearType(Graphics g, String s, int x, int y) {
                        int i;
                        Font f = g.getFont();
                        FontMetrics fm = this.getFontMetrics(f);
                        int width = fm.stringWidth(s) * 3;
                        int height = fm.getHeight();
                        BufferedImage img = (BufferedImage)this.createImage(width, height);
                        Graphics2D grph = img.createGraphics();
                        grph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                        grph.setColor(Color.white);
                        grph.fillRect(0, 0, width, height);
                        grph.setColor(Color.black);
                        grph.setFont(f.deriveFont(AffineTransform.getScaleInstance(3.0, 1.0)));
                        grph.drawString(s, 0, height - fm.getMaxDescent());
                        int[] pixelsA = ClearType.getPixelArray(img);
                        int[] pixels = new int[pixelsA.length];
                        int[] newpixels = new int[width / 3 * height];
                        for (i = 0; i < width * height; ++i) {
                            newpixels[i / 3] = -16777216;
                            if (i != width * height - 1) {
                                pixels[i + 1] = ClearType.fuzz(pixels[i + 1], pixelsA[i]);
                            }
                            pixels[i] = ClearType.fuzz(pixels[i], pixelsA[i]);
                            if (i == 0) continue;
                            pixels[i - 1] = ClearType.fuzz(pixels[i - 1], pixelsA[i]);
                        }
                        block6: for (i = 0; i < width * height; ++i) {
                            switch (i % 3) {
                                case 0: {
                                    int n = i / 3;
                                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF0000;
                                    continue block6;
                                }
                                case 1: {
                                    int n = i / 3;
                                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF00;
                                    continue block6;
                                }
                                case 2: {
                                    int n = i / 3;
                                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF;
                                }
                            }
                        }
                        grph.dispose();
                        g.drawImage(ClearType.imageFromPixels(newpixels, width / 3, height), x, y - height, width / 3, height, this);
                        g.drawImage(img, x, y, width, height, this);
                    }
                };
                f.setContentPane(p);
                f.setVisible(true);
            }
        });
    }

    private static int fuzz(int a, int b) {
        int red = (b >> 16 & 0xFF) / 3 + (a >> 16 & 0xFF);
        int green = (b >> 8 & 0xFF) / 3 + (a >> 8 & 0xFF);
        int blue = (b & 0xFF) / 3 + (a & 0xFF);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static int[] getPixelArray(Image img) {
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int[] pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return pixels;
    }

    public static void drawClearType(Graphics g, Image img, int x, int y, int superY, ImageObserver observer) {
        int i;
        int width = img.getWidth(null);
        int height = img.getHeight(null);
        int[] pixelsA = ClearType.getPixelArray(img);
        int[] pixels = new int[pixelsA.length];
        int[] newpixels = new int[width / 3 * height];
        for (i = 0; i < width * height; ++i) {
            newpixels[i / 3] = -16777216;
            if (i != width * height - 1) {
                pixels[i + 1] = ClearType.fuzz(pixels[i + 1], pixelsA[i]);
            }
            pixels[i] = ClearType.fuzz(pixels[i], pixelsA[i]);
            if (i == 0) continue;
            pixels[i - 1] = ClearType.fuzz(pixels[i - 1], pixelsA[i]);
        }
        block6: for (i = 0; i < width * height; ++i) {
            switch (i % 3) {
                case 0: {
                    int n = i / 3;
                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF0000;
                    continue block6;
                }
                case 1: {
                    int n = i / 3;
                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF00;
                    continue block6;
                }
                case 2: {
                    int n = i / 3;
                    newpixels[n] = newpixels[n] | pixels[i] & 0xFF;
                }
            }
        }
        g.drawImage(ClearType.imageFromPixels(newpixels, width / 3, height), x, y, width / 3, height / superY, observer);
    }

    private static Image imageFromPixels(int[] pixels, int width, int height) {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(width, height, pixels, 0, width));
    }
}

