/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;

public class ColorModels {
    private ColorModels() {
    }

    public static String toString(ColorModel cm) {
        StringBuffer buf = new StringBuffer();
        if (cm instanceof DirectColorModel) {
            DirectColorModel dcm = (DirectColorModel)cm;
            buf.append("Direct Color Model ");
            int[] masks = dcm.getMasks();
            int totalBits = 0;
            Object[] entries = new MaskEntry[masks.length];
            for (int i = 0; i < masks.length; ++i) {
                switch (i) {
                    case 0: {
                        entries[i] = new MaskEntry(masks[i], "R");
                        break;
                    }
                    case 1: {
                        entries[i] = new MaskEntry(masks[i], "G");
                        break;
                    }
                    case 2: {
                        entries[i] = new MaskEntry(masks[i], "B");
                        break;
                    }
                    case 3: {
                        entries[i] = new MaskEntry(masks[i], "A");
                    }
                }
                totalBits += entries[i].getBits();
            }
            buf.append(totalBits);
            buf.append(" Bit ");
            Arrays.sort(entries);
            for (Object entrie : entries) {
                buf.append(entrie);
            }
        } else if (cm instanceof IndexColorModel) {
            buf.append("Index Color Model ");
            IndexColorModel icm = (IndexColorModel)cm;
            int mapSize = icm.getMapSize();
            buf.append(icm.getMapSize());
            buf.append(" Colors");
        } else {
            buf.append(cm.toString());
        }
        switch (cm.getTransparency()) {
            case 1: {
                break;
            }
            case 2: {
                buf.append(" with Alpha Bitmask");
                break;
            }
            case 3: {
                buf.append(" with Alpha Translucency");
            }
        }
        return buf.toString();
    }

    public static void RGBtoYCC(float[] rgb, float[] ycc) {
        float R = Math.max(0.0f, Math.min(1.0f, rgb[0]));
        float G = Math.max(0.0f, Math.min(1.0f, rgb[1]));
        float B = Math.max(0.0f, Math.min(1.0f, rgb[2]));
        float Y = 0.3f * R + 0.6f * G + 0.1f * B;
        float V = R - Y;
        float U = B - Y;
        float Cb = U / 2.0f;
        float Cr = V / 1.6f;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    public static void YCCtoRGB(float[] ycc, float[] rgb) {
        float Y = Math.max(0.0f, Math.min(1.0f, ycc[0]));
        float Cb = Math.max(-0.5f, Math.min(0.5f, ycc[1]));
        float Cr = Math.max(-0.5f, Math.min(0.5f, ycc[2]));
        float U = Cb * 2.0f;
        float V = Cr * 1.6f;
        float R = V + Y;
        float B = U + Y;
        float G = (Y - 0.3f * R - 0.1f * B) / 0.6f;
        rgb[0] = Math.max(0.0f, Math.min(1.0f, R));
        rgb[1] = Math.max(0.0f, Math.min(1.0f, G));
        rgb[2] = Math.max(0.0f, Math.min(1.0f, B));
    }

    public static void RGBtoYCC(int[] rgb, int[] ycc) {
        int R = rgb[0];
        int G = rgb[1];
        int B = rgb[2];
        int Y = 77 * R + 153 * G + 26 * B;
        int V = R * 256 - Y;
        int U = B * 256 - Y;
        int Cb = U / 2 + 32768;
        int Cr = V * 5 / 8 + 32768;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    public static void RGBtoYCC(int rgb, int[] ycc) {
        int R = (rgb & 0xFF0000) >>> 16;
        int G = (rgb & 0xFF00) >>> 8;
        int B = rgb & 0xFF;
        int Y = 77 * R + 153 * G + 26 * B;
        int V = R * 256 - Y;
        int U = B * 256 - Y;
        int Cb = U / 2 + 32768;
        int Cr = V * 5 / 8 + 32768;
        ycc[0] = Y;
        ycc[1] = Cb;
        ycc[2] = Cr;
    }

    public static void RGBtoYUV(float[] rgb, float[] yuv) {
        float R = Math.max(0.0f, Math.min(1.0f, rgb[0]));
        float G = Math.max(0.0f, Math.min(1.0f, rgb[1]));
        float B = Math.max(0.0f, Math.min(1.0f, rgb[2]));
        float Y = 0.3f * R + 0.6f * G + 0.1f * B;
        yuv[0] = 0.299f * R + 0.587f * G + 0.114f * B;
        yuv[1] = -0.14713f * R - 0.28886f * G + 0.436f * B;
        yuv[2] = 0.615f * R - 0.51499f * G - 0.10001f * B;
    }

    public static void YUVtoRGB(float[] yuv, float[] rgb) {
        float Y = Math.max(0.0f, Math.min(1.0f, yuv[0]));
        float U = Math.max(-0.5f, Math.min(0.5f, yuv[1]));
        float V = Math.max(-0.5f, Math.min(0.5f, yuv[2]));
        float R = 1.0f * Y + 0.0f * U + 1.13983f * V;
        float G = 1.0f * Y - 0.39465f * U - 0.5806f * V;
        float B = 1.0f * Y + 2.03211f * U + 0.0f * V;
        rgb[0] = Math.min(1.0f, Math.max(0.0f, R));
        rgb[1] = Math.min(1.0f, Math.max(0.0f, G));
        rgb[2] = Math.min(1.0f, Math.max(0.0f, B));
    }

    public static void YCCtoRGB(int[] ycc, int[] rgb) {
        int Y = ycc[0];
        int Cb = ycc[1];
        int Cr = ycc[2];
        int U = (Cb - 32768) * 2;
        int V = (Cr - 32768) * 8 / 5;
        int R = Math.min(255, Math.max(0, (V + Y) / 256));
        int B = Math.min(255, Math.max(0, (U + Y) / 256));
        int G = Math.min(255, Math.max(0, (Y - 77 * R - 26 * B) / 153));
        rgb[0] = R;
        rgb[1] = G;
        rgb[2] = B;
    }

    public static int YCCtoRGB(int[] ycc) {
        int Y = ycc[0];
        int Cb = ycc[1];
        int Cr = ycc[2];
        int U = (Cb - 32768) * 2;
        int V = (Cr - 32768) * 8 / 5;
        int R = Math.min(255, Math.max(0, (V + Y) / 256));
        int B = Math.min(255, Math.max(0, (U + Y) / 256));
        int G = Math.min(255, Math.max(0, (Y - 77 * R - 26 * B) / 153));
        return R << 16 | G << 8 | B;
    }

    public static void RGBtoYIQ(float[] rgb, float[] yiq) {
        float R = Math.max(0.0f, Math.min(1.0f, rgb[0]));
        float G = Math.max(0.0f, Math.min(1.0f, rgb[1]));
        float B = Math.max(0.0f, Math.min(1.0f, rgb[2]));
        float Y = 0.299f * R + 0.587f * G + 0.114f * B;
        float I = 0.595716f * R + -0.274453f * G + -0.321263f * B;
        float Q = 0.211456f * R + -0.522591f * G + 0.311135f * B;
        yiq[0] = Y;
        yiq[1] = I;
        yiq[2] = Q;
    }

    public static void YIQtoRGB(float[] yiq, float[] rgb) {
        float Y = Math.max(0.0f, Math.min(1.0f, yiq[0]));
        float I = Math.max(-0.5957f, Math.min(0.5957f, yiq[1]));
        float Q = Math.max(-0.5226f, Math.min(0.5226f, yiq[2]));
        float R = Y + 0.9563f * I + 0.621f * Q;
        float G = Y + -0.2721f * I + -0.6474f * Q;
        float B = Y + -1.107f * I + 1.7046f * Q;
        rgb[0] = Math.max(0.0f, Math.min(1.0f, R));
        rgb[1] = Math.max(0.0f, Math.min(1.0f, G));
        rgb[2] = Math.max(0.0f, Math.min(1.0f, B));
    }

    private static class MaskEntry
    implements Comparable<MaskEntry> {
        private static final long serialVersionUID = 1L;
        private int mask;
        private int bits;
        private String name;

        public MaskEntry(int mask, String name) {
            this.mask = mask;
            this.name = name;
            for (int i = 0; i < 32; ++i) {
                if ((mask >>> i & 1) != 1) continue;
                ++this.bits;
            }
        }

        public int getBits() {
            return this.bits;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(MaskEntry that) {
            return that.mask - this.mask;
        }
    }
}

