/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.image;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.net.URL;
import java.util.Hashtable;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javax.swing.ImageIcon;

public class Images {
    private static final DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private static final DirectColorModel ARGB = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);

    private Images() {
    }

    public static Image createImage(Class<?> baseClass, String location) {
        URL resource = baseClass.getResource(location);
        if (resource == null) {
            System.err.println("Warning: Images.createImage no resource found for " + baseClass + " " + location);
            return null;
        }
        return Images.createImage(resource);
    }

    public static Image createImage(URL resource) {
        Image image = Toolkit.getDefaultToolkit().createImage(resource);
        return image;
    }

    public static BufferedImage toRGBImage(Image img) {
        BufferedImage src = Images.toBufferedImage(img);
        if (src.getColorModel().getColorSpace().getType() == RGB.getColorSpace().getType()) {
            return src;
        }
        DirectColorModel dst = Images.hasAlpha(src) ? ARGB : RGB;
        return Images.toImageWithColorModel_usingColorConvertOp(img, dst);
    }

    public static BufferedImage toImageWithColorModel_usingColorConvertOp(Image img, ColorModel cm) {
        BufferedImage src = Images.toBufferedImage(img);
        if (src.getColorModel().equals(cm)) {
            return src;
        }
        int w = src.getWidth();
        int h = src.getHeight();
        ColorConvertOp op = new ColorConvertOp(src.getColorModel().getColorSpace(), cm.getColorSpace(), null);
        BufferedImage dest = new BufferedImage(cm, cm.createCompatibleWritableRaster(w, h), cm.isAlphaPremultiplied(), new Hashtable());
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage toImageWithColorModel_usingDrawImage(Image img, ColorModel cm) {
        BufferedImage src = Images.toBufferedImage(img);
        BufferedImage dest = new BufferedImage(cm, cm.createCompatibleWritableRaster(src.getWidth(), src.getHeight()), cm.isAlphaPremultiplied(), new Hashtable());
        Graphics graphics = dest.getGraphics();
        try {
            graphics.drawImage(src, 0, 0, null);
        }
        finally {
            graphics.dispose();
        }
        return dest;
    }

    public static BufferedImage toBufferedImage(RenderedImage rImg) {
        BufferedImage image;
        if (rImg instanceof BufferedImage) {
            image = (BufferedImage)rImg;
        } else {
            Raster r = rImg.getData();
            WritableRaster wr = Raster.createWritableRaster(r.getSampleModel(), null);
            rImg.copyData(wr);
            image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        }
        return image;
    }

    public static BufferedImage cloneImage(RenderedImage rImg) {
        Raster r = rImg.getData();
        WritableRaster wr = Raster.createWritableRaster(r.getSampleModel(), null);
        rImg.copyData(wr);
        BufferedImage image = new BufferedImage(rImg.getColorModel(), wr, rImg.getColorModel().isAlphaPremultiplied(), null);
        return image;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        if (System.getProperty("java.version").startsWith("1.4.1_")) {
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        } else {
            boolean hasAlpha;
            try {
                hasAlpha = Images.hasAlpha(image);
            }
            catch (IllegalAccessError e) {
                hasAlpha = true;
            }
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            try {
                int transparency = 1;
                if (hasAlpha) {
                    transparency = 3;
                }
                GraphicsDevice gs = ge.getDefaultScreenDevice();
                GraphicsConfiguration gc = gs.getDefaultConfiguration();
                bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
            }
            catch (Exception transparency) {
                // empty catch block
            }
            if (bimage == null) {
                int type = 1;
                if (hasAlpha) {
                    type = 2;
                }
                bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
            }
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static WritableImage toFXImage(BufferedImage bimg, WritableImage wimg) {
        int[] p;
        int w = bimg.getWidth();
        int h = bimg.getHeight();
        if (wimg == null || wimg.getWidth() != (double)w || wimg.getHeight() != (double)h) {
            wimg = new WritableImage(bimg.getWidth(), bimg.getHeight());
        }
        if (bimg.getSampleModel() instanceof SinglePixelPackedSampleModel && bimg.getRaster().getDataBuffer() instanceof DataBufferInt && (p = ((DataBufferInt)bimg.getRaster().getDataBuffer()).getData()).length == w * h) {
            switch (bimg.getType()) {
                case 1: {
                    int[] o = new int[p.length];
                    for (int i = 0; i < o.length; ++i) {
                        o[i] = p[i] | 0xFF000000;
                    }
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), o, 0, bimg.getWidth());
                    return wimg;
                }
                case 2: {
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), p, 0, bimg.getWidth());
                    return wimg;
                }
                case 3: {
                    wimg.getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbPreInstance(), p, 0, bimg.getWidth());
                    return wimg;
                }
            }
        }
        return SwingFXUtils.toFXImage((BufferedImage)bimg, (WritableImage)wimg);
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static BufferedImage[] split(Image image, int count, boolean isHorizontal) {
        BufferedImage src = Images.toBufferedImage(image);
        if (count == 1) {
            return new BufferedImage[]{src};
        }
        BufferedImage[] parts = new BufferedImage[count];
        for (int i = 0; i < count; ++i) {
            parts[i] = isHorizontal ? src.getSubimage(src.getWidth() / count * i, 0, src.getWidth() / count, src.getHeight()) : src.getSubimage(0, src.getHeight() / count * i, src.getWidth(), src.getHeight() / count);
        }
        return parts;
    }

    public static BufferedImage toIntImage(BufferedImage img) {
        if (img.getRaster().getDataBuffer() instanceof DataBufferInt) {
            return img;
        }
        BufferedImage intImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
        Graphics2D g = intImg.createGraphics();
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return intImg;
    }

    public static int[] toPixels(BufferedImage img) {
        return ((DataBufferInt)Images.toIntImage(img).getRaster().getDataBuffer()).getData();
    }

    public static BufferedImage toImage(int[] pixels, int width, int height) {
        return new BufferedImage(ColorModel.getRGBdefault(), Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, new int[]{0xFF00000, 65280, 255}), new DataBufferInt(pixels, width * height), new Point(0, 0)), false, null);
    }
}

