/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.io;

import java.io.ByteArrayInputStream;

public class AppendableByteArrayInputStream
extends ByteArrayInputStream {
    public AppendableByteArrayInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public AppendableByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    @Override
    public synchronized int read() {
        int b = super.read();
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int count = super.read(b, off, len);
        return count;
    }

    public void appendBuffer(byte[] buf, int offset, int length, boolean discard) {
        if (discard) {
            if (this.buf.length >= this.count - this.pos + length) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
                System.arraycopy(buf, offset, this.buf, this.count - this.pos, length);
                this.count = this.count - this.pos + length;
                this.pos = 0;
                this.mark = 0;
            } else {
                byte[] newBuf = new byte[(this.count - this.pos + length + 31) / 32 * 32];
                System.arraycopy(this.buf, this.pos, newBuf, 0, this.count - this.pos);
                System.arraycopy(buf, offset, newBuf, this.count - this.pos, length);
                this.buf = newBuf;
                this.count = this.count - this.pos + length;
                this.pos = 0;
                this.mark = 0;
            }
        } else if (this.buf.length >= this.count + length) {
            System.arraycopy(buf, offset, this.buf, this.count, length);
            this.count += length;
        } else {
            byte[] newBuf = new byte[(this.buf.length + length + 31) / 32 * 32];
            System.arraycopy(this.buf, 0, newBuf, 0, this.count);
            System.arraycopy(buf, offset, newBuf, this.count, length);
            this.buf = newBuf;
            this.count += length;
        }
    }

    public void setBuffer(byte[] buf, int offset, int length) {
        if (this.buf.length >= length) {
            System.arraycopy(buf, offset, this.buf, 0, length);
            this.count = length;
            this.pos = 0;
            this.mark = 0;
        } else {
            this.buf = null;
            this.buf = new byte[length + 31 & 0xFFFFFFE0];
            System.arraycopy(buf, offset, this.buf, 0, length);
            this.count = length;
            this.pos = 0;
            this.mark = 0;
        }
    }

    public static void main(String[] args) {
        int i;
        int j;
        byte[] b = new byte[5];
        int count = 0;
        for (int i2 = 0; i2 < b.length; ++i2) {
            b[i2] = (byte)count++;
        }
        AppendableByteArrayInputStream in = new AppendableByteArrayInputStream(b);
        for (j = 0; j < 3; ++j) {
            System.out.println(in.read());
        }
        b = new byte[4];
        for (i = 0; i < b.length; ++i) {
            b[i] = (byte)count++;
        }
        in.appendBuffer(b, 0, b.length, true);
        for (j = 0; j < 3; ++j) {
            System.out.println(in.read());
        }
        b = new byte[6];
        for (i = 0; i < b.length; ++i) {
            b[i] = (byte)count++;
        }
        in.appendBuffer(b, 0, b.length, true);
        int d = in.read();
        while (d >= 0) {
            System.out.println(d);
            d = in.read();
        }
    }
}

