/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.io.ImageInputStreamImpl2;

public class FilterImageInputStream
extends ImageInputStreamImpl2 {
    protected ImageInputStream in;

    public FilterImageInputStream(ImageInputStream in) {
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        this.flushBits();
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        return this.in.read(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.flushBits();
        return this.in.skipBytes(n);
    }

    @Override
    public long skipBytes(long n) throws IOException {
        this.flushBits();
        return this.in.skipBytes(n);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.in.close();
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.in.getStreamPosition();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.flushBits();
        this.in.seek(pos);
    }

    @Override
    public long length() {
        try {
            return this.in.length();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        super.flushBefore(pos);
        this.in.flushBefore(pos);
    }

    @Override
    public boolean isCached() {
        return this.in.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.in.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.in.isCachedFile();
    }

    private void flushBits() {
        this.bitOffset = 0;
    }
}

