/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class SeekableByteArrayOutputStream
extends ByteArrayOutputStream {
    private int pos;

    public SeekableByteArrayOutputStream() {
        this(32);
    }

    public SeekableByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
    }

    public SeekableByteArrayOutputStream(byte[] buf) {
        this.buf = buf;
    }

    @Override
    public synchronized void write(int b) {
        int newcount = Math.max(this.pos + 1, this.count);
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.pos++] = (byte)b;
        this.count = newcount;
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = Math.max(this.pos + len, this.count);
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos += len;
        this.count = newcount;
    }

    @Override
    public synchronized void reset() {
        this.count = 0;
        this.pos = 0;
    }

    public void seek(long pos) throws IOException {
        this.pos = (int)pos;
    }

    public long getStreamPosition() throws IOException {
        return this.pos;
    }

    public void toOutputStream(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public byte[] getBuffer() {
        return this.buf;
    }
}

