/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.io;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.io.ImageInputStreamImpl2;

public class SubImageInputStream
extends ImageInputStreamImpl2 {
    private ImageInputStream in;
    private long offset;
    private long length;

    public SubImageInputStream(ImageInputStream in, long offset, long length) throws IOException {
        this.in = in;
        this.offset = offset;
        this.length = length;
        if (in.length() != -1L && offset + length > in.length()) {
            throw new IllegalArgumentException("Offset too large. offset=" + offset + " length=" + length + " in.length=" + in.length());
        }
        in.seek(offset);
    }

    private long available() throws IOException {
        this.checkClosed();
        long pos = this.in.getStreamPosition();
        if (pos < this.offset) {
            this.in.seek(this.offset);
            pos = this.offset;
        }
        return this.offset + this.length - pos;
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0L) {
            return -1;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long av = this.available();
        if (av <= 0L) {
            return -1;
        }
        int result = this.in.read(b, off, (int)Math.min((long)len, av));
        return result;
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.in.getStreamPosition() - this.offset;
    }

    @Override
    public void seek(long pos) throws IOException {
        this.in.seek(pos + this.offset);
    }

    @Override
    public void flush() throws IOException {
        this.in.flush();
    }

    @Override
    public long getFlushedPosition() {
        return this.in.getFlushedPosition() - this.offset;
    }

    @Override
    public boolean isCached() {
        return this.in.isCached();
    }

    @Override
    public boolean isCachedMemory() {
        return this.in.isCachedMemory();
    }

    @Override
    public boolean isCachedFile() {
        return this.in.isCachedFile();
    }

    @Override
    public long length() {
        return this.length;
    }
}

