/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.jpeg;

import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import ru.sbtqa.monte.media.avi.AVIBMPDIB;

public class MJPGImageReader
extends ImageReader {
    private static DirectColorModel RGB = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private BufferedImage image;
    private boolean didReturnImage;

    public MJPGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(RGB, RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageReader r = MJPGImageReader.getBasicJPEGImageReader();
            Object in = this.getInput();
            if (in instanceof byte[]) {
                r.setInput(new MemoryCacheImageInputStream(AVIBMPDIB.prependDHTSeg((byte[])in)));
            } else if (in instanceof ImageInputStream) {
                r.setInput(AVIBMPDIB.prependDHTSeg((ImageInputStream)in));
            } else {
                r.setInput(AVIBMPDIB.prependDHTSeg((InputStream)in));
            }
            this.didReturnImage = false;
            this.image = r.read(0);
        }
    }

    private static ImageReader getBasicJPEGImageReader() {
        for (ImageReader r : (Iterable)((Object)ImageIO.getImageReadersByFormatName("jpeg"))) {
            if (!"com.sun.imageio.plugins.jpeg.JPEGImageReader".equals(r.getClass().getName())) continue;
            return r;
        }
        throw new InternalError("could not find native JPEG Reader");
    }

    @Override
    public void dispose() {
        try {
            if (this.image != null && !this.didReturnImage) {
                this.image.flush();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.image = null;
        }
    }
}

