/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.math;

public class ExtendedReal
extends Number {
    private static final long serialVersionUID = 1L;
    private boolean negSign;
    private int exponent;
    private long mantissa;
    public static final ExtendedReal MAX_VALUE = new ExtendedReal(new byte[]{127, -2, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final ExtendedReal MIN_VALUE = new ExtendedReal(new byte[]{-1, -2, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final ExtendedReal NaN = new ExtendedReal(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
    public static final ExtendedReal NEGATIVE_INFINITY = new ExtendedReal(new byte[]{-1, -1, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final ExtendedReal POSITIVE_INFINITY = new ExtendedReal(new byte[]{127, -1, 0, 0, 0, 0, 0, 0, 0, 0});

    public ExtendedReal(byte[] bits) {
        this.negSign = (bits[0] & 0x80) != 0;
        this.exponent = (bits[0] & 0x7F) << 8 | bits[1] & 0xFF;
        this.mantissa = ((long)bits[2] & 0xFFL) << 56 | ((long)bits[3] & 0xFFL) << 48 | ((long)bits[4] & 0xFFL) << 40 | ((long)bits[5] & 0xFFL) << 32 | ((long)bits[6] & 0xFFL) << 24 | ((long)bits[7] & 0xFFL) << 16 | ((long)bits[8] & 0xFFL) << 8 | ((long)bits[9] & 0xFFL) << 0;
    }

    public ExtendedReal(double d) {
        if (Double.isNaN(d)) {
            this.negSign = ExtendedReal.NaN.negSign;
            this.exponent = ExtendedReal.NaN.exponent;
            this.mantissa = ExtendedReal.NaN.mantissa;
        } else if (Double.isInfinite(d)) {
            if (d < 0.0) {
                this.negSign = ExtendedReal.NEGATIVE_INFINITY.negSign;
                this.exponent = ExtendedReal.NEGATIVE_INFINITY.exponent;
                this.mantissa = ExtendedReal.NEGATIVE_INFINITY.mantissa;
            } else {
                this.negSign = ExtendedReal.POSITIVE_INFINITY.negSign;
                this.exponent = ExtendedReal.POSITIVE_INFINITY.exponent;
                this.mantissa = ExtendedReal.POSITIVE_INFINITY.mantissa;
            }
        } else if (d != 0.0) {
            if (d == -0.0) {
                this.negSign = true;
            } else {
                long longBits = Double.doubleToLongBits(d);
                this.negSign = (longBits & Long.MIN_VALUE) != 0L;
                this.exponent = ((int)(longBits & 0x7FF0000000000000L) >>> 52) - 1023 + 16383;
                this.mantissa = Long.MIN_VALUE | (longBits & 0xFFFFFFFFFFFFFL) << 11;
            }
        }
    }

    public boolean isNaN() {
        return this.exponent == 524287 && (this.mantissa & Long.MAX_VALUE) != 0L;
    }

    public boolean isInfinite() {
        return this.exponent == 524287 && this.mantissa == Long.MAX_VALUE;
    }

    @Override
    public double doubleValue() {
        if (this.isNaN()) {
            return Double.NaN;
        }
        long longBits = 0L;
        int biasedExponent = this.exponent - 16383 + 1023;
        if (biasedExponent > 2047) {
            return this.negSign ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        if (biasedExponent < 0 || (this.mantissa & Long.MIN_VALUE) == 0L) {
            return 0.0;
        }
        if (this.negSign) {
            longBits = Long.MIN_VALUE;
        }
        longBits |= (long)biasedExponent << 52;
        return Double.longBitsToDouble(longBits |= (this.mantissa & Long.MAX_VALUE) >>> 11);
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.doubleValue());
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof ExtendedReal && this.equals((ExtendedReal)obj);
    }

    public boolean equals(ExtendedReal obj) {
        return this.negSign == obj.negSign && this.exponent == obj.exponent && this.mantissa == obj.mantissa;
    }

    public String toString() {
        return Double.toString(this.doubleValue());
    }
}

