/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.png;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import ru.sbtqa.monte.media.AbstractVideoCodec;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.io.ByteArrayImageInputStream;
import ru.sbtqa.monte.media.io.ByteArrayImageOutputStream;

public class PNGCodec
extends AbstractVideoCodec {
    public PNGCodec() {
        super(new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class})}, new Format[]{new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image"}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.DepthKey, 24, VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class})});
        this.name = "PNG Codec";
    }

    @Override
    public Format setOutputFormat(Format f) {
        String mimeType = f.get(VideoFormatKeys.MimeTypeKey, "video/quicktime");
        if (mimeType != null && !mimeType.equals("video/avi")) {
            super.setOutputFormat(f.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}));
        } else {
            super.setOutputFormat(f.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "video/avi", VideoFormatKeys.EncodingKey, "png ", VideoFormatKeys.DataClassKey, byte[].class, VideoFormatKeys.DepthKey, 24}));
        }
        if (this.outputFormat != null && this.inputFormat != null) {
            this.outputFormat = this.outputFormat.prepend(this.inputFormat.intersectKeys(VideoFormatKeys.WidthKey, VideoFormatKeys.HeightKey, VideoFormatKeys.DepthKey));
        }
        return this.outputFormat;
    }

    @Override
    public int process(Buffer in, Buffer out) {
        if ("image".equals(this.outputFormat.get(VideoFormatKeys.EncodingKey))) {
            return this.decode(in, out);
        }
        return this.encode(in, out);
    }

    public int encode(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        BufferedImage image = this.getBufferedImage(in);
        if (image == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        ByteArrayImageOutputStream tmp = out.data instanceof byte[] ? new ByteArrayImageOutputStream((byte[])out.data) : new ByteArrayImageOutputStream();
        try {
            ImageWriter iw = ImageIO.getImageWritersByMIMEType("image/png").next();
            ImageWriteParam iwParam = iw.getDefaultWriteParam();
            iw.setOutput(tmp);
            IIOImage img = new IIOImage(image, null, null);
            iw.write(null, img, iwParam);
            iw.dispose();
            out.setFlag(BufferFlag.KEYFRAME);
            out.header = null;
            out.data = tmp.getBuffer();
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }

    public int decode(Buffer in, Buffer out) {
        out.setMetaTo(in);
        out.format = this.outputFormat;
        if (in.isFlag(BufferFlag.DISCARD)) {
            return 0;
        }
        byte[] data = (byte[])in.data;
        if (data == null) {
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
        ByteArrayImageInputStream tmp = new ByteArrayImageInputStream(data);
        try {
            ImageReader ir = ImageIO.getImageReadersByMIMEType("image/png").next();
            ir.setInput(tmp);
            out.data = ir.read(0);
            ir.dispose();
            out.sampleCount = 1;
            out.offset = 0;
            out.length = (int)tmp.getStreamPosition();
            return 0;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            out.setFlag(BufferFlag.DISCARD);
            return 1;
        }
    }
}

