/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.quicktime;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.io.ImageInputStreamAdapter;

public class DataAtomInputStream
extends FilterInputStream {
    protected static final long MAC_TIMESTAMP_EPOCH = new GregorianCalendar(1904, 0, 1).getTimeInMillis();
    private byte[] readBuffer = new byte[8];

    public DataAtomInputStream(InputStream in) {
        super(in);
    }

    public DataAtomInputStream(ImageInputStream in) {
        super(new ImageInputStreamAdapter(in));
    }

    public final byte readByte() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return (byte)ch;
    }

    public final short readShort() throws IOException {
        this.readFully(this.readBuffer, 0, 2);
        return (short)((this.readBuffer[0] << 8) + (this.readBuffer[1] << 0));
    }

    public final int readInt() throws IOException {
        this.readFully(this.readBuffer, 0, 4);
        return (this.readBuffer[0] << 24) + (this.readBuffer[1] << 16) + (this.readBuffer[2] << 8) + (this.readBuffer[3] << 0);
    }

    public final long readLong() throws IOException {
        this.readFully(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    public final int readUByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    public final int readUShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public final long readUInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFL;
    }

    public final long skipBytes(long n) throws IOException {
        long total;
        long cur = 0L;
        for (total = 0L; total < n && (cur = (long)((int)this.skip(n - total))) > 0L; total += cur) {
        }
        return total;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }

    public Date readMacTimestamp() throws IOException {
        long timestamp = (long)this.readInt() & 0xFFFFFFFFL;
        return new Date(MAC_TIMESTAMP_EPOCH + timestamp * 1000L);
    }

    public double readFixed16D16() throws IOException {
        int wholePart = this.readUShort();
        int fractionPart = this.readUShort();
        return (double)wholePart + (double)fractionPart / 65536.0;
    }

    public double readFixed2D30() throws IOException {
        int fixed = this.readInt();
        int wholePart = fixed >>> 30;
        int fractionPart = fixed & 0x3FFFFFFF;
        return (double)wholePart + (double)fractionPart / 1.073741823E9;
    }

    public double readFixed8D8() throws IOException {
        int fixed = this.readUShort();
        int wholePart = fixed >>> 8;
        int fractionPart = fixed & 0xFF;
        return new Double((float)wholePart + (float)fractionPart / 256.0f);
    }

    public String readType() throws IOException {
        int id = this.readInt();
        byte[] b = new byte[]{(byte)(id >>> 24 & 0xFF), (byte)(id >>> 16 & 0xFF), (byte)(id >>> 8 & 0xFF), (byte)(id & 0xFF)};
        try {
            return new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public String readPString() throws IOException {
        int size = this.read();
        if (size == 0) {
            size = this.read();
            this.skipBytes(2L);
        }
        if (size < 0) {
            return "";
        }
        byte[] b = new byte[size];
        this.readFully(b);
        try {
            return new String(b, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }

    public String readPString(int fixedSize) throws IOException {
        int size = this.read();
        --fixedSize;
        if (size == 0) {
            size = this.read();
            this.skipBytes(2L);
            fixedSize -= 3;
        }
        if (size < 0) {
            this.skipBytes(fixedSize);
            return "";
        }
        byte[] b = new byte[fixedSize];
        this.readFully(b);
        try {
            return new String(b, 0, size, "ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            InternalError ie = new InternalError("ASCII not supported");
            ie.initCause(ex);
            throw ie;
        }
    }
}

