/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.quicktime;

import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import ru.sbtqa.monte.media.AbstractMovie;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.MovieReader;
import ru.sbtqa.monte.media.math.Rational;

public class QuickTimeMeta
extends AbstractMovie {
    private static final long serialVersionUID = 1L;
    public static final Locale[] LANGUAGE_CODES = new Locale[]{new Locale("en"), new Locale("fr"), new Locale("de"), new Locale("it"), new Locale("nld"), new Locale("swe"), new Locale("spa"), new Locale("dan"), new Locale("por"), new Locale("nor"), new Locale("heb"), new Locale("ja"), new Locale("ara"), new Locale("fin"), new Locale("ell"), new Locale("isl"), new Locale("mlt"), new Locale("tur"), new Locale("hrv"), new Locale("zh"), new Locale("urd"), new Locale("hin"), new Locale("tha"), new Locale("ko"), new Locale("lit"), new Locale("pol"), new Locale("hun"), new Locale("est"), new Locale("lav"), new Locale("sme"), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, new Locale("kat"), new Locale("ron"), new Locale("kir"), new Locale("tgk"), new Locale("tuk"), new Locale("mon"), new Locale("mon"), new Locale("pus"), new Locale("kur"), new Locale("kas"), new Locale("snd"), new Locale("bod"), new Locale("npi"), new Locale("san"), new Locale("mar"), new Locale("ben"), new Locale("asm"), new Locale("guj"), new Locale("pan"), new Locale("ory"), new Locale("mal"), new Locale("kan"), new Locale("tam"), new Locale("tel"), new Locale("sin"), new Locale("mya"), new Locale("khm"), new Locale("lao"), new Locale("vie"), new Locale("ind"), new Locale("tgl"), new Locale("mal")};
    protected Format fileFormat = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"});
    protected String brand;
    protected int versionYear;
    protected int versionMonth;
    protected int versionMinor;
    protected ArrayList<String> compatibleBrands = new ArrayList();
    protected Date creationTime;
    protected Date modificationTime;
    protected long timeScale;
    protected long duration;
    protected double preferredRate;
    protected double preferredVolume;
    protected double[] matrix;
    protected long previewTime;
    protected long previewDuration;
    protected long posterTime;
    protected long selectionTime;
    protected long selectionDuration;
    protected long currentTime;
    protected long nextTrackId;
    protected ArrayList<Track> tracks = new ArrayList();

    public QuickTimeMeta() {
        this.clear();
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getModificationTime() {
        return this.modificationTime;
    }

    public void setModificationTime(Date modificationTime) {
        this.modificationTime = modificationTime;
    }

    public long getTimeScale() {
        return this.timeScale;
    }

    public void setTimeScale(long movieTimeScale) {
        this.timeScale = movieTimeScale;
    }

    public double getPreferredRate() {
        return this.preferredRate;
    }

    public void setPreferredRate(double preferredRate) {
        this.preferredRate = preferredRate;
    }

    public double getPreferredVolume() {
        return this.preferredVolume;
    }

    public void setPreferredVolume(double preferredVolume) {
        this.preferredVolume = preferredVolume;
    }

    public long getPreviewTime() {
        return this.previewTime;
    }

    public void setPreviewTime(long previewTime) {
        this.previewTime = previewTime;
    }

    public long getPreviewDuration() {
        return this.previewDuration;
    }

    public void setPreviewDuration(long previewDuration) {
        this.previewDuration = previewDuration;
    }

    public long getPosterTime() {
        return this.posterTime;
    }

    public void setPosterTime(long posterTime) {
        this.posterTime = posterTime;
    }

    public long getSelectionTime() {
        return this.selectionTime;
    }

    public void setSelectionTime(long selectionTime) {
        this.selectionTime = selectionTime;
    }

    public long getSelectionDuration() {
        return this.selectionDuration;
    }

    public void setSelectionDuration(long selectionDuration) {
        this.selectionDuration = selectionDuration;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }

    public void setNextTrackId(long nextTrackId) {
        this.nextTrackId = nextTrackId;
    }

    @Override
    public Rational getDuration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public long timeToSample(int track, Rational seconds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational sampleToTime(int track, long sample) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public Format getFormat(int track) {
        return this.tracks.get((int)track).format;
    }

    @Override
    public Format getFileFormat() {
        return this.fileFormat;
    }

    @Override
    public MovieReader getReader() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected void clear() {
        this.brand = "qt";
        this.versionMinor = 0;
        this.versionMonth = 0;
        this.versionYear = 0;
        this.compatibleBrands.clear();
        this.compatibleBrands.add(this.brand);
        this.creationTime = this.modificationTime = new Date();
        this.timeScale = 600L;
        this.duration = 0L;
        this.preferredRate = 1.0;
        this.preferredVolume = 1.0;
        this.previewTime = 0L;
        this.previewDuration = 0L;
        this.posterTime = 0L;
        this.selectionTime = 0L;
        this.selectionDuration = 0L;
        this.currentTime = 0L;
        this.nextTrackId = 0L;
        this.matrix = new double[9];
        this.tracks.clear();
    }

    public double[] getTransformationMatrix() {
        return this.matrix;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("QuickTimeMovie{ fileFormat=" + this.fileFormat + "\nftyp: brand=" + this.brand + ", versionYear=" + this.versionYear + ", versionMonth=" + this.versionMonth + ", versionMinor=" + this.versionMinor + ", compatibleBrands=" + this.compatibleBrands + "\nmvhd: creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", timeScale=" + this.timeScale + ", duration=" + this.duration + ", preferredRate=" + this.preferredRate + ", preferredVolume=" + this.preferredVolume + ", matrix=" + Arrays.toString(this.matrix) + ", previewTime=" + this.previewTime + ", previewDuration=" + this.previewDuration + ", posterTime=" + this.posterTime + ", selectionTime=" + this.selectionTime + ", selectionDuration=" + this.selectionDuration + ", currentTime=" + this.currentTime + ", nextTrackId=" + this.nextTrackId);
        for (Track t : this.tracks) {
            buf.append("\ntrak: ");
            buf.append(t.toString());
        }
        buf.append('}');
        return buf.toString();
    }

    public static class DataReference {
        protected String referenceType;
        private static final int DataRefSelfReference = 1;
        protected int referenceFlags = 1;
        protected byte[] data;

        public String toString() {
            return "DataReference{referenceType=" + this.referenceType + ", referenceFlags=" + this.referenceFlags + ", data=" + this.data + '}';
        }
    }

    public static class Edit {
        public int trackDuration;
        public int mediaTime;
        public int mediaRate;

        public Edit(int trackDuration, int mediaTime, double mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0.0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = (int)(mediaRate * 65536.0);
        }

        public Edit(int trackDuration, int mediaTime, int mediaRate) {
            if (trackDuration < 0) {
                throw new IllegalArgumentException("trackDuration must not be < 0:" + trackDuration);
            }
            if (mediaTime < -1) {
                throw new IllegalArgumentException("mediaTime must not be < -1:" + mediaTime);
            }
            if (mediaRate <= 0) {
                throw new IllegalArgumentException("mediaRate must not be <= 0:" + mediaRate);
            }
            this.trackDuration = trackDuration;
            this.mediaTime = mediaTime;
            this.mediaRate = mediaRate;
        }

        public String toString() {
            return "Edit{trackDuration=" + this.trackDuration + ", mediaTime=" + this.mediaTime + ", mediaRate=" + this.mediaRate + '}';
        }
    }

    protected static class SampleDescription {
        protected String mediaType;
        protected int dataReferenceIndex;
        protected float videoTemporalQuality;
        protected float videoSpatialQuality;
        protected int videoWidth;
        protected int videoHeight;
        protected double videoHorizontalResolution = 72.0;
        protected double videoVerticalResolution = 72.0;
        protected int videoFrameCount;
        protected String videoCompressorName;
        protected int videoDepth = -1;
        protected int videoColorTableId = -1;
        protected int soundNumberOfChannels;
        protected int soundSampleSize;
        protected int soundCompressionId;
        protected long soundSamplesPerPacket;
        protected long soundBytesPerPacket;
        protected long soundBytesPerFrame;
        protected long soundBytesPerSample;
        protected double soundSampleRate;
        protected byte[] stsdExtensions = new byte[0];

        protected SampleDescription() {
        }

        public String toString() {
            return "SampleDescription{, videoDepth=" + this.videoDepth + ", soundNumberOfChannels=" + this.soundNumberOfChannels + ", soundSampleSize=" + this.soundSampleSize + ", soundCompressionId=" + this.soundCompressionId + ", soundSamplesPerPacket=" + this.soundSamplesPerPacket + ", soundBytesPerPacket=" + this.soundBytesPerPacket + ", soundBytesPerFrame=" + this.soundBytesPerFrame + ", soundBytesPerSample=" + this.soundBytesPerSample + ", soundSampleRate=" + this.soundSampleRate + ", stsdExtensions=" + this.stsdExtensions + '}';
        }
    }

    protected static class Media {
        protected Date mediaCreationTime;
        protected Date mediaModificationTime;
        protected long mediaTimeScale = 600L;
        protected long mediaDuration = 0L;
        protected Locale mediaLanguage = Locale.ENGLISH;
        protected String mediaLanguageEncoding = "UTF-8";
        protected int mediaQuality;
        protected double soundBalance;
        protected String mediaCompressionType;
        protected String mediaCompressorName;
        protected ArrayList<DataReference> dataReferenceList = new ArrayList();
        protected ArrayList<Chunk> chunks = new ArrayList();
        protected ArrayList<TimeToSampleGroup> timeToSamples = new ArrayList();
        protected ArrayList<SampleToChunk> samplesToChunks = new ArrayList();
        protected ArrayList<SampleSizeGroup> sampleSizes = new ArrayList();
        protected ArrayList<Long> syncSamples = null;
        protected long sampleCount = 0L;
        protected int syncInterval;
        protected float videoQuality = 0.97f;
        protected IndexColorModel videoColorTable;
        boolean videoFlagNoLeanAhead;
        int graphicsMode;
        int[] opcolor = new int[3];
        private ArrayList<SampleDescription> sampleDescriptions = new ArrayList();

        protected Media() {
        }

        public void addSampleDescription(SampleDescription d) {
            this.sampleDescriptions.add(d);
        }

        public void addSample(Sample sample, int sampleDescriptionId, boolean isSyncSample) {
            this.mediaDuration += sample.duration;
            ++this.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    this.syncSamples.add(this.sampleCount);
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddSample(sample)) {
                this.timeToSamples.add(new TimeToSampleGroup(sample));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddSample(sample)) {
                this.sampleSizes.add(new SampleSizeGroup(sample));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddSample(sample, sampleDescriptionId)) {
                this.chunks.add(new Chunk(sample, sampleDescriptionId));
            }
        }

        public void addChunk(Chunk chunk, boolean isSyncSample) {
            this.mediaDuration += chunk.firstSample.duration * chunk.sampleCount;
            this.sampleCount += chunk.sampleCount;
            if (isSyncSample) {
                if (this.syncSamples != null) {
                    for (long i = this.sampleCount - chunk.sampleCount; i < this.sampleCount; ++i) {
                        this.syncSamples.add(i);
                    }
                }
            } else if (this.syncSamples == null) {
                this.syncSamples = new ArrayList();
                for (long i = 1L; i < this.sampleCount; ++i) {
                    this.syncSamples.add(i);
                }
            }
            if (this.timeToSamples.isEmpty() || !this.timeToSamples.get(this.timeToSamples.size() - 1).maybeAddChunk(chunk)) {
                this.timeToSamples.add(new TimeToSampleGroup(chunk));
            }
            if (this.sampleSizes.isEmpty() || !this.sampleSizes.get(this.sampleSizes.size() - 1).maybeAddChunk(chunk)) {
                this.sampleSizes.add(new SampleSizeGroup(chunk));
            }
            if (this.chunks.isEmpty() || !this.chunks.get(this.chunks.size() - 1).maybeAddChunk(chunk)) {
                this.chunks.add(chunk);
            }
        }

        public boolean isEmpty() {
            return this.sampleCount == 0L;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }

        public String toString() {
            return "Media{mediaCreationTime=" + this.mediaCreationTime + ", mediaModificationTime=" + this.mediaModificationTime + ", mediaTimeScale=" + this.mediaTimeScale + ", mediaDuration=" + this.mediaDuration + ", mediaLanguage=" + this.mediaLanguage + ", mediaQuality=" + this.mediaQuality + ", videoColorTable=" + this.videoColorTable + ", soundBalance=" + this.soundBalance + ", mediaCompressionType=" + this.mediaCompressionType + ", mediaCompressorName=" + this.mediaCompressorName + ", dataReferenceList=" + this.dataReferenceList + ", chunks=" + this.chunks + ", timeToSamples=" + this.timeToSamples + ", sampleSizes=" + this.sampleSizes + ", syncSamples=" + this.syncSamples + ", sampleCount=" + this.sampleCount + ", syncInterval=" + this.syncInterval + ", videoQuality=" + this.videoQuality + ", videoColorTable=" + this.videoColorTable + '}';
        }
    }

    protected static class Track {
        protected FormatKeys.MediaType mediaType;
        protected Format format;
        private static final int TrackEnable = 1;
        private static final int TrackInMovie = 2;
        private static final int TrackInPreview = 4;
        private static final int TrackInPoster = 8;
        protected int headerFlags = 15;
        protected Date creationTime;
        protected Date modificationTime;
        protected int trackId;
        protected long duration;
        protected int layer;
        protected int alternateGroup;
        protected double volume;
        protected double[] matrix = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
        protected double width;
        protected double height;
        protected ArrayList<Edit> editList = new ArrayList();
        protected ArrayList<Media> mediaList = new ArrayList();

        protected Track() {
        }

        public void setEnabled(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 1 : this.headerFlags & 0xFE;
        }

        public boolean isEnabled() {
            return (this.headerFlags & 1) != 0;
        }

        public void setInMovie(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 2 : this.headerFlags & 0xFD;
        }

        public boolean isInMovie() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPreview(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 4 : this.headerFlags & 0xFB;
        }

        public boolean isInPreview() {
            return (this.headerFlags & 4) != 0;
        }

        public void setInPoster(boolean newValue) {
            this.headerFlags = newValue ? this.headerFlags | 8 : this.headerFlags & 0xF7;
        }

        public boolean isInPoster() {
            return (this.headerFlags & 8) != 0;
        }

        public long getTrackDuration(long movieTimeScale) {
            if (this.editList.isEmpty()) {
                long sum = 0L;
                for (Media m : this.mediaList) {
                    sum += m.mediaDuration * movieTimeScale / m.mediaTimeScale;
                }
                return sum;
            }
            long sum = 0L;
            for (Edit e : this.editList) {
                sum += (long)e.trackDuration;
            }
            return sum;
        }

        public String toString() {
            return "Track{ format=" + this.format + "\ntkhd: creationTime=" + this.creationTime + ", modificationTime=" + this.modificationTime + ", trackId=" + this.trackId + ", duration=" + this.duration + ", layer=" + this.layer + ", alternateGroup=" + this.alternateGroup + ", volume=" + this.volume + ", matrix=" + Arrays.toString(this.matrix) + ", width=" + this.width + ", height=" + this.height + "\nelst: editList=" + this.editList + "\nmdia: mediaList=" + this.mediaList + '}';
        }
    }

    protected static class Chunk
    extends Group {
        protected int sampleDescriptionId;

        public Chunk(Sample firstSample, int sampleDescriptionId) {
            super(firstSample);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public Chunk(Sample firstSample, Sample lastSample, int sampleCount, int sampleDescriptionId) {
            super(firstSample, lastSample, sampleCount);
            this.sampleDescriptionId = sampleDescriptionId;
        }

        public boolean maybeAddSample(Sample sample, int sampleDescriptionId) {
            if (sampleDescriptionId == this.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == sample.offset) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleDescriptionId == chunk.sampleDescriptionId && this.lastSample.offset + this.lastSample.length == chunk.firstSample.offset) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getChunkOffset() {
            return this.firstSample.offset;
        }
    }

    protected static class SampleSizeGroup
    extends Group {
        public SampleSizeGroup(Sample firstSample) {
            super(firstSample);
        }

        public SampleSizeGroup(Group group) {
            super(group);
        }

        public SampleSizeGroup(Sample firstSample, Sample lastSample, long sampleCount) {
            super(firstSample, lastSample, sampleCount);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.length == sample.length) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.length == chunk.firstSample.length) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleLength() {
            return this.firstSample.length;
        }
    }

    protected static class SampleToChunk {
        int firstChunk;
        int samplesPerChunk;
        int sampleDescription;

        protected SampleToChunk() {
        }
    }

    protected static class TimeToSampleGroup
    extends Group {
        public TimeToSampleGroup(Sample firstSample) {
            super(firstSample);
        }

        protected TimeToSampleGroup(Sample firstSample, Sample lastSample, long sampleCount) {
            super(firstSample, lastSample, sampleCount);
        }

        public TimeToSampleGroup(Group group) {
            super(group);
        }

        @Override
        public boolean maybeAddSample(Sample sample) {
            if (this.firstSample.duration == sample.duration) {
                return super.maybeAddSample(sample);
            }
            return false;
        }

        @Override
        public boolean maybeAddChunk(Chunk chunk) {
            if (this.firstSample.duration == chunk.firstSample.duration) {
                return super.maybeAddChunk(chunk);
            }
            return false;
        }

        public long getSampleDuration() {
            return this.firstSample.duration;
        }
    }

    protected static class Sample {
        long offset;
        long length;
        long duration;

        public Sample(long duration, long offset, long length) {
            this.duration = duration;
            this.offset = offset;
            this.length = length;
        }
    }

    protected static abstract class Group {
        protected Sample firstSample;
        protected Sample lastSample;
        protected long sampleCount;
        protected static final long maxSampleCount = Integer.MAX_VALUE;

        protected Group(Sample firstSample) {
            this.firstSample = this.lastSample = firstSample;
            this.sampleCount = firstSample == null ? 0L : 1L;
        }

        protected Group(Sample firstSample, Sample lastSample, long sampleCount) {
            this.firstSample = firstSample;
            this.lastSample = lastSample;
            this.sampleCount = sampleCount;
            if (sampleCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Capacity exceeded");
            }
        }

        protected Group(Group group) {
            this.firstSample = group.firstSample;
            this.lastSample = group.lastSample;
            this.sampleCount = group.sampleCount;
        }

        protected boolean maybeAddSample(Sample sample) {
            if (this.sampleCount < Integer.MAX_VALUE) {
                this.lastSample = sample;
                ++this.sampleCount;
                return true;
            }
            return false;
        }

        protected boolean maybeAddChunk(Chunk chunk) {
            if (this.sampleCount + chunk.sampleCount <= Integer.MAX_VALUE) {
                this.lastSample = chunk.lastSample;
                this.sampleCount += chunk.sampleCount;
                return true;
            }
            return false;
        }

        public long getSampleCount() {
            return this.sampleCount;
        }
    }
}

