/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.quicktime;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import ru.sbtqa.monte.media.Buffer;
import ru.sbtqa.monte.media.BufferFlag;
import ru.sbtqa.monte.media.Codec;
import ru.sbtqa.monte.media.Format;
import ru.sbtqa.monte.media.FormatKeys;
import ru.sbtqa.monte.media.MovieReader;
import ru.sbtqa.monte.media.Registry;
import ru.sbtqa.monte.media.VideoFormatKeys;
import ru.sbtqa.monte.media.math.Rational;
import ru.sbtqa.monte.media.quicktime.QuickTimeInputStream;
import ru.sbtqa.monte.media.quicktime.QuickTimeMeta;

public class QuickTimeReader
extends QuickTimeInputStream
implements MovieReader {
    private Buffer[] inputBuffers = null;
    private Codec[] codecs = null;
    public static final Format QUICKTIME = new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, "video/quicktime"});

    public QuickTimeReader(File file) throws IOException {
        super(file);
    }

    public QuickTimeReader(ImageInputStream in) throws IOException {
        super(in);
    }

    @Override
    public long timeToSample(int track, Rational seconds) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational sampleToTime(int track, long sample) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Format getFileFormat() throws IOException {
        return QUICKTIME;
    }

    @Override
    public Format getFormat(int track) throws IOException {
        this.ensureRealized();
        return this.meta.tracks.get((int)track).format;
    }

    @Override
    public long getChunkCount(int track) throws IOException {
        this.ensureRealized();
        return this.meta.tracks.get((int)track).mediaList.get((int)0).sampleCount;
    }

    @Override
    protected void ensureRealized() throws IOException {
        super.ensureRealized();
        this.inputBuffers = new Buffer[this.meta.getTrackCount()];
        this.codecs = new Codec[this.meta.getTrackCount()];
        for (int i = 0; i < this.inputBuffers.length; ++i) {
            this.inputBuffers[i] = new Buffer();
        }
    }

    public BufferedImage read(int track, BufferedImage img) throws IOException {
        this.ensureRealized();
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        if (this.codecs[track] == null) {
            this.createCodec(track);
        }
        Buffer buf = new Buffer();
        buf.data = img;
        do {
            this.read(track, this.inputBuffers[track]);
            this.codecs[track].process(this.inputBuffers[track], buf);
        } while (buf.isFlag(BufferFlag.DISCARD) && !buf.isFlag(BufferFlag.END_OF_MEDIA));
        if (buf.isFlag(BufferFlag.END_OF_MEDIA)) {
            return null;
        }
        return (BufferedImage)buf.data;
    }

    @Override
    public void read(int track, Buffer buffer) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int nextTrack() throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setMovieReadTime(Rational newValue) throws IOException {
        this.ensureRealized();
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational getReadTime(int track) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rational getDuration() throws IOException {
        return new Rational(this.getMovieDuration(), this.getMovieTimeScale());
    }

    @Override
    public Rational getDuration(int track) throws IOException {
        this.ensureRealized();
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        QuickTimeMeta.Media m = tr.mediaList.get(0);
        Rational trackDuration = new Rational(m.mediaDuration, m.mediaTimeScale);
        return trackDuration;
    }

    @Override
    public int findTrack(int fromTrack, Format format) throws IOException {
        int n = this.getTrackCount();
        for (int i = fromTrack; i < n; ++i) {
            if (!this.getFormat(i).matches(format)) continue;
            return i;
        }
        return -1;
    }

    private void createCodec(int track) {
        QuickTimeMeta.Track tr = this.meta.tracks.get(track);
        Format fmt = tr.format;
        Codec codec = this.createCodec(fmt);
        String enc = (String)fmt.get(VideoFormatKeys.EncodingKey);
        if (codec == null) {
            throw new UnsupportedOperationException("Track " + tr + " no codec found for format " + fmt);
        }
        if (fmt.get(VideoFormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            if (null == codec.setInputFormat(fmt)) {
                throw new UnsupportedOperationException("Track " + tr + " codec " + codec + " does not support input format " + fmt + ". codec=" + codec);
            }
            Format outFormat = fmt.prepend(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.MimeTypeKey, "Java", VideoFormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class});
            if (null == codec.setOutputFormat(outFormat)) {
                throw new UnsupportedOperationException("Track " + tr + " codec does not support output format " + outFormat + ". codec=" + codec);
            }
        }
        this.codecs[track] = codec;
    }

    private Codec createCodec(Format fmt) {
        Codec[] codecs = Registry.getInstance().getDecoders(fmt.prepend(VideoFormatKeys.MimeTypeKey, "video/quicktime"));
        return codecs.length == 0 ? null : codecs[0];
    }
}

