/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.seq;

import ru.sbtqa.monte.media.eightsvx.EightSVXAudioClip;
import ru.sbtqa.monte.media.eightsvx.LoopableAudioClip;
import ru.sbtqa.monte.media.seq.SEQMovieTrack;

public class SEQAudioCommand {
    public static final int COMMAND_PLAY_SOUND = 1;
    public static final int COMMAND_STOP_SOUND = 2;
    public static final int COMMAND_SET_FREQVOL = 3;
    public static final int FLAG_NO_INTERRUPT = 1;
    private int command;
    private int volume;
    private int sound;
    private int repeats;
    private int channelMask;
    private static final int CHANNEL0_MASK = 1;
    private static final int CHANNEL1_MASK = 2;
    private static final int CHANNEL2_MASK = 4;
    private static final int CHANNEL3_MASK = 8;
    private static final int CHANNEL_LEFT_MASK = 5;
    private static final int CHANNEL_RIGHT_MASK = 10;
    private int frequency;
    private int flags;
    private int activeChannelMask;
    private LoopableAudioClip audioClip;

    public SEQAudioCommand(int command, int volume, int sound, int repeats, int channelMask, int frequency, int flags) {
        this.command = command;
        this.volume = volume;
        this.sound = sound;
        this.repeats = repeats;
        this.channelMask = channelMask;
        this.frequency = frequency;
        this.flags = flags;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getSound() {
        return this.sound;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getCommand() {
        return this.command;
    }

    public void prepare(SEQMovieTrack track) {
        if (this.command == 1 && this.audioClip == null) {
            float pan = (this.channelMask & 5) != 0 && (this.channelMask & 0xA) == 0 ? -1.0f : ((this.channelMask & 0xA) != 0 && (this.channelMask & 5) == 0 ? 1.0f : 0.0f);
            EightSVXAudioClip eightSVXAudioClip = (EightSVXAudioClip)track.getAudioClip(this.sound - 1);
            this.audioClip = eightSVXAudioClip.createAudioClip(this.frequency == 0 ? eightSVXAudioClip.getSampleRate() : this.frequency, this.volume, track.isSwapSpeakers() ? -pan : pan);
        }
    }

    public void play(SEQMovieTrack track) {
        this.prepare(track);
        if (this.audioClip != null) {
            if (this.repeats < 2) {
                this.audioClip.play();
            } else {
                this.audioClip.loop(this.repeats);
            }
        }
        this.activeChannelMask = this.channelMask;
    }

    public void stop(SEQMovieTrack track) {
        this.activeChannelMask = 0;
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }

    public void stop(SEQMovieTrack track, int channelMask) {
        this.activeChannelMask &= ~channelMask;
        if (this.activeChannelMask == 0) {
            this.audioClip.stop();
        }
    }

    public void doCommand(SEQMovieTrack track, SEQAudioCommand[] runningCommands) {
        switch (this.command) {
            case 1: {
                boolean isPlayingOnOneChannel = false;
                for (int j = 0; j < 4; ++j) {
                    if ((this.channelMask & 1 << j) == 0) continue;
                    if (runningCommands[j] != null) {
                        runningCommands[j].stop(track, 1 << j);
                    }
                    if (!isPlayingOnOneChannel) {
                        isPlayingOnOneChannel = true;
                        this.play(track);
                    }
                    runningCommands[j] = this;
                }
                break;
            }
            case 2: {
                for (int j = 0; j < 4; ++j) {
                    if ((this.channelMask & 1 << j) == 0 || runningCommands[j] == null) continue;
                    runningCommands[j].stop(track, 1 << j);
                    runningCommands[j] = null;
                }
                break;
            }
        }
    }

    public void dispose() {
        if (this.audioClip != null) {
            this.audioClip = null;
        }
    }
}

