/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.seq;

import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import ru.sbtqa.monte.media.ilbm.ColorCycle;
import ru.sbtqa.monte.media.seq.SEQAudioCommand;
import ru.sbtqa.monte.media.seq.SEQFrame;

public class SEQMovieTrack {
    private int width;
    private int height;
    private int xPosition;
    private int yPosition;
    private int nbPlanes;
    private int nbPalettes_ = -1;
    private int masking;
    public static final int MSK_NONE = 0;
    public static final int MSK_HAS_MASK = 1;
    public static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    public static final int MSK_LASSO = 3;
    private int transparentColor;
    private int xAspect;
    private int yAspect;
    private int pageWidth;
    private int pageHeight;
    private int screenMode;
    private int jiffies;
    private final boolean isPlayWrapupFrames = true;
    private boolean isSwapSpeakers = false;
    public static final int MODE_INDEXED_COLORS = 0;
    public static final int MODE_DIRECT_COLORS = 1;
    public static final int MODE_EHB = 2;
    public static final int MODE_HAM6 = 3;
    public static final int MODE_HAM8 = 4;
    private int compression_;
    public static final int CMP_NONE = 0;
    public static final int CMP_BYTE_RUN_1 = 1;
    public static final int CMP_VERTICAL = 2;
    private long totalDuration;
    private HashMap<String, Object> properties = new HashMap();
    private ArrayList<SEQFrame> frames = new ArrayList();
    private ArrayList<AudioClip> audioClips = new ArrayList();
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private ArrayList<ColorCycle> colorCycles = new ArrayList();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object newValue) {
        Object oldValue = this.properties.get(name);
        if (newValue == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, newValue);
        }
        this.listeners.firePropertyChange(name, oldValue, newValue);
    }

    public boolean isPlayWrapupFrames() {
        return true;
    }

    public int getInterleave() {
        return this.frames.size() > 0 && this.frames.get(this.frames.size() - 1).getInterleave() == 1 ? 1 : 2;
    }

    public void setSwapSpeakers(boolean newValue) {
        boolean oldValue = this.isSwapSpeakers;
        this.isSwapSpeakers = newValue;
        if (newValue != oldValue) {
            for (SEQFrame f : this.frames) {
                SEQAudioCommand[] aac = f.getAudioCommands();
                if (aac == null) continue;
                for (int j = 0; j < aac.length; ++j) {
                    aac[j].dispose();
                }
            }
        }
    }

    public boolean isSwapSpeakers() {
        return this.isSwapSpeakers;
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    private void firePropertyChange(String name, int oldValue, int newValue) {
        this.listeners.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    public void setJiffies(int newValue) {
        int oldValue = this.jiffies;
        this.jiffies = newValue;
        this.firePropertyChange("jiffies", oldValue, newValue);
    }

    public void setCompression(int newValue) {
        int oldValue = this.compression_;
        this.compression_ = newValue;
        this.firePropertyChange("compression", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setXPosition(int newValue) {
        int oldValue = this.xPosition;
        this.xPosition = newValue;
        this.firePropertyChange("xPosition", oldValue, newValue);
    }

    public void setYPosition(int newValue) {
        int oldValue = this.yPosition;
        this.yPosition = newValue;
        this.firePropertyChange("yPosition", oldValue, newValue);
    }

    public void setNbPlanes(int newValue) {
        int oldValue = this.nbPlanes;
        this.nbPlanes = newValue;
        this.firePropertyChange("nbPlanes", oldValue, newValue);
    }

    public void setMasking(int newValue) {
        int oldValue = this.masking;
        this.masking = newValue;
        this.firePropertyChange("masking", oldValue, newValue);
    }

    public void setTransparentColor(int newValue) {
        int oldValue = this.transparentColor;
        this.transparentColor = newValue;
        this.firePropertyChange("transparentColor", oldValue, newValue);
    }

    public void setXAspect(int newValue) {
        int oldValue = this.xAspect;
        this.xAspect = newValue;
        this.firePropertyChange("xAspect", oldValue, newValue);
    }

    public void setYAspect(int newValue) {
        int oldValue = this.yAspect;
        this.yAspect = newValue;
        this.firePropertyChange("yAspect", oldValue, newValue);
    }

    public void setPageWidth(int newValue) {
        int oldValue = this.pageWidth;
        this.pageWidth = newValue;
        this.firePropertyChange("pageWidth", oldValue, newValue);
    }

    public void setPageHeight(int newValue) {
        int oldValue = this.pageHeight;
        this.pageHeight = newValue;
        this.firePropertyChange("pageHeight", oldValue, newValue);
    }

    public void setScreenMode(int newValue) {
        int oldValue = this.screenMode;
        this.screenMode = newValue;
        this.firePropertyChange("screenMode", oldValue, newValue);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXPosition() {
        return this.xPosition;
    }

    public int getYPosition() {
        return this.yPosition;
    }

    public int getNbPlanes() {
        return this.nbPlanes;
    }

    public int getNbPalettes() {
        block4: {
            int n;
            if (this.nbPalettes_ != -1 || (n = this.getFrameCount()) <= 0) break block4;
            ColorModel cm = this.getFrame(0).getColorModel();
            if (cm instanceof IndexColorModel) {
                IndexColorModel prev = (IndexColorModel)cm;
                int size = prev.getMapSize();
                byte[] pr = new byte[size];
                byte[] pg = new byte[size];
                byte[] pb = new byte[size];
                byte[] cr = new byte[size];
                byte[] cg = new byte[size];
                byte[] cb = new byte[size];
                prev.getReds(pr);
                prev.getGreens(pg);
                prev.getBlues(pb);
                this.nbPalettes_ = 1;
                for (int i = 1; i < n; ++i) {
                    IndexColorModel cur = (IndexColorModel)this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    cur.getReds(cr);
                    cur.getGreens(cg);
                    cur.getBlues(cb);
                    if (Arrays.equals(cr, pr) && Arrays.equals(cg, pg) && Arrays.equals(cb, pb)) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                    System.arraycopy(cr, 0, pr, 0, cr.length);
                    System.arraycopy(cg, 0, pg, 0, cg.length);
                    System.arraycopy(cb, 0, pb, 0, cb.length);
                }
            } else {
                this.nbPalettes_ = 1;
                ColorModel prev = cm;
                for (int i = 1; i < n; ++i) {
                    ColorModel cur = this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                }
            }
        }
        return this.nbPalettes_;
    }

    public int getMasking() {
        return this.masking;
    }

    public int getTransparentColor() {
        return this.transparentColor;
    }

    public int getXAspect() {
        return this.xAspect;
    }

    public int getYAspect() {
        return this.yAspect;
    }

    public int getPageWidth() {
        return this.pageWidth;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public int getScreenMode() {
        return this.screenMode;
    }

    public int getJiffies() {
        return this.jiffies;
    }

    public int getCompression() {
        return this.compression_;
    }

    public int getDeltaOperation() {
        int lastFrame = this.frames.size() - 1;
        if (lastFrame < 0) {
            return -1;
        }
        return this.frames.get(lastFrame).getOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(SEQFrame frame) {
        int oldValue;
        SEQMovieTrack sEQMovieTrack = this;
        synchronized (sEQMovieTrack) {
            oldValue = this.frames.size();
            this.frames.add(frame);
            this.totalDuration = -1L;
        }
        this.firePropertyChange("frameCount", oldValue, oldValue + 1);
    }

    public void addAudioClip(AudioClip clip) {
        int oldValue = this.audioClips.size();
        this.audioClips.add(clip);
        this.firePropertyChange("audioClipCount", oldValue, oldValue + 1);
    }

    public int getAudioClipCount() {
        return this.audioClips.size();
    }

    public AudioClip getAudioClip(int index) {
        return this.audioClips.get(index);
    }

    public int getFrameCount() {
        int size = this.frames.size();
        return size;
    }

    public SEQFrame getFrame(int index) {
        return this.frames.get(index);
    }

    public long getFrameDuration(int index) {
        return this.frames.get(index).getRelTime();
    }

    public synchronized long getTotalDuration() {
        if (this.totalDuration == -1L) {
            this.totalDuration = 0L;
            for (int i = this.getFrameCount() - 1; i > -1; --i) {
                this.totalDuration += Math.max(this.getFrameDuration(i), 1L);
            }
        }
        return this.totalDuration;
    }

    public void addColorCycle(ColorCycle cc) {
        int oldCount = this.colorCycles.size();
        this.colorCycles.add(cc);
        this.firePropertyChange("colorCyclesCount", oldCount, this.colorCycles.size());
    }

    public List<ColorCycle> getColorCycles() {
        return this.colorCycles;
    }

    public int getColorCyclesCount() {
        return this.colorCycles.size();
    }

    public void removeFrame(int i) {
        this.frames.remove(i);
        this.totalDuration = -1L;
    }
}

