/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import java.util.HashMap;
import ru.sbtqa.monte.media.tiff.ValueFormatter;

public class EnumValueFormatter
implements ValueFormatter {
    private HashMap<Integer, String> enumMap = new HashMap();

    public EnumValueFormatter(Object ... enumeration) {
        for (int i = 0; i < enumeration.length; i += 2) {
            String value = (String)enumeration[i];
            Integer key = (Integer)enumeration[i + 1];
            if (this.enumMap.containsKey(key)) {
                this.enumMap.put(key, this.enumMap.get(key) + ", " + value);
                continue;
            }
            this.enumMap.put(key, value);
        }
    }

    @Override
    public Object format(Object value) {
        int intValue;
        if (value instanceof Number && this.enumMap.containsKey(intValue = ((Number)value).intValue())) {
            return this.enumMap.get(intValue);
        }
        return value;
    }

    @Override
    public Object prettyFormat(Object value) {
        int intValue;
        if (value instanceof Number && this.enumMap.containsKey(intValue = ((Number)value).intValue())) {
            return "0x" + Integer.toHexString(intValue) + " [" + this.enumMap.get(intValue) + "]";
        }
        return value;
    }

    @Override
    public String descriptionFormat(Object value) {
        int intValue;
        if (value instanceof Number && this.enumMap.containsKey(intValue = ((Number)value).intValue())) {
            return this.enumMap.get(intValue);
        }
        return null;
    }
}

