/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.sbtqa.monte.media.tiff.IFDEntry;

public class IFD {
    private long offset;
    private boolean hasNextOffset;
    private long nextOffset;
    private ArrayList<IFDEntry> entries;

    public IFD(long offset, boolean hasNextOffset) {
        this.offset = offset;
        this.hasNextOffset = hasNextOffset;
        this.entries = new ArrayList();
    }

    public long getOffset() {
        return this.offset;
    }

    void setNextOffset(long nextOffset) {
        this.nextOffset = nextOffset;
    }

    public long getNextOffset() {
        return this.hasNextOffset ? this.nextOffset : 0L;
    }

    public boolean hasNextOffset() {
        return this.hasNextOffset;
    }

    public int getCount() {
        return this.entries.size();
    }

    public IFDEntry get(int index) {
        return null;
    }

    void add(IFDEntry entry) {
        this.entries.add(entry);
    }

    public List<IFDEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IFD offset:");
        buf.append(this.offset);
        buf.append(", numEntries:");
        buf.append(this.entries.size());
        buf.append(", next:");
        buf.append(this.nextOffset);
        for (IFDEntry e : this.entries) {
            buf.append("\n  ");
            buf.append(e);
        }
        return buf.toString();
    }

    public long getLength() {
        return this.getCount() * 12 + (this.hasNextOffset ? 4 : 0);
    }
}

