/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import java.util.HashMap;
import ru.sbtqa.monte.media.math.Rational;

public enum IFDDataType {
    ASCII(2, String.class),
    BYTE(1, Short.class, Short.TYPE),
    SHORT(3, Integer.class, Integer.TYPE),
    LONG(4, Long.class, Long.TYPE),
    RATIONAL(5, Rational.class),
    SBYTE(6, Byte.class, Byte.TYPE),
    UNDEFINED(7, Byte.class, Byte.TYPE),
    SSHORT(8, Short.class, Short.TYPE),
    SLONG(9, Integer.class, Integer.TYPE),
    SRATIONAL(10, Rational.class),
    FLOAT(11, Float.class, Float.TYPE),
    DOUBLE(12, Double.class, Double.TYPE),
    IFD(13, Long.class, Long.TYPE);

    private final int typeNumber;
    private final Class<?>[] componentClasses;
    private static final HashMap<Integer, IFDDataType> valueToFieldType;

    private IFDDataType(int typeNumber, Class<?> ... componentClasses) {
        this.typeNumber = typeNumber;
        this.componentClasses = componentClasses;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public static IFDDataType valueOf(int typeNumber) {
        return valueToFieldType.get(typeNumber);
    }

    void checkType(Object data) {
        if (data != null) {
            Class<?> cc = data.getClass();
            while (cc.isArray()) {
                cc = cc.getComponentType();
            }
            for (Class<?> validcc : this.componentClasses) {
                if (cc != validcc) continue;
                return;
            }
            throw new IllegalArgumentException(data + " is illegal for " + (Object)((Object)this));
        }
    }

    static {
        valueToFieldType = new HashMap();
        for (IFDDataType t : IFDDataType.values()) {
            valueToFieldType.put(t.getTypeNumber(), t);
        }
    }
}

