/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import java.io.IOException;
import java.nio.ByteOrder;
import ru.sbtqa.monte.media.tiff.IFDDataType;
import ru.sbtqa.monte.media.tiff.TIFFInputStream;

public class IFDEntry {
    private int tagNumber;
    private int typeNumber;
    private long count;
    private long valueOffset;
    private long entryOffset;
    private long ifdOffset;
    private Object data;

    public IFDEntry(int tagNumber, int typeNumber, long count, long valueOffset, long entryOffset) {
        this.tagNumber = tagNumber;
        this.typeNumber = typeNumber;
        this.count = count;
        this.valueOffset = valueOffset;
        this.entryOffset = entryOffset;
    }

    public long getCount() {
        return this.count;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public long getValueOffset() {
        return this.valueOffset;
    }

    public long getDataOffset() {
        return this.isDataInValueOffset() ? this.entryOffset + 8L : this.valueOffset + this.ifdOffset;
    }

    public void setIFDOffset(long newValue) {
        this.ifdOffset = newValue;
    }

    public long getEntryOffset() {
        return this.entryOffset;
    }

    public long getIFDOffset() {
        return this.ifdOffset;
    }

    public boolean isDataInValueOffset() {
        switch (IFDDataType.valueOf(this.typeNumber)) {
            case ASCII: {
                return false;
            }
            case BYTE: {
                return this.count <= 4L;
            }
            case SHORT: {
                return this.count <= 2L;
            }
            case LONG: {
                return this.count <= 1L;
            }
            case RATIONAL: {
                return false;
            }
            case SBYTE: {
                return this.count <= 4L;
            }
            case UNDEFINED: {
                return this.count <= 4L;
            }
            case SSHORT: {
                return this.count <= 2L;
            }
            case SLONG: {
                return this.count <= 1L;
            }
            case SRATIONAL: {
                return false;
            }
            case FLOAT: {
                return this.count <= 1L;
            }
            case DOUBLE: {
                return false;
            }
        }
        return true;
    }

    public long getLength() {
        switch (IFDDataType.valueOf(this.typeNumber)) {
            case ASCII: {
                return this.count;
            }
            case BYTE: {
                return this.count;
            }
            case SHORT: {
                return this.count * 2L;
            }
            case LONG: {
                return this.count * 4L;
            }
            case RATIONAL: {
                return this.count * 8L;
            }
            case SBYTE: {
                return this.count;
            }
            case UNDEFINED: {
                return this.count;
            }
            case SSHORT: {
                return this.count * 2L;
            }
            case SLONG: {
                return this.count * 4L;
            }
            case SRATIONAL: {
                return this.count * 8L;
            }
            case FLOAT: {
                return this.count * 4L;
            }
            case DOUBLE: {
                return this.count * 8L;
            }
        }
        return 0L;
    }

    public Object readData(TIFFInputStream in) throws IOException {
        return this.readData(in, this.ifdOffset);
    }

    public Object readData(TIFFInputStream in, long ifdDataOffset) throws IOException {
        Object d = null;
        IFDDataType tt = IFDDataType.valueOf(this.typeNumber);
        if (tt != null) {
            switch (tt) {
                case ASCII: {
                    if (this.count <= 4L) {
                        StringBuilder buf = new StringBuilder();
                        int data = (int)this.valueOffset;
                        if (in.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                            int i = 0;
                            while ((long)i < this.count - 1L) {
                                buf.append((char)(data & 0xFF));
                                data >>= 8;
                                ++i;
                            }
                        } else {
                            int i = 0;
                            while ((long)i < this.count - 1L) {
                                buf.append((char)(data >>> 24));
                                data <<= 8;
                                ++i;
                            }
                        }
                        return buf.toString();
                    }
                    return in.readASCII(this.valueOffset + ifdDataOffset, this.count);
                }
                case SHORT: {
                    if (this.count == 1L) {
                        if (in.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                            d = (int)(this.valueOffset & 0xFFFFL);
                            break;
                        }
                        d = (int)(this.valueOffset >> 16 & 0xFFFFL);
                        break;
                    }
                    if (this.count == 2L) {
                        d = new int[]{(int)(this.valueOffset & 0xFFFFL), (int)((this.valueOffset & 0xFFFFFFFFFFFF0000L) >> 16)};
                        break;
                    }
                    d = in.readSHORT(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                case LONG: {
                    if (this.count == 1L) {
                        d = this.valueOffset;
                        break;
                    }
                    d = in.readLONG(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                case RATIONAL: {
                    if (this.count == 1L) {
                        d = in.readRATIONAL(this.valueOffset + ifdDataOffset);
                        break;
                    }
                    d = in.readRATIONAL(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                case BYTE: {
                    if (this.count == 1L) {
                        d = (short)(this.valueOffset & 0xFFL);
                        break;
                    }
                    if (this.count == 2L) {
                        d = new short[]{(short)((this.valueOffset & 0xFF00L) >> 8), (short)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    if (this.count == 3L) {
                        d = new short[]{(short)((this.valueOffset & 0xFF0000L) >> 16), (short)((this.valueOffset & 0xFF00L) >> 8), (short)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    if (this.count == 4L) {
                        d = new short[]{(short)((this.valueOffset & 0xFFFFFFFFFF000000L) >> 24), (short)((this.valueOffset & 0xFF0000L) >> 16), (short)((this.valueOffset & 0xFF00L) >> 8), (short)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    byte[] b = new byte[(int)this.count];
                    in.read(this.valueOffset + ifdDataOffset, b, 0, b.length);
                    short[] s = new short[(int)this.count];
                    for (int i = 0; i < b.length; ++i) {
                        s[i] = (short)(b[i] & 0xFF);
                    }
                    d = s;
                    break;
                }
                case SBYTE: 
                case UNDEFINED: {
                    if (this.count == 1L) {
                        d = (byte)this.valueOffset;
                        break;
                    }
                    if (this.count == 2L) {
                        d = new byte[]{(byte)((this.valueOffset & 0xFF00L) >> 8), (byte)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    if (this.count == 3L) {
                        d = new byte[]{(byte)((this.valueOffset & 0xFF0000L) >> 16), (byte)((this.valueOffset & 0xFF00L) >> 8), (byte)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    if (this.count == 4L) {
                        d = new byte[]{(byte)((this.valueOffset & 0xFFFFFFFFFF000000L) >> 24), (byte)((this.valueOffset & 0xFF0000L) >> 16), (byte)((this.valueOffset & 0xFF00L) >> 8), (byte)(this.valueOffset & 0xFFL)};
                        break;
                    }
                    byte[] b = new byte[(int)this.count];
                    in.read(this.valueOffset + ifdDataOffset, b, 0, b.length);
                    d = b;
                    break;
                }
                case SSHORT: {
                    if (this.count == 1L) {
                        if (in.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                            d = (short)(this.valueOffset & 0xFFFFL);
                            break;
                        }
                        d = (short)(this.valueOffset >> 16 & 0xFFFFL);
                        break;
                    }
                    if (this.count == 2L) {
                        d = new int[]{(short)(this.valueOffset & 0xFFFFL), (short)((this.valueOffset & 0xFFFFFFFFFFFF0000L) >> 16)};
                        break;
                    }
                    d = in.readSSHORT(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                case SLONG: {
                    if (this.count == 1L) {
                        d = (int)this.valueOffset;
                        break;
                    }
                    d = in.readSLONG(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                case SRATIONAL: {
                    if (this.count == 1L) {
                        d = in.readSRATIONAL(this.valueOffset + ifdDataOffset);
                        break;
                    }
                    d = in.readSRATIONAL(this.valueOffset + ifdDataOffset, this.count);
                    break;
                }
                default: {
                    throw new IOException("Format FLOAT and DOUBLE " + this.typeNumber + " not implemented");
                }
            }
        }
        return d;
    }

    public void loadData(TIFFInputStream in) throws IOException {
        this.data = this.readData(in);
    }

    public Object getData() {
        return this.data;
    }

    public String toString() {
        return "IFD Entry: tag:0x" + Integer.toHexString(this.tagNumber) + " type:0x" + Integer.toHexString(this.typeNumber) + " count:0x" + Long.toHexString(this.count) + " valueOffset:0x" + Long.toHexString(this.valueOffset);
    }

    public String toString(Enum<?> tagName) {
        StringBuilder buf = new StringBuilder();
        buf.append("Entry tag:" + tagName + "(" + Integer.toHexString(this.tagNumber) + "), type:" + (Object)((Object)IFDDataType.valueOf(this.typeNumber)) + "(" + this.typeNumber + "), count:" + this.count + ", valueOffset:" + this.valueOffset);
        if (this.data != null) {
            buf.append(", data:");
            if (this.data instanceof byte[]) {
                byte[] d = (byte[])this.data;
                for (int i = 0; i < d.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(d[i]);
                }
            } else if (this.data instanceof short[]) {
                short[] d = (short[])this.data;
                for (int i = 0; i < d.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(d[i]);
                }
            } else if (this.data instanceof int[]) {
                int[] d = (int[])this.data;
                for (int i = 0; i < d.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(d[i]);
                }
            } else if (this.data instanceof long[]) {
                long[] d = (long[])this.data;
                for (int i = 0; i < d.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(d[i]);
                }
            } else if (this.data instanceof Object[]) {
                Object[] d = (Object[])this.data;
                for (int i = 0; i < d.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(d[i]);
                }
            } else {
                buf.append(this.data);
            }
        }
        return buf.toString();
    }
}

