/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Stack;
import ru.sbtqa.monte.media.tiff.IFDEntry;
import ru.sbtqa.monte.media.tiff.TIFFTag;

public abstract class TIFFNode {
    protected TIFFTag tag;
    private ArrayList<TIFFNode> children = new ArrayList();
    private TIFFNode parent;
    protected IFDEntry ifdEntry;
    private static final Iterator<TIFFNode> EMPTY_ITERATOR = new Iterator<TIFFNode>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public TIFFNode next() {
            throw new NoSuchElementException("No more elements");
        }

        @Override
        public void remove() {
            throw new NoSuchElementException("No more elements");
        }
    };

    public TIFFNode(TIFFTag tag) {
        this.tag = tag;
    }

    public String getTagName() {
        return this.tag == null ? "unnamed" : this.tag.getName();
    }

    public TIFFTag getTag() {
        return this.tag;
    }

    public int getTagNumber() {
        return this.tag != null ? this.tag.getNumber() : -1;
    }

    public IFDEntry getIFDEntry() {
        return this.ifdEntry;
    }

    public void add(TIFFNode node) {
        this.children.add(node);
        node.parent = this;
    }

    public ArrayList<TIFFNode> getChildren() {
        return this.children;
    }

    public TIFFNode getParent() {
        return this.parent;
    }

    public Iterator<TIFFNode> preorderIterator() {
        return new PreorderIterator(this);
    }

    public Iterator<TIFFNode> postorderIterator() {
        return new PostorderIterator(this);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public TIFFNode getChildAt(int i) {
        return this.children.get(i);
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.children.remove(this);
            this.parent = null;
        }
    }

    private static class PostorderIterator
    implements Iterator<TIFFNode> {
        protected TIFFNode root;
        protected Iterator<TIFFNode> children;
        protected Iterator<TIFFNode> subtree;
        private TIFFNode current;

        private PostorderIterator(TIFFNode rootNode) {
            this.root = rootNode;
            this.children = new ArrayList(this.root.children).iterator();
            this.subtree = EMPTY_ITERATOR;
        }

        @Override
        public boolean hasNext() {
            return this.root != null;
        }

        @Override
        public TIFFNode next() {
            if (this.subtree.hasNext()) {
                this.current = this.subtree.next();
            } else if (this.children.hasNext()) {
                this.subtree = new PostorderIterator(this.children.next());
                this.current = this.subtree.next();
            } else {
                this.current = this.root;
                this.root = null;
            }
            return this.current;
        }

        @Override
        public void remove() {
            this.current.removeFromParent();
        }
    }

    private static class PreorderIterator
    implements Iterator<TIFFNode> {
        private Stack<Iterator<TIFFNode>> stack = new Stack();
        private TIFFNode current;

        private PreorderIterator(TIFFNode root) {
            LinkedList<TIFFNode> ll = new LinkedList<TIFFNode>();
            ll.add(root);
            this.stack.push(ll.iterator());
        }

        @Override
        public boolean hasNext() {
            return !this.stack.empty() && this.stack.peek().hasNext();
        }

        @Override
        public TIFFNode next() {
            ArrayList<TIFFNode> children;
            Iterator<TIFFNode> enumer = this.stack.peek();
            this.current = enumer.next();
            if (!enumer.hasNext()) {
                this.stack.pop();
            }
            if (!(children = this.current.getChildren()).isEmpty()) {
                this.stack.push(children.iterator());
            }
            return this.current;
        }

        @Override
        public void remove() {
            this.current.removeFromParent();
        }
    }
}

