/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.media.tiff;

import ru.sbtqa.monte.media.tiff.IFDDataType;
import ru.sbtqa.monte.media.tiff.TagSet;
import ru.sbtqa.monte.media.tiff.ValueFormatter;

public class TIFFTag {
    public static final int ASCII_MASK = 1 << IFDDataType.ASCII.getTypeNumber();
    public static final int BYTE_MASK = 1 << IFDDataType.BYTE.getTypeNumber();
    public static final int DOUBLE_MASK = 1 << IFDDataType.DOUBLE.getTypeNumber();
    public static final int FLOAT_MASK = 1 << IFDDataType.FLOAT.getTypeNumber();
    public static final int IFD_MASK = 1 << IFDDataType.IFD.getTypeNumber();
    public static final int LONG_MASK = 1 << IFDDataType.LONG.getTypeNumber();
    public static final int SHORT_MASK = 1 << IFDDataType.SHORT.getTypeNumber();
    public static final int RATIONAL_MASK = 1 << IFDDataType.RATIONAL.getTypeNumber();
    public static final int SBYTE_MASK = 1 << IFDDataType.BYTE.getTypeNumber();
    public static final int SLONG_MASK = 1 << IFDDataType.SLONG.getTypeNumber();
    public static final int SSHORT_MASK = 1 << IFDDataType.SSHORT.getTypeNumber();
    public static final int SRATIONAL_MASK = 1 << IFDDataType.SRATIONAL.getTypeNumber();
    public static final int UNDEFINED_MASK = 1 << IFDDataType.UNDEFINED.getTypeNumber();
    public static final int ALL_MASK = -1;
    private String name;
    private int number;
    private int dataTypes;
    private TagSet tagSet;
    private ValueFormatter formatter;

    public TIFFTag(String name, int number, int dataTypes, ValueFormatter formatter) {
        this.name = name;
        this.number = number;
        this.dataTypes = dataTypes;
        this.formatter = formatter;
    }

    public TIFFTag(String name, int number, int dataTypes) {
        this(name, number, dataTypes, null);
    }

    void setTagSet(TagSet tagSet) {
        this.tagSet = tagSet;
    }

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSynthetic() {
        return this.number < 0;
    }

    public Object prettyFormat(Object data) {
        return this.formatter == null ? data : this.formatter.prettyFormat(data);
    }

    public Object format(Object data) {
        return this.formatter == null ? data : this.formatter.format(data);
    }

    public String toString() {
        return this.name;
    }

    public String getDescription(Object data) {
        return this.formatter == null ? null : this.formatter.descriptionFormat(data);
    }
}

