/*
 * Decompiled with CFR 0.152.
 */
package ru.sbtqa.monte.screenrecorder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;
import ru.sbtqa.monte.screenrecorder.ScreenRecorder;

public class JAudioMonitor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Timer timer;
    private Color semiTransparent = new Color(0x40FFFFFF, true);
    private Handler handler = new Handler();
    private ScreenRecorder recorder;

    public JAudioMonitor() {
        this.initComponents();
        this.setOpaque(false);
        this.setPreferredSize(new Dimension(7, 16));
        this.setMinimumSize(new Dimension(7, 16));
    }

    public ScreenRecorder getScreenRecorder() {
        return this.recorder;
    }

    public void setScreenRecorder(ScreenRecorder recorder) {
        this.recorder = recorder;
    }

    public void start() {
        if (this.timer == null) {
            this.timer = new Timer(250, this.handler);
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.recorder != null) {
            int levelHeight;
            float level = this.recorder.getAudioLevelLeft();
            if (level != -1.0f) {
                levelHeight = Math.min(h, (int)((float)(h * 7) * level));
                g.setColor(this.semiTransparent);
                g.fillRect(0, 0, 3, h - levelHeight);
                g.setColor(Color.WHITE);
                g.fillRect(0, h - levelHeight, 3, levelHeight);
            }
            if ((level = this.recorder.getAudioLevelRight()) != -1.0f) {
                levelHeight = Math.min(h, (int)((float)(h * 7) * level));
                g.setColor(this.semiTransparent);
                g.fillRect(4, 0, 3, h - levelHeight);
                g.setColor(Color.WHITE);
                g.fillRect(4, h - levelHeight, 3, levelHeight);
            }
        }
    }

    private void initComponents() {
    }

    private class Handler
    implements ActionListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JAudioMonitor.this.repaint();
        }
    }
}

